/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.controls;

import boofcv.factory.feature.associate.ConfigAssociate;
import boofcv.factory.feature.describe.ConfigDescribeRegion;
import boofcv.factory.feature.detect.interest.ConfigDetectInterestPoint;
import boofcv.gui.controls.ControlPanelDetDescAssocBase;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class ControlPanelDdaComboTabs
extends ControlPanelDetDescAssocBase {
    final JPanel panelDetector = new JPanel(new BorderLayout());
    final JPanel panelDescriptor = new JPanel(new BorderLayout());
    final JPanel panelAssociate = new JPanel(new BorderLayout());
    final Listener listener;

    public ControlPanelDdaComboTabs(Listener listener, boolean setupGUI) {
        this.listener = listener;
        if (setupGUI) {
            this.initializeControlsGUI();
            this.layoutComponents();
            this.handleDetectorChanged();
            this.handleDescriptorChanged();
            this.handleAssociatorChanged();
        }
    }

    protected void layoutComponents() {
        JTabbedPane tabbed = new JTabbedPane();
        tabbed.addTab("Detect", this.panelDetector);
        tabbed.addTab("Describe", this.panelDescriptor);
        tabbed.addTab("Associate", this.panelAssociate);
        this.addLabeled(this.comboDetect, "Detect");
        this.addLabeled(this.comboDescribe, "Describe");
        this.addLabeled(this.comboAssociate, "Associate");
        this.add(tabbed);
    }

    protected void handleDetectorChanged() {
        this.panelDetector.removeAll();
        this.panelDetector.add((Component)this.getDetectorPanel(), "Center");
        this.panelDetector.invalidate();
        this.panelDetector.repaint();
    }

    protected void handleDescriptorChanged() {
        this.panelDescriptor.removeAll();
        this.panelDescriptor.add((Component)this.getDescriptorPanel(), "Center");
        this.panelDescriptor.invalidate();
        this.panelDescriptor.repaint();
        if (this.configDetDesc.typeDescribe == ConfigDescribeRegion.Type.BRIEF) {
            if (this.configAssociate.type != ConfigAssociate.AssociationType.GREEDY) {
                this.comboAssociate.setSelectedIndex(ConfigAssociate.AssociationType.GREEDY.ordinal());
            }
            this.comboAssociate.setEnabled(false);
        } else {
            this.comboAssociate.setEnabled(true);
        }
    }

    protected void handleAssociatorChanged() {
        this.panelAssociate.removeAll();
        this.panelAssociate.add((Component)this.getAssociatePanel(), "Center");
        this.panelAssociate.invalidate();
        this.panelAssociate.repaint();
    }

    @Override
    public void controlChanged(Object source) {
        if (this.comboDetect == source) {
            this.configDetDesc.typeDetector = ConfigDetectInterestPoint.Type.values()[this.comboDetect.getSelectedIndex()];
            this.handleDetectorChanged();
        } else if (this.comboDescribe == source) {
            this.configDetDesc.typeDescribe = ConfigDescribeRegion.Type.values()[this.comboDescribe.getSelectedIndex()];
            this.handleDescriptorChanged();
        } else if (this.comboAssociate == source) {
            this.configAssociate.type = ConfigAssociate.AssociationType.values()[this.comboAssociate.getSelectedIndex()];
            this.handleAssociatorChanged();
        }
        this.listener.handleDdaControlsUpdated();
    }

    @Override
    protected void handleControlsUpdated() {
        this.listener.handleDdaControlsUpdated();
    }

    public static interface Listener {
        public void handleDdaControlsUpdated();
    }
}

