/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.calibration;

import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.LensDistortionWideFOV;
import boofcv.alg.distort.NarrowToWidePtoP_F32;
import boofcv.alg.distort.pinhole.LensDistortionPinhole;
import boofcv.alg.interpolate.InterpolatePixel;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.factory.distort.FactoryDistort;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.gui.BoofSwingUtil;
import boofcv.gui.calibration.DisplayCalibrationPanel;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.border.BorderType;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.distort.PointToPixelTransform_F32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.Planar;
import georegression.geometry.ConvertRotation3D_F32;
import georegression.geometry.GeometryMath_F32;
import georegression.geometry.UtilVector3D_F32;
import georegression.struct.GeoTuple3D_F32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Vector3D_F32;
import georegression.struct.so.Rodrigues_F32;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Objects;
import javax.swing.SwingUtilities;
import org.ejml.data.FMatrixRMaj;
import org.jetbrains.annotations.Nullable;

public class DisplayFisheyeCalibrationPanel
extends DisplayCalibrationPanel {
    @Nullable
    NarrowToWidePtoP_F32 distorter;
    @Nullable
    LensDistortionWideFOV fisheyeDistort;
    ImageDistort<Planar<GrayF32>, Planar<GrayF32>> distortImage;
    Planar<GrayF32> imageFisheye = new Planar<GrayF32>(GrayF32.class, 1, 1, 3);
    Planar<GrayF32> imageRendered = new Planar<GrayF32>(GrayF32.class, 1, 1, 3);
    BufferedImage bufferedRendered;
    CameraPinhole pinholeModel = new CameraPinhole(200.0, 200.0, 0.0, 200.0, 200.0, 400, 400);
    double pixelX;
    double pixelY;
    AffineTransform renderTran = new AffineTransform();

    public DisplayFisheyeCalibrationPanel() {
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                this.changeFocus(e);
            }

            private void changeFocus(MouseEvent e) {
                double omniY;
                double omniX = (double)e.getX() / DisplayFisheyeCalibrationPanel.this.scale;
                if (!DisplayFisheyeCalibrationPanel.this.imageFisheye.isInBounds((int)omniX, (int)(omniY = (double)e.getY() / DisplayFisheyeCalibrationPanel.this.scale))) {
                    return;
                }
                DisplayFisheyeCalibrationPanel.this.setPinholeCenter(omniX, omniY);
                DisplayFisheyeCalibrationPanel.this.renderPinhole();
                DisplayFisheyeCalibrationPanel.this.repaint();
            }
        };
        this.panel.addMouseMotionListener(adapter);
        this.panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (DisplayFisheyeCalibrationPanel.this.showUndistorted) {
                    return;
                }
                DisplayFisheyeCalibrationPanel.this.panel.requestFocus();
                if (SwingUtilities.isLeftMouseButton(e)) {
                    Point2D_F64 p = DisplayFisheyeCalibrationPanel.this.pixelToPoint(e.getX(), e.getY());
                    DisplayFisheyeCalibrationPanel.this.centerView(p.x, p.y);
                }
            }
        });
    }

    @Override
    public synchronized void setBufferedImageNoChange(@Nullable BufferedImage image) {
        super.setBufferedImageNoChange(image);
        if (image == null) {
            return;
        }
        ConvertBufferedImage.convertFrom(image, this.imageFisheye, true);
        if (this.imageFisheye.getNumBands() != this.imageRendered.getNumBands()) {
            this.imageRendered = this.imageFisheye.createNew(1, 1);
        }
        this.renderPinhole();
    }

    public void setCalibration(LensDistortionWideFOV fisheyeDistort, int width, int height) {
        BoofSwingUtil.checkGuiThread();
        this.fisheyeDistort = fisheyeDistort;
        LensDistortionPinhole pinholeDistort = new LensDistortionPinhole(this.pinholeModel);
        this.distorter = new NarrowToWidePtoP_F32(pinholeDistort, fisheyeDistort);
        InterpolatePixel interp = FactoryInterpolation.createPixel(0.0, 255.0, InterpolationType.BILINEAR, BorderType.ZERO, this.imageFisheye.getImageType());
        this.distortImage = FactoryDistort.distort(false, interp, this.imageFisheye.getImageType());
        this.distortImage.setModel(new PointToPixelTransform_F32(this.distorter));
        this.setPinholeCenter(width / 2, height / 2);
        this.renderPinhole();
    }

    public void setPinholeCenter(double pixelX, double pixelY) {
        this.pixelX = pixelX;
        this.pixelY = pixelY;
        Point3D_F32 norm = new Point3D_F32();
        Objects.requireNonNull(this.fisheyeDistort);
        this.fisheyeDistort.undistortPtoS_F32().compute((float)pixelX, (float)pixelY, norm);
        Rodrigues_F32 rotation = new Rodrigues_F32();
        Vector3D_F32 canonical = new Vector3D_F32(0.0f, 0.0f, 1.0f);
        rotation.theta = UtilVector3D_F32.acute(new Vector3D_F32(norm), canonical);
        GeometryMath_F32.cross(canonical, (GeoTuple3D_F32)norm, (GeoTuple3D_F32)rotation.unitAxisRotation);
        rotation.unitAxisRotation.normalize();
        FMatrixRMaj R = ConvertRotation3D_F32.rodriguesToMatrix(rotation, null);
        Objects.requireNonNull(this.distorter);
        this.distorter.setRotationWideToNarrow(R);
        this.distortImage.setModel(new PointToPixelTransform_F32(this.distorter));
    }

    private void renderPinhole() {
        if (this.distortImage == null) {
            return;
        }
        this.imageRendered.reshape(this.pinholeModel.width, this.pinholeModel.height);
        this.distortImage.apply(this.imageFisheye, this.imageRendered);
        this.bufferedRendered = ConvertBufferedImage.checkDeclare(this.imageRendered.width, this.imageRendered.height, this.bufferedRendered, 1);
        ConvertBufferedImage.convertTo(this.imageRendered, this.bufferedRendered, true);
    }

    @Override
    protected void paintInPanel(AffineTransform tran, Graphics2D g2) {
        this.drawFeatures(g2, this.scale);
        if (!this.showUndistorted || this.bufferedRendered == null || this.img == null) {
            return;
        }
        double scaleSize = (double)(this.img.getWidth() / 2) / (double)this.bufferedRendered.getWidth();
        double offX = (this.pixelX - scaleSize * (double)this.bufferedRendered.getWidth() / 2.0) * this.scale;
        double offY = (this.pixelY - scaleSize * (double)this.bufferedRendered.getHeight() / 2.0) * this.scale;
        this.renderTran.setTransform(this.scale * scaleSize, 0.0, 0.0, this.scale * scaleSize, offX, offY);
        g2.drawImage(this.bufferedRendered, this.renderTran, null);
    }

    @Override
    public void clearCalibration() {
        this.fisheyeDistort = null;
        this.distorter = null;
    }
}

