/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.calibration;

import boofcv.abst.geo.calibration.ImageResults;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.gui.BoofSwingUtil;
import boofcv.gui.calibration.UtilCalibrationGui;
import boofcv.gui.feature.VisualizeFeatures;
import boofcv.gui.image.ImageZoomPanel;
import boofcv.struct.distort.DoNothing2Transform2_F32;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.geo.PointIndex2D_F64;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public abstract class DisplayCalibrationPanel
extends ImageZoomPanel {
    double canonicalClickDistance = 15.0;
    public boolean showPoints = true;
    public boolean showErrors = true;
    public boolean showUndistorted = false;
    public boolean showAll = false;
    public boolean showNumbers = true;
    public boolean showOrder = true;
    public boolean showResiduals = false;
    public double errorScale;
    protected int selectedObservation = -1;
    @Nullable
    CalibrationObservation observation = null;
    @Nullable
    public ImageResults results = null;
    @Nullable
    List<CalibrationObservation> allObservations = null;
    protected Point2Transform2_F32 pixelTransform = new DoNothing2Transform2_F32();
    protected Point2D_F32 adj = new Point2D_F32();
    protected Point2D_F32 adj2 = new Point2D_F32();
    protected Ellipse2D.Double ellipse = new Ellipse2D.Double();
    protected Line2D.Double line = new Line2D.Double();
    public SetScale setScale = s -> {};
    final Color lightRed = new Color(255, 150, 150);

    protected DisplayCalibrationPanel() {
        this.panel.addMouseWheelListener(e -> this.setScale(BoofSwingUtil.mouseWheelImageZoom(this.scale, e)));
        this.panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DisplayCalibrationPanel.this.panel.requestFocus();
                if (!SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                CalibrationObservation features = DisplayCalibrationPanel.this.observation;
                if (features == null) {
                    return;
                }
                DisplayCalibrationPanel.this.selectedObservation = DisplayCalibrationPanel.this.findClickedPoint(e, features);
                DisplayCalibrationPanel.this.repaint();
            }
        });
    }

    protected int findClickedPoint(MouseEvent e, CalibrationObservation features) {
        double bestDistanceSq = this.canonicalClickDistance / this.scale;
        bestDistanceSq *= bestDistanceSq;
        int bestIndex = -1;
        Point2D_F64 p = this.pixelToPoint(e.getX(), e.getY());
        for (int i = 0; i < features.points.size(); ++i) {
            Point2D_F64 f = (Point2D_F64)features.points.get((int)i).p;
            this.pixelTransform.compute((float)f.x, (float)f.y, this.adj);
            double d = p.distance2(this.adj.x, this.adj.y);
            if (!(d <= bestDistanceSq)) continue;
            bestDistanceSq = d;
            bestIndex = i;
        }
        return bestIndex;
    }

    public void setResults(CalibrationObservation features, @Nullable ImageResults results, List<CalibrationObservation> allFeatures) {
        BoofSwingUtil.checkGuiThread();
        this.observation = features;
        this.results = results;
        this.allObservations = allFeatures;
        this.selectedObservation = -1;
    }

    public void clearResults() {
        BoofSwingUtil.checkGuiThread();
        this.observation = null;
        this.results = null;
        this.allObservations = null;
        this.selectedObservation = -1;
    }

    public void setDisplay(boolean showPoints, boolean showErrors, boolean showUndistorted, boolean showAll, boolean showNumbers, boolean showOrder, double errorScale) {
        this.showPoints = showPoints;
        this.showErrors = showErrors;
        this.showUndistorted = showUndistorted;
        this.showAll = showAll;
        this.showNumbers = showNumbers;
        this.showOrder = showOrder;
        this.errorScale = errorScale;
    }

    @Override
    public synchronized void setScale(double scale) {
        if (this.scale == scale) {
            return;
        }
        super.setScale(scale);
        this.setScale.setScale(scale);
    }

    public abstract void clearCalibration();

    public void deselectPoint() {
        this.selectedObservation = -1;
    }

    protected void drawFeatures(Graphics2D g2, double scale) {
        PointIndex2D_F64 p2;
        int i;
        if (this.observation == null || this.allObservations == null) {
            return;
        }
        BoofSwingUtil.antialiasing(g2);
        CalibrationObservation set = this.observation;
        if (this.showOrder) {
            UtilCalibrationGui.renderOrder(g2, this.pixelTransform, scale, set.points);
        }
        if (this.showResiduals && this.results != null) {
            g2.setStroke(new BasicStroke(4.0f));
            g2.setColor(Color.GREEN);
            for (i = 0; i < set.size(); ++i) {
                p2 = set.get(i);
                float dx = (float)this.results.residuals[i * 2];
                float dy = (float)this.results.residuals[i * 2 + 1];
                this.pixelTransform.compute((float)((Point2D_F64)p2.p).x, (float)((Point2D_F64)p2.p).y, this.adj);
                this.pixelTransform.compute((float)((Point2D_F64)p2.p).x + dx, (float)((Point2D_F64)p2.p).y + dy, this.adj2);
                this.line.setLine(scale * (double)this.adj.x, scale * (double)this.adj.y, scale * (double)this.adj2.x, scale * (double)this.adj2.y);
                g2.draw(this.line);
            }
        }
        if (this.showPoints) {
            g2.setColor(Color.BLACK);
            g2.setStroke(new BasicStroke(5.0f));
            for (PointIndex2D_F64 p2 : set.points) {
                this.pixelTransform.compute((float)((Point2D_F64)p2.p).x, (float)((Point2D_F64)p2.p).y, this.adj);
                VisualizeFeatures.drawCross(g2, (double)this.adj.x * scale, (double)this.adj.y * scale, 5.0);
            }
            g2.setStroke(new BasicStroke(2.0f));
            g2.setColor(this.lightRed);
            for (PointIndex2D_F64 p2 : set.points) {
                this.pixelTransform.compute((float)((Point2D_F64)p2.p).x, (float)((Point2D_F64)p2.p).y, this.adj);
                VisualizeFeatures.drawCross(g2, (double)this.adj.x * scale, (double)this.adj.y * scale, 5.0);
            }
        }
        if (this.showAll) {
            for (CalibrationObservation l : this.allObservations) {
                for (PointIndex2D_F64 p3 : l.points) {
                    this.pixelTransform.compute((float)((Point2D_F64)p3.p).x, (float)((Point2D_F64)p3.p).y, this.adj);
                    VisualizeFeatures.drawPoint(g2, (double)this.adj.x * scale, (double)this.adj.y * scale, 3.0, Color.BLUE, Color.WHITE, this.ellipse);
                }
            }
        }
        if (this.showNumbers) {
            UtilCalibrationGui.drawNumbers(g2, set.points, this.pixelTransform, scale);
        }
        if (this.showErrors && this.results != null) {
            g2.setStroke(new BasicStroke(4.0f));
            g2.setColor(Color.BLACK);
            for (i = 0; i < set.size(); ++i) {
                p2 = set.get(i);
                this.pixelTransform.compute((float)((Point2D_F64)p2.p).x, (float)((Point2D_F64)p2.p).y, this.adj);
                double r = this.errorScale * this.results.pointError[i];
                if (r < 1.0) continue;
                VisualizeFeatures.drawCircle(g2, (double)this.adj.x * scale, (double)this.adj.y * scale, r, this.ellipse);
            }
            g2.setStroke(new BasicStroke(2.5f));
            g2.setColor(Color.ORANGE);
            for (i = 0; i < set.size(); ++i) {
                p2 = set.get(i);
                this.pixelTransform.compute((float)((Point2D_F64)p2.p).x, (float)((Point2D_F64)p2.p).y, this.adj);
                double r = this.errorScale * this.results.pointError[i];
                if (r < 1.0) continue;
                VisualizeFeatures.drawCircle(g2, (double)this.adj.x * scale, (double)this.adj.y * scale, r, this.ellipse);
            }
        }
        if (this.selectedObservation >= 0 && this.selectedObservation < set.size()) {
            PointIndex2D_F64 p4 = set.get(this.selectedObservation);
            this.pixelTransform.compute((float)((Point2D_F64)p4.p).x, (float)((Point2D_F64)p4.p).y, this.adj);
            VisualizeFeatures.drawPoint(g2, (double)this.adj.x * scale, (double)this.adj.y * scale, 10.0, Color.GREEN, true, this.ellipse);
        }
    }

    public int getSelectedObservation() {
        return this.selectedObservation;
    }

    @Nullable
    public CalibrationObservation getObservation() {
        return this.observation;
    }

    @Nullable
    public ImageResults getResults() {
        return this.results;
    }

    @FunctionalInterface
    public static interface SetScale {
        public void setScale(double var1);
    }
}

