/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui;

import boofcv.gui.BoofSwingUtil;
import boofcv.gui.controls.JCheckBoxValue;
import boofcv.gui.controls.JConfigLength;
import boofcv.gui.controls.JSpinnerNumber;
import boofcv.misc.BoofLambdas;
import boofcv.struct.ConfigLength;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nullable;

public class StandardAlgConfigPanel
extends JPanel
implements ActionListener,
ChangeListener,
JConfigLength.Listener {
    public StandardAlgConfigPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEtchedBorder(0));
    }

    public JFormattedTextField textfield(double value, double min, double max, int panelWidth) {
        JFormattedTextField field = BoofSwingUtil.createTextField(value, min, max);
        field.addActionListener(this);
        field.setPreferredSize(new Dimension(panelWidth, 24));
        field.setMaximumSize(field.getPreferredSize());
        return field;
    }

    public static JPanel fillHorizontally(JPanel panel) {
        JPanel hack = new JPanel(new BorderLayout()){

            @Override
            public Dimension getPreferredSize() {
                Dimension p = super.getPreferredSize();
                p.width = Short.MAX_VALUE;
                return p;
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        hack.add((Component)panel, "Center");
        return hack;
    }

    protected void addToolTip(JComponent component, String toolTip) {
        component.setToolTipText(toolTip);
        this.add(component);
    }

    public JConfigLength configLength(ConfigLength initial, double min, double max) {
        JConfigLength control = new JConfigLength(this, true);
        control.setValue(initial);
        control.setLengthBounds(min, max);
        control.setMaximumSize(control.getPreferredSize());
        return control;
    }

    public JConfigLength configLength(ConfigLength initial, double min, double max, BoofLambdas.ProcessCall listener) {
        JConfigLength.Listener cl = (source, fraction, length) -> listener.process();
        JConfigLength control = new JConfigLength(cl, true);
        control.setValue(initial);
        control.setLengthBounds(min, max);
        control.setMaximumSize(control.getPreferredSize());
        return control;
    }

    public JButton buttonIcon(String name, boolean enabled) {
        JButton b = BoofSwingUtil.createButtonIconGUI(name, 24, 24);
        b.setEnabled(enabled);
        b.addActionListener(this);
        return b;
    }

    public JButton button(String name, boolean enabled) {
        return this.button(name, enabled, this);
    }

    public JButton button(String name, boolean enabled, ActionListener listener) {
        JButton b = new JButton(name);
        b.setEnabled(enabled);
        b.addActionListener(listener);
        return b;
    }

    public JSlider slider(int min, int max, int initial, int widgetWidth) {
        JSlider slider = new JSlider(min, max, initial);
        slider.setMaximumSize(new Dimension(widgetWidth, 24));
        slider.setPreferredSize(slider.getMaximumSize());
        slider.addChangeListener(this);
        return slider;
    }

    public JComboBox<String> combo(int initial, Object ... items) {
        JComboBox<String> c = new JComboBox<String>();
        for (int i = 0; i < items.length; ++i) {
            c.addItem(items[i].toString());
        }
        c.setSelectedIndex(initial);
        c.addActionListener(this);
        c.setMaximumSize(c.getPreferredSize());
        return c;
    }

    public JComboBox<String> combo(ActionListener listener, int initial, Object ... items) {
        JComboBox<String> c = new JComboBox<String>();
        for (int i = 0; i < items.length; ++i) {
            c.addItem(items[i].toString());
        }
        c.setSelectedIndex(initial);
        if (listener != null) {
            c.addActionListener(listener);
        }
        c.setMaximumSize(c.getPreferredSize());
        return c;
    }

    public JSpinner spinner(int initial, Object[] items) {
        JSpinner spinner = new JSpinner(new SpinnerListModel(items));
        spinner.setValue(items[initial]);
        spinner.setMaximumSize(spinner.getPreferredSize());
        spinner.addChangeListener(this);
        return spinner;
    }

    public JSpinner spinner(int initial, int minimum, int maximum, int stepSize, ChangeListener listener) {
        JSpinner spinner = new JSpinner(new SpinnerNumberModel(initial, minimum, maximum, stepSize));
        spinner.setMaximumSize(spinner.getPreferredSize());
        spinner.addChangeListener(listener);
        return spinner;
    }

    public JSpinner spinner(int initial, int minimum, int maximum, int stepSize) {
        JSpinner spinner = new JSpinner(new SpinnerNumberModel(initial, minimum, maximum, stepSize));
        spinner.setMaximumSize(spinner.getPreferredSize());
        spinner.addChangeListener(this);
        return spinner;
    }

    public JSpinner spinner(double initial, double minimum, double maximum, double stepSize) {
        JSpinner spinner = new JSpinner(new SpinnerNumberModel(initial, minimum, maximum, stepSize));
        spinner.setMaximumSize(spinner.getPreferredSize());
        spinner.addChangeListener(this);
        return spinner;
    }

    public JSpinner spinner(double initial, double minimum, double maximum, double stepSize, int integerDigits, int fractionDigits) {
        JSpinner spinner = new JSpinner(new SpinnerNumberModel(initial, minimum, maximum, stepSize));
        JSpinner.NumberEditor editor = (JSpinner.NumberEditor)spinner.getEditor();
        DecimalFormat format = editor.getFormat();
        format.setMinimumFractionDigits(fractionDigits);
        format.setMinimumIntegerDigits(integerDigits);
        editor.getTextField().setHorizontalAlignment(0);
        Dimension d = spinner.getPreferredSize();
        d.width = (integerDigits + 1 + fractionDigits) * 12;
        spinner.setPreferredSize(d);
        spinner.setMaximumSize(d);
        spinner.setValue(1.0 - initial);
        spinner.setValue(initial);
        spinner.addChangeListener(this);
        return spinner;
    }

    public JSpinnerNumber spinnerWrap(double initial, double minimum, double maximum, double stepSize) {
        JSpinner spinner = new JSpinner(new SpinnerNumberModel(initial, minimum, maximum, stepSize));
        spinner.setMaximumSize(spinner.getPreferredSize());
        JSpinnerNumber wrap = new JSpinnerNumber(spinner, initial);
        spinner.addChangeListener(e -> {
            wrap.updateValue();
            this.stateChanged(e);
        });
        return wrap;
    }

    public JSpinnerNumber spinnerWrap(int initial, int minimum, int maximum, int stepSize) {
        JSpinner spinner = new JSpinner(new SpinnerNumberModel(initial, minimum, maximum, stepSize));
        spinner.setMaximumSize(spinner.getPreferredSize());
        JSpinnerNumber wrap = new JSpinnerNumber(spinner, initial);
        spinner.addChangeListener(e -> {
            wrap.updateValue();
            this.stateChanged(e);
        });
        return wrap;
    }

    public JSpinner spinner(double initial, double minimum, double maximum, double stepSize, String formatString, int digits) {
        JSpinner spinner = new JSpinner(new SpinnerNumberModel(initial, minimum, maximum, stepSize));
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(spinner, formatString);
        spinner.setEditor(editor);
        editor.getTextField().setHorizontalAlignment(0);
        Dimension d = spinner.getPreferredSize();
        d.width = digits * 9;
        spinner.setPreferredSize(d);
        spinner.setMaximumSize(d);
        spinner.setValue(1.0 - initial);
        spinner.setValue(initial);
        spinner.addChangeListener(this);
        return spinner;
    }

    public void configureSpinnerFloat(JSpinner spinner, int integerDigits, int fractionDigits) {
        double min = ((Number)((Object)((SpinnerNumberModel)spinner.getModel()).getMinimum())).doubleValue();
        int adjust = min < 0.0 ? 1 : 0;
        JSpinner.NumberEditor editor = (JSpinner.NumberEditor)spinner.getEditor();
        DecimalFormat format = editor.getFormat();
        format.setMinimumFractionDigits(fractionDigits);
        format.setMinimumIntegerDigits(integerDigits);
        editor.getTextField().setHorizontalAlignment(0);
        Dimension d = spinner.getPreferredSize();
        d.width = (adjust + integerDigits + 1 + fractionDigits) * 11;
        spinner.setPreferredSize(d);
        spinner.setMaximumSize(d);
    }

    public JCheckBox checkbox(String text, boolean value) {
        return this.checkbox(text, value, null);
    }

    public JCheckBox checkbox(String text, boolean value, @Nullable String tooltip) {
        JCheckBox c = new JCheckBox(text);
        c.setSelected(value);
        c.addActionListener(this);
        if (tooltip != null) {
            c.setToolTipText(tooltip);
        }
        return c;
    }

    public JCheckBoxValue checkboxWrap(String text, boolean value) {
        JCheckBox c = new JCheckBox(text);
        c.setSelected(value);
        JCheckBoxValue wrap = new JCheckBoxValue(c, value);
        c.addActionListener(e -> {
            wrap.updateValue();
            this.actionPerformed(e);
        });
        return wrap;
    }

    public void addAlignLeft(JComponent target, String tooltip) {
        target.setToolTipText(tooltip);
        StandardAlgConfigPanel.addAlignLeft(target, this);
    }

    public void addAlignRight(JComponent target, String tooltip) {
        target.setToolTipText(tooltip);
        StandardAlgConfigPanel.addAlignRight(target, this);
    }

    public void addAlignCenter(JComponent target, String tooltip) {
        target.setToolTipText(tooltip);
        StandardAlgConfigPanel.addAlignCenter(target, this);
    }

    public void addAlignLeft(JComponent target) {
        StandardAlgConfigPanel.addAlignLeft(target, this);
    }

    public void addAlignRight(JComponent target) {
        StandardAlgConfigPanel.addAlignRight(target, this);
    }

    public void addAlignCenter(JComponent target) {
        StandardAlgConfigPanel.addAlignCenter(target, this);
    }

    public static void addAlignLeft(JComponent target, JPanel owner) {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(target);
        p.add(Box.createHorizontalGlue());
        owner.add(p);
    }

    public static void addAlignRight(JComponent target, JPanel owner) {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(Box.createHorizontalGlue());
        p.add(target);
        owner.add(p);
    }

    public static void addAlignCenter(JComponent target, JPanel owner) {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(Box.createHorizontalGlue());
        p.add(target);
        p.add(Box.createHorizontalGlue());
        owner.add(p);
    }

    public void addCenterLabel(String text) {
        this.addCenterLabel(text, this);
    }

    public void addCenterLabel(String text, JPanel owner) {
        JLabel l = new JLabel(text);
        l.setAlignmentX(0.5f);
        owner.add(l);
        owner.add(Box.createRigidArea(new Dimension(1, 8)));
    }

    public void addSeparator(int width) {
        this.add(Box.createRigidArea(new Dimension(1, 8)));
        JSeparator separator = new JSeparator(0);
        separator.setMaximumSize(new Dimension(width, 5));
        this.add(separator);
        this.add(Box.createRigidArea(new Dimension(1, 8)));
    }

    public void addSeparator() {
        this.add(Box.createRigidArea(new Dimension(1, 8)));
        this.add(new JSeparator());
        this.add(Box.createRigidArea(new Dimension(1, 8)));
    }

    public void addLabeled(JComponent target, String text) {
        this.addLabeled(target, text, null);
    }

    public void addLabeled(JComponent target, String text, @Nullable String tooltip) {
        StandardAlgConfigPanel.addLabeled(target, text, tooltip, this);
    }

    public static void addLabeled(JComponent target, String text, @Nullable String tooltip, JPanel owner) {
        JLabel label = new JLabel(text);
        label.setLabelFor(target);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(label);
        p.add(Box.createHorizontalGlue());
        p.add(target);
        owner.add(p);
        if (tooltip != null) {
            label.setToolTipText(tooltip);
            target.setToolTipText(tooltip);
        }
    }

    public static JPanel createHorizontalPanel(Component ... children) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        for (Component c : children) {
            panel.add(c);
        }
        return panel;
    }

    public void addLabeledV(JComponent target, String text) {
        StandardAlgConfigPanel.addLabeledV(target, text, this);
    }

    public static void addLabeledV(JComponent target, String text, JPanel owner) {
        JLabel label = new JLabel(text);
        label.setLabelFor(target);
        target.setAlignmentX(0.5f);
        label.setAlignmentX(0.5f);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(label);
        p.add(target);
        owner.add(p);
    }

    public void addVerticalGlue() {
        StandardAlgConfigPanel.addVerticalGlue(this);
    }

    public static void addVerticalGlue(JPanel owner) {
        owner.add(Box.createVerticalGlue());
    }

    public void addHorizontalGlue(JPanel owner) {
        owner.add(Box.createHorizontalGlue());
    }

    protected void setEnabled(int index, boolean enabled) {
        Component c = this.getComponent(index);
        if (c instanceof JPanel) {
            JPanel p = (JPanel)c;
            p.getComponent(0).setEnabled(enabled);
            p.getComponent(2).setEnabled(enabled);
        } else if (c instanceof JLabel) {
            c.setEnabled(enabled);
        }
    }

    protected static void removeChildInsidePanel(JComponent root, JComponent target) {
        int N = root.getComponentCount();
        for (int i = 0; i < N; ++i) {
            try {
                JPanel p = (JPanel)root.getComponent(i);
                Component[] children = p.getComponents();
                for (int j = 0; j < children.length; ++j) {
                    if (children[j] != target) continue;
                    root.remove(i);
                    return;
                }
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    protected static void removeChildAndPrevious(JComponent root, JComponent target) {
        int N = root.getComponentCount();
        for (int i = 0; i < N; ++i) {
            if (root.getComponent(i) != target) continue;
            root.remove(i);
            root.remove(i - 1);
            return;
        }
        throw new RuntimeException("Can't find component");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.controlChanged(e.getSource());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.controlChanged(e.getSource());
    }

    @Override
    public void changeConfigLength(JConfigLength source, double fraction, double length) {
        this.controlChanged(source);
    }

    public void controlChanged(Object source) {
        throw new RuntimeException("You need to override controlChanges() or implement actionPerformed()/stateChanged()");
    }
}

