/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.transform.wavelet;

import boofcv.core.image.border.BorderIndex1D_Extend;
import boofcv.struct.wavelet.WaveletDescription;
import boofcv.struct.wavelet.WlBorderCoefStandard;
import boofcv.struct.wavelet.WlCoef;
import boofcv.struct.wavelet.WlCoef_F32;
import boofcv.struct.wavelet.WlCoef_I32;

public class FactoryWaveletHaar {
    public static <C extends WlCoef> WaveletDescription<C> generate(boolean isInteger, int imageBits) {
        if (isInteger) {
            if (imageBits <= 32) {
                WlCoef_I32 forward = new WlCoef_I32();
                forward.scaling = new int[]{1, 1};
                forward.wavelet = new int[]{forward.scaling[0], -forward.scaling[0]};
                forward.denominatorScaling = 1;
                forward.denominatorWavelet = 1;
                WlBorderCoefStandard<WlCoef_I32> inverse = new WlBorderCoefStandard<WlCoef_I32>(FactoryWaveletHaar.generateInv_I32());
                return new WaveletDescription<WlCoef_I32>(new BorderIndex1D_Extend(), forward, inverse);
            }
        } else if (imageBits == 32) {
            WlCoef_F32 forward = new WlCoef_F32();
            forward.scaling = new float[]{(float)(1.0 / Math.sqrt(2.0)), (float)(1.0 / Math.sqrt(2.0))};
            forward.wavelet = new float[]{forward.scaling[0], -forward.scaling[0]};
            WlBorderCoefStandard<WlCoef_F32> inverse = new WlBorderCoefStandard<WlCoef_F32>(forward);
            return new WaveletDescription<WlCoef_F32>(new BorderIndex1D_Extend(), forward, inverse);
        }
        throw new RuntimeException("Bug");
    }

    private static WlCoef_I32 generateInv_I32() {
        WlCoef_I32 ret = new WlCoef_I32();
        ret.scaling = new int[]{1, 1};
        ret.wavelet = new int[]{ret.scaling[0], -ret.scaling[0]};
        ret.denominatorScaling = 2;
        ret.denominatorWavelet = 2;
        return ret;
    }
}

