/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.transform.census;

import boofcv.abst.transform.census.FilterCensusTransform;
import boofcv.abst.transform.census.FilterCensusTransformD33U8;
import boofcv.abst.transform.census.FilterCensusTransformD55S32;
import boofcv.abst.transform.census.FilterCensusTransformSampleS64;
import boofcv.alg.transform.census.CensusTransform;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.factory.transform.census.CensusVariants;
import boofcv.struct.border.BorderType;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_I32;
import org.ddogleg.struct.DogArray;

public class FactoryCensusTransform {
    public static BorderType CENSUS_BORDER = BorderType.REFLECT;

    public static <In extends ImageGray<In>, Out extends ImageBase<Out>> FilterCensusTransform<In, Out> variant(CensusVariants type, boolean border, Class<In> imageType) {
        switch (type) {
            case BLOCK_3_3: {
                return FactoryCensusTransform.blockDense(1, border, imageType);
            }
            case BLOCK_5_5: {
                return FactoryCensusTransform.blockDense(2, border, imageType);
            }
            case BLOCK_7_7: {
                return FactoryCensusTransform.blockDense(3, border, imageType);
            }
            case BLOCK_9_7: {
                return FactoryCensusTransform.blockDense(4, 3, border, imageType);
            }
            case BLOCK_13_5: {
                return FactoryCensusTransform.blockDense(5, 2, border, imageType);
            }
            case CIRCLE_9: {
                DogArray<Point2D_I32> points = CensusTransform.createCircleSamples();
                ImageBorder imageBorder = border ? (ImageBorder)FactoryImageBorder.single(CENSUS_BORDER, imageType) : null;
                return new FilterCensusTransformSampleS64<In>(points, imageBorder, imageType);
            }
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    public static <In extends ImageGray<In>, Out extends ImageBase<Out>> FilterCensusTransform<In, Out> blockDense(int radius, boolean border, Class<In> imageType) {
        ImageBorder imageBorder = border ? (ImageBorder)FactoryImageBorder.single(CENSUS_BORDER, imageType) : null;
        switch (radius) {
            case 1: {
                return new FilterCensusTransformD33U8<In>(imageBorder, imageType);
            }
            case 2: {
                return new FilterCensusTransformD55S32<In>(imageBorder, imageType);
            }
            case 3: {
                DogArray<Point2D_I32> points7x7 = CensusTransform.createBlockSamples(3);
                return new FilterCensusTransformSampleS64<In>(points7x7, imageBorder, imageType);
            }
        }
        throw new IllegalArgumentException("Currently only radius 1 to 3 is supported");
    }

    public static <In extends ImageGray<In>, Out extends ImageBase<Out>> FilterCensusTransform<In, Out> blockDense(int radiusX, int radiusY, boolean border, Class<In> imageType) {
        ImageBorder imageBorder = border ? (ImageBorder)FactoryImageBorder.single(CENSUS_BORDER, imageType) : null;
        DogArray<Point2D_I32> points = CensusTransform.createBlockSamples(radiusX, radiusY);
        return new FilterCensusTransformSampleS64<In>(points, imageBorder, imageType);
    }
}

