/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.tracker;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.abst.tracker.Circulant_to_TrackerObjectQuad;
import boofcv.abst.tracker.Comaniciu2003_to_TrackerObjectQuad;
import boofcv.abst.tracker.ConfigCirculantTracker;
import boofcv.abst.tracker.ConfigComaniciu2003;
import boofcv.abst.tracker.ConfigTrackerTld;
import boofcv.abst.tracker.MeanShiftLikelihoodType;
import boofcv.abst.tracker.Msl_to_TrackerObjectQuad;
import boofcv.abst.tracker.Sfot_to_TrackObjectQuad;
import boofcv.abst.tracker.Tld_to_TrackerObjectQuad;
import boofcv.abst.tracker.TrackerObjectQuad;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.tracker.circulant.CirculantTracker;
import boofcv.alg.tracker.meanshift.PixelLikelihood;
import boofcv.alg.tracker.meanshift.TrackerMeanShiftComaniciu2003;
import boofcv.alg.tracker.meanshift.TrackerMeanShiftLikelihood;
import boofcv.alg.tracker.sfot.ConfigSfot;
import boofcv.alg.tracker.sfot.SparseFlowObjectTracker;
import boofcv.alg.tracker.tld.TldTracker;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.factory.tracker.FactoryTrackerObjectAlgs;
import boofcv.struct.border.BorderType;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import org.jetbrains.annotations.Nullable;

public class FactoryTrackerObjectQuad {
    public static <T extends ImageGray<T>, D extends ImageGray<D>> TrackerObjectQuad<T> tld(ConfigTrackerTld config, Class<T> imageType) {
        if (config == null) {
            config = new ConfigTrackerTld();
        }
        Class derivType = GImageDerivativeOps.getDerivativeType(imageType);
        InterpolatePixelS<T> interpolate = FactoryInterpolation.bilinearPixelS(imageType, BorderType.EXTENDED);
        ImageGradient gradient = FactoryDerivative.sobel(imageType, derivType);
        TldTracker tracker = new TldTracker(config.parameters, interpolate, gradient, imageType, derivType);
        return new Tld_to_TrackerObjectQuad(tracker, imageType);
    }

    public static <T extends ImageGray<T>, D extends ImageGray<D>> TrackerObjectQuad<T> sparseFlow(@Nullable ConfigSfot config, Class<T> imageType, @Nullable Class<D> derivType) {
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(imageType);
        }
        if (config == null) {
            config = new ConfigSfot();
        }
        ImageGradient<T, D> gradient = FactoryDerivative.sobel(imageType, derivType);
        SparseFlowObjectTracker<T, D> tracker = new SparseFlowObjectTracker<T, D>(config, imageType, derivType, gradient);
        return new Sfot_to_TrackObjectQuad<T, D>(tracker, imageType);
    }

    public static <T extends ImageBase<T>> TrackerObjectQuad<T> meanShiftLikelihood(int maxIterations, int numBins, double maxPixelValue, MeanShiftLikelihoodType modelType, ImageType<T> imageType) {
        PixelLikelihood<T> pixelLikelihood;
        switch (modelType) {
            case HISTOGRAM: {
                pixelLikelihood = FactoryTrackerObjectAlgs.likelihoodHistogramCoupled(maxPixelValue, numBins, imageType);
                break;
            }
            case HISTOGRAM_INDEPENDENT_RGB_to_HSV: {
                if (imageType.getNumBands() != 3) {
                    throw new IllegalArgumentException("Expected RGB image as input with 3-bands");
                }
                pixelLikelihood = FactoryTrackerObjectAlgs.likelihoodHueSatHistIndependent(maxPixelValue, numBins, imageType);
                break;
            }
            case HISTOGRAM_RGB_to_HSV: {
                if (imageType.getNumBands() != 3) {
                    throw new IllegalArgumentException("Expected RGB image as input with 3-bands");
                }
                pixelLikelihood = FactoryTrackerObjectAlgs.likelihoodHueSatHistCoupled(maxPixelValue, numBins, imageType);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown likelihood model " + modelType);
            }
        }
        PixelLikelihood<T> likelihood = pixelLikelihood;
        TrackerMeanShiftLikelihood<T> alg = new TrackerMeanShiftLikelihood<T>(likelihood, maxIterations, 0.1f);
        return new Msl_to_TrackerObjectQuad<T>(alg, likelihood, imageType);
    }

    public static <T extends ImageBase<T>> TrackerObjectQuad<T> meanShiftComaniciu2003(ConfigComaniciu2003 config, ImageType<T> imageType) {
        TrackerMeanShiftComaniciu2003<T> alg = FactoryTrackerObjectAlgs.meanShiftComaniciu2003(config, imageType);
        return new Comaniciu2003_to_TrackerObjectQuad<T>(alg, imageType);
    }

    public static <T extends ImageGray<T>> TrackerObjectQuad<T> circulant(ConfigCirculantTracker config, Class<T> imageType) {
        CirculantTracker<T> alg = FactoryTrackerObjectAlgs.circulant(config, imageType);
        return new Circulant_to_TrackerObjectQuad<T>(alg, ImageType.single(imageType));
    }
}

