/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.sfm;

import boofcv.factory.geo.ConfigBundleAdjustment;
import boofcv.factory.geo.ConfigRansac;
import boofcv.factory.geo.EnumPNP;
import boofcv.factory.sfm.ConfigKeyFrameManager;
import boofcv.misc.ConfigConverge;
import boofcv.struct.Configuration;

public class ConfigVisOdomTrackPnP
implements Configuration {
    public ConfigBundleAdjustment bundle = new ConfigBundleAdjustment();
    public ConfigConverge bundleConverge = new ConfigConverge(0.001, 0.001, 1);
    public int bundleMaxFeaturesPerFrame = 200;
    public int bundleMinObservations = 3;
    public int dropOutlierTracks = 2;
    public int maxKeyFrames = 5;
    public ConfigRansac ransac = new ConfigRansac(500, 1.5);
    public int refineIterations = 25;
    public EnumPNP pnp = EnumPNP.P3P_GRUNERT;
    public ConfigKeyFrameManager keyframes = new ConfigKeyFrameManager();

    @Override
    public void checkValidity() {
        this.bundleConverge.checkValidity();
        this.keyframes.checkValidity();
        if (this.bundleMinObservations < 2) {
            throw new IllegalArgumentException("bundleMinObservations must be >= 2");
        }
    }

    public ConfigVisOdomTrackPnP setTo(ConfigVisOdomTrackPnP src) {
        this.bundle.setTo(src.bundle);
        this.bundleConverge.setTo(src.bundleConverge);
        this.bundleMaxFeaturesPerFrame = src.bundleMaxFeaturesPerFrame;
        this.bundleMinObservations = src.bundleMinObservations;
        this.dropOutlierTracks = src.dropOutlierTracks;
        this.maxKeyFrames = src.maxKeyFrames;
        this.ransac.setTo(src.ransac);
        this.refineIterations = src.refineIterations;
        this.pnp = src.pnp;
        this.keyframes.setTo(src.keyframes);
        return this;
    }
}

