/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.sfm;

import boofcv.abst.feature.detect.interest.PointDetectorTypes;
import boofcv.factory.feature.describe.ConfigDescribeRegion;
import boofcv.factory.feature.detect.interest.ConfigDetectInterestPoint;
import boofcv.factory.sfm.ConfigVisOdomTrackPnP;
import boofcv.factory.tracker.ConfigPointTracker;
import boofcv.struct.Configuration;
import boofcv.struct.pyramid.ConfigDiscreteLevels;

public class ConfigStereoDualTrackPnP
implements Configuration {
    public ConfigVisOdomTrackPnP scene = new ConfigVisOdomTrackPnP();
    public ConfigPointTracker tracker = new ConfigPointTracker();
    public ConfigDescribeRegion stereoDescribe = new ConfigDescribeRegion();
    public double stereoRadius = 11.0;
    public double epipolarTol = 1.5;

    public ConfigStereoDualTrackPnP() {
        this.tracker.typeTracker = ConfigPointTracker.TrackerType.KLT;
        this.tracker.klt.pyramidLevels = ConfigDiscreteLevels.minSize(40);
        this.tracker.klt.pruneClose = true;
        this.tracker.klt.toleranceFB = 3.0;
        this.tracker.klt.templateRadius = 4;
        this.tracker.detDesc.typeDetector = ConfigDetectInterestPoint.Type.POINT;
        this.tracker.detDesc.detectPoint.type = PointDetectorTypes.SHI_TOMASI;
        this.tracker.detDesc.detectPoint.shiTomasi.radius = 4;
        this.tracker.detDesc.detectPoint.general.radius = 5;
        this.stereoDescribe.type = ConfigDescribeRegion.Type.BRIEF;
        this.stereoDescribe.brief.fixed = true;
    }

    @Override
    public void checkValidity() {
        this.scene.checkValidity();
        if (this.scene.maxKeyFrames < 4) {
            throw new IllegalArgumentException("There must be at least 4 key frames");
        }
        this.tracker.checkValidity();
        this.stereoDescribe.checkValidity();
    }

    public ConfigStereoDualTrackPnP setTo(ConfigStereoDualTrackPnP src) {
        this.scene.setTo(src.scene);
        this.tracker.setTo(src.tracker);
        this.stereoDescribe.setTo(src.stereoDescribe);
        this.stereoRadius = src.stereoRadius;
        this.epipolarTol = src.epipolarTol;
        return this;
    }
}

