/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.filter.binary;

import boofcv.abst.filter.binary.GlobalBinaryFilter;
import boofcv.abst.filter.binary.GlobalFixedBinaryFilter;
import boofcv.abst.filter.binary.InputToBinary;
import boofcv.abst.filter.binary.InputToBinarySwitch;
import boofcv.abst.filter.binary.LocalGaussianBinaryFilter;
import boofcv.abst.filter.binary.LocalMeanBinaryFilter;
import boofcv.alg.filter.binary.ThresholdBlock;
import boofcv.alg.filter.binary.ThresholdBlockMean;
import boofcv.alg.filter.binary.ThresholdBlockMinMax;
import boofcv.alg.filter.binary.ThresholdBlockOtsu;
import boofcv.alg.filter.binary.ThresholdBlock_MT;
import boofcv.alg.filter.binary.ThresholdLocalOtsu;
import boofcv.alg.filter.binary.ThresholdLocalOtsu_MT;
import boofcv.alg.filter.binary.ThresholdNiblackFamily;
import boofcv.alg.filter.binary.ThresholdNiblackFamily_MT;
import boofcv.alg.filter.binary.ThresholdNick;
import boofcv.alg.filter.binary.impl.ThresholdBlockMean_F32;
import boofcv.alg.filter.binary.impl.ThresholdBlockMean_U8;
import boofcv.alg.filter.binary.impl.ThresholdBlockMinMax_F32;
import boofcv.alg.filter.binary.impl.ThresholdBlockMinMax_U8;
import boofcv.concurrency.BoofConcurrency;
import boofcv.factory.filter.binary.BOverrideFactoryThresholdBinary;
import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.ConfigThresholdBlockMinMax;
import boofcv.factory.filter.binary.ConfigThresholdLocalOtsu;
import boofcv.struct.ConfigLength;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedU8;

public class FactoryThresholdBinary {
    public static <T extends ImageGray<T>> InputToBinary<T> localGaussian(ConfigLength regionWidth, double scale, boolean down, Class<T> inputType) {
        if (BOverrideFactoryThresholdBinary.localGaussian != null) {
            return BOverrideFactoryThresholdBinary.localGaussian.handle(regionWidth, scale, down, inputType);
        }
        return new LocalGaussianBinaryFilter<T>(regionWidth, scale, down, ImageType.single(inputType));
    }

    public static <T extends ImageGray<T>> InputToBinary<T> localSauvola(ConfigLength width, boolean down, float k, Class<T> inputType) {
        return FactoryThresholdBinary.localNiblackFamily(ThresholdNiblackFamily.Variant.SAUVOLA, width, down, k, inputType);
    }

    public static <T extends ImageGray<T>> InputToBinary<T> localWolf(ConfigLength width, boolean down, float k, Class<T> inputType) {
        return FactoryThresholdBinary.localNiblackFamily(ThresholdNiblackFamily.Variant.WOLF_JOLION, width, down, k, inputType);
    }

    public static <T extends ImageGray<T>> InputToBinary<T> localNiblack(ConfigLength width, boolean down, float k, Class<T> inputType) {
        return FactoryThresholdBinary.localNiblackFamily(ThresholdNiblackFamily.Variant.NIBLACK, width, down, k, inputType);
    }

    protected static <T extends ImageGray<T>> InputToBinary<T> localNiblackFamily(ThresholdNiblackFamily.Variant variant, ConfigLength width, boolean down, float k, Class<T> inputType) {
        if (BOverrideFactoryThresholdBinary.localSauvola != null) {
            throw new RuntimeException("Update how overrides are handled for Niblack family");
        }
        ThresholdNiblackFamily sauvola = BoofConcurrency.USE_CONCURRENT ? new ThresholdNiblackFamily_MT(width, k, down, variant) : new ThresholdNiblackFamily(width, k, down, variant);
        return new InputToBinarySwitch<T>(sauvola, inputType);
    }

    public static <T extends ImageGray<T>> InputToBinary<T> localNick(ConfigLength width, boolean down, float k, Class<T> inputType) {
        return new InputToBinarySwitch<T>(new ThresholdNick(width, k, down), inputType);
    }

    public static <T extends ImageGray<T>> InputToBinary<T> localMean(ConfigLength width, double scale, boolean down, Class<T> inputType) {
        if (BOverrideFactoryThresholdBinary.localMean != null) {
            return BOverrideFactoryThresholdBinary.localMean.handle(width, scale, down, inputType);
        }
        return new LocalMeanBinaryFilter<T>(width, scale, down, ImageType.single(inputType));
    }

    public static <T extends ImageGray<T>> InputToBinary<T> localOtsu(ConfigLength regionWidth, double scale, boolean down, boolean otsu2, double tuning, Class<T> inputType) {
        if (BOverrideFactoryThresholdBinary.localOtsu != null) {
            return BOverrideFactoryThresholdBinary.localOtsu.handle(otsu2, regionWidth, tuning, scale, down, inputType);
        }
        ThresholdLocalOtsu otsu = BoofConcurrency.USE_CONCURRENT ? new ThresholdLocalOtsu_MT(otsu2, regionWidth, tuning, scale, down) : new ThresholdLocalOtsu(otsu2, regionWidth, tuning, scale, down);
        return new InputToBinarySwitch<T>(otsu, inputType);
    }

    public static <T extends ImageGray<T>> InputToBinary<T> blockMinMax(ConfigLength regionWidth, double scale, boolean down, boolean thresholdFromLocalBlocks, double minimumSpread, Class<T> inputType) {
        if (BOverrideFactoryThresholdBinary.blockMinMax != null) {
            return BOverrideFactoryThresholdBinary.blockMinMax.handle(regionWidth, scale, down, minimumSpread, thresholdFromLocalBlocks, inputType);
        }
        ThresholdBlockMinMax processor = inputType == GrayU8.class ? new ThresholdBlockMinMax_U8(minimumSpread, scale, down) : new ThresholdBlockMinMax_F32((float)minimumSpread, (float)scale, down);
        if (BoofConcurrency.USE_CONCURRENT) {
            return new ThresholdBlock_MT<GrayU8, InterleavedU8>(processor, regionWidth, thresholdFromLocalBlocks, inputType);
        }
        return new ThresholdBlock<GrayU8, InterleavedU8>(processor, regionWidth, thresholdFromLocalBlocks, inputType);
    }

    public static <T extends ImageGray<T>> InputToBinary<T> blockMean(ConfigLength regionWidth, double scale, boolean down, boolean thresholdFromLocalBlocks, Class<T> inputType) {
        if (BOverrideFactoryThresholdBinary.blockMean != null) {
            return BOverrideFactoryThresholdBinary.blockMean.handle(regionWidth, scale, down, thresholdFromLocalBlocks, inputType);
        }
        ThresholdBlockMean processor = inputType == GrayU8.class ? new ThresholdBlockMean_U8(scale, down) : new ThresholdBlockMean_F32((float)scale, down);
        if (BoofConcurrency.USE_CONCURRENT) {
            return new ThresholdBlock_MT<GrayU8, GrayU8>(processor, regionWidth, thresholdFromLocalBlocks, inputType);
        }
        return new ThresholdBlock<GrayU8, GrayU8>(processor, regionWidth, thresholdFromLocalBlocks, inputType);
    }

    public static <T extends ImageGray<T>> InputToBinary<T> blockOtsu(ConfigLength regionWidth, double scale, boolean down, boolean thresholdFromLocalBlocks, boolean otsu2, double tuning, Class<T> inputType) {
        if (BOverrideFactoryThresholdBinary.blockOtsu != null) {
            return BOverrideFactoryThresholdBinary.blockOtsu.handle(otsu2, regionWidth, tuning, scale, down, thresholdFromLocalBlocks, inputType);
        }
        ThresholdBlockOtsu processor = new ThresholdBlockOtsu(otsu2, tuning, scale, down);
        ThresholdBlock otsu = BoofConcurrency.USE_CONCURRENT ? new ThresholdBlock_MT<GrayU8, InterleavedS32>(processor, regionWidth, thresholdFromLocalBlocks, GrayU8.class) : new ThresholdBlock<GrayU8, InterleavedS32>(processor, regionWidth, thresholdFromLocalBlocks, GrayU8.class);
        return new InputToBinarySwitch<T>(otsu, inputType);
    }

    public static <T extends ImageGray<T>> InputToBinary<T> globalEntropy(int minValue, int maxValue, double scale, boolean down, Class<T> inputType) {
        if (BOverrideFactoryThresholdBinary.globalEntropy != null) {
            return BOverrideFactoryThresholdBinary.globalEntropy.handle(minValue, maxValue, down, inputType);
        }
        return new GlobalBinaryFilter.Entropy<T>(minValue, maxValue, scale, down, ImageType.single(inputType));
    }

    public static <T extends ImageGray<T>> InputToBinary<T> globalFixed(double threshold, boolean down, Class<T> inputType) {
        if (BOverrideFactoryThresholdBinary.globalFixed != null) {
            return BOverrideFactoryThresholdBinary.globalFixed.handle(threshold, down, inputType);
        }
        return new GlobalFixedBinaryFilter<T>(threshold, down, ImageType.single(inputType));
    }

    public static <T extends ImageGray<T>> InputToBinary<T> globalOtsu(double minValue, double maxValue, double scale, boolean down, Class<T> inputType) {
        if (BOverrideFactoryThresholdBinary.globalOtsu != null) {
            return BOverrideFactoryThresholdBinary.globalOtsu.handle(minValue, maxValue, down, inputType);
        }
        return new GlobalBinaryFilter.Otsu<T>(minValue, maxValue, scale, down, ImageType.single(inputType));
    }

    public static <T extends ImageGray<T>> InputToBinary<T> globalLi(double minValue, double maxValue, double scale, boolean down, Class<T> inputType) {
        return new GlobalBinaryFilter.Li<T>(minValue, maxValue, scale, down, ImageType.single(inputType));
    }

    public static <T extends ImageGray<T>> InputToBinary<T> globalHuang(double minValue, double maxValue, double scale, boolean down, Class<T> inputType) {
        return new GlobalBinaryFilter.Huang<T>(minValue, maxValue, scale, down, ImageType.single(inputType));
    }

    public static <T extends ImageGray<T>> InputToBinary<T> threshold(ConfigThreshold config, Class<T> inputType) {
        InputToBinary<T> inputToBinary;
        switch (config.type) {
            case FIXED: {
                inputToBinary = FactoryThresholdBinary.globalFixed(config.fixedThreshold, config.down, inputType);
                break;
            }
            case GLOBAL_OTSU: {
                inputToBinary = FactoryThresholdBinary.globalOtsu(config.minPixelValue, config.maxPixelValue, config.scale, config.down, inputType);
                break;
            }
            case GLOBAL_ENTROPY: {
                inputToBinary = FactoryThresholdBinary.globalEntropy(config.minPixelValue, config.maxPixelValue, config.scale, config.down, inputType);
                break;
            }
            case GLOBAL_LI: {
                inputToBinary = FactoryThresholdBinary.globalLi(config.minPixelValue, config.maxPixelValue, config.scale, config.down, inputType);
                break;
            }
            case GLOBAL_HUANG: {
                inputToBinary = FactoryThresholdBinary.globalHuang(config.minPixelValue, config.maxPixelValue, config.scale, config.down, inputType);
                break;
            }
            case LOCAL_GAUSSIAN: {
                inputToBinary = FactoryThresholdBinary.localGaussian(config.width, config.scale, config.down, inputType);
                break;
            }
            case LOCAL_NIBLACK: {
                inputToBinary = FactoryThresholdBinary.localNiblack(config.width, config.down, config.niblackK, inputType);
                break;
            }
            case LOCAL_SAVOLA: {
                inputToBinary = FactoryThresholdBinary.localSauvola(config.width, config.down, config.niblackK, inputType);
                break;
            }
            case LOCAL_WOLF: {
                inputToBinary = FactoryThresholdBinary.localWolf(config.width, config.down, config.niblackK, inputType);
                break;
            }
            case LOCAL_NICK: {
                inputToBinary = FactoryThresholdBinary.localNick(config.width, config.down, config.nickK, inputType);
                break;
            }
            case LOCAL_MEAN: {
                inputToBinary = FactoryThresholdBinary.localMean(config.width, config.scale, config.down, inputType);
                break;
            }
            case LOCAL_OTSU: {
                ConfigThresholdLocalOtsu c = (ConfigThresholdLocalOtsu)config;
                inputToBinary = FactoryThresholdBinary.localOtsu(config.width, config.scale, config.down, c.useOtsu2, c.tuning, inputType);
                break;
            }
            case BLOCK_MIN_MAX: {
                ConfigThresholdBlockMinMax c = (ConfigThresholdBlockMinMax)config;
                inputToBinary = FactoryThresholdBinary.blockMinMax(c.width, c.scale, c.down, c.thresholdFromLocalBlocks, c.minimumSpread, inputType);
                break;
            }
            case BLOCK_MEAN: {
                inputToBinary = FactoryThresholdBinary.blockMean(config.width, config.scale, config.down, config.thresholdFromLocalBlocks, inputType);
                break;
            }
            case BLOCK_OTSU: {
                ConfigThresholdLocalOtsu c = (ConfigThresholdLocalOtsu)config;
                inputToBinary = FactoryThresholdBinary.blockOtsu(c.width, c.scale, c.down, c.thresholdFromLocalBlocks, c.useOtsu2, c.tuning, inputType);
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        return inputToBinary;
    }
}

