/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.fiducial;

import boofcv.factory.fiducial.ConfigHammingMarker;
import boofcv.factory.fiducial.HammingDictionary;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.Configuration;

public class ConfigHammingChessboard
implements Configuration {
    public int numRows = -1;
    public int numCols = -1;
    public int markerOffset = 0;
    public ConfigHammingMarker markers;
    public double markerScale = 0.7;
    public double squareSize = 1.0;
    public boolean chessboardEven = true;

    public ConfigHammingChessboard(ConfigHammingMarker markers) {
        this.markers = markers;
    }

    public ConfigHammingChessboard() {
        this.markers = ConfigHammingMarker.loadDictionary(HammingDictionary.ARUCO_MIP_25h7);
    }

    @Override
    public void checkValidity() {
        BoofMiscOps.checkTrue(this.numRows > 0);
        BoofMiscOps.checkTrue(this.numCols > 0);
        BoofMiscOps.checkTrue(this.markerOffset >= 0);
        this.markers.checkValidity();
        BoofMiscOps.checkTrue(this.markerScale > 0.0);
        BoofMiscOps.checkTrue(this.squareSize > 0.0);
    }

    public ConfigHammingChessboard setTo(ConfigHammingChessboard src) {
        this.numRows = src.numRows;
        this.numCols = src.numCols;
        this.markerOffset = src.markerOffset;
        this.markers.setTo(src.markers);
        this.markerScale = src.markerScale;
        this.squareSize = src.squareSize;
        this.chessboardEven = src.chessboardEven;
        return this;
    }

    public double getMarkerWidth() {
        return this.squareSize * (double)this.numCols;
    }

    public double getMarkerHeight() {
        return this.squareSize * (double)this.numRows;
    }

    public static ConfigHammingChessboard create(HammingDictionary dictionary, int rows, int cols, double squareSize) {
        ConfigHammingMarker configDictionary = ConfigHammingMarker.loadDictionary(dictionary);
        ConfigHammingChessboard config = new ConfigHammingChessboard(configDictionary);
        config.numRows = rows;
        config.numCols = cols;
        config.squareSize = squareSize;
        return config;
    }
}

