/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.detect.interest;

import boofcv.abst.feature.describe.ConfigSiftScaleSpace;
import boofcv.abst.feature.detect.extract.NonMaxLimiter;
import boofcv.abst.feature.detect.interest.ConfigFastCorner;
import boofcv.abst.feature.detect.interest.ConfigFastHessian;
import boofcv.abst.feature.detect.interest.ConfigSiftDetector;
import boofcv.abst.feature.detect.interest.FastToInterestPoint;
import boofcv.abst.feature.detect.interest.GeneralToInterestPoint;
import boofcv.abst.feature.detect.interest.InterestPointDetector;
import boofcv.abst.feature.detect.interest.WrapFHtoInterestPoint;
import boofcv.abst.feature.detect.interest.WrapFLPtoInterestPoint;
import boofcv.abst.feature.detect.interest.WrapFPtoInterestPoint;
import boofcv.abst.feature.detect.interest.WrapSiftDetector;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.abst.filter.derivative.ImageHessian;
import boofcv.alg.feature.detect.intensity.FastCornerDetector;
import boofcv.alg.feature.detect.interest.FeatureLaplacePyramid;
import boofcv.alg.feature.detect.interest.FeaturePyramid;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.alg.feature.detect.interest.SiftDetector;
import boofcv.alg.feature.detect.interest.SiftScaleSpace;
import boofcv.alg.feature.detect.selector.FeatureSelectLimit;
import boofcv.alg.feature.detect.selector.FeatureSelectLimitIntensity;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.factory.feature.detect.extract.FactoryFeatureExtractor;
import boofcv.factory.feature.detect.intensity.FactoryIntensityPointAlg;
import boofcv.factory.feature.detect.interest.ConfigDetectInterestPoint;
import boofcv.factory.feature.detect.interest.FactoryDetectPoint;
import boofcv.factory.feature.detect.interest.FactoryInterestPointAlgs;
import boofcv.factory.feature.detect.selector.ConfigSelectLimit;
import boofcv.factory.feature.detect.selector.FactorySelectLimit;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.factory.transform.pyramid.FactoryPyramid;
import boofcv.struct.feature.ScalePoint;
import boofcv.struct.image.ImageGray;
import boofcv.struct.pyramid.PyramidFloat;
import georegression.struct.point.Point2D_I16;
import org.jetbrains.annotations.Nullable;

public class FactoryInterestPoint {
    public static <T extends ImageGray<T>, D extends ImageGray<D>> InterestPointDetector<T> generic(ConfigDetectInterestPoint config, Class<T> inputType, @Nullable Class<D> derivType) {
        switch (config.type) {
            case FAST_HESSIAN: {
                return FactoryInterestPoint.fastHessian(config.fastHessian, inputType);
            }
            case SIFT: {
                return FactoryInterestPoint.sift(config.scaleSpaceSift, config.sift, inputType);
            }
            case POINT: {
                if (derivType == null) {
                    derivType = GImageDerivativeOps.getDerivativeType(inputType);
                }
                GeneralFeatureDetector<T, D> alg = FactoryDetectPoint.create(config.point, inputType, derivType);
                return FactoryInterestPoint.wrapPoint(alg, config.point.scaleRadius, inputType, derivType);
            }
        }
        throw new IllegalArgumentException("Unknown detector");
    }

    public static <T extends ImageGray<T>> InterestPointDetector<T> createFast(@Nullable ConfigFastCorner configFast, int featureLimitPerSet, @Nullable ConfigSelectLimit configSelect, Class<T> imageType) {
        if (configFast == null) {
            configFast = new ConfigFastCorner();
        }
        configFast.checkValidity();
        FastCornerDetector<T> alg = FactoryIntensityPointAlg.fast(configFast.pixelTol, configFast.minContinuous, imageType);
        FeatureSelectLimit<Point2D_I16> selector = FactorySelectLimit.spatial(configSelect, Point2D_I16.class);
        FastToInterestPoint<T> ret = new FastToInterestPoint<T>(alg, selector);
        ret.setFeatureLimitPerSet(featureLimitPerSet <= 0 ? Integer.MAX_VALUE : featureLimitPerSet);
        return ret;
    }

    public static <T extends ImageGray<T>, D extends ImageGray<D>> InterestPointDetector<T> wrapPoint(GeneralFeatureDetector<T, D> feature, double scaleRadius, Class<T> inputType, @Nullable Class<D> derivType) {
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(inputType);
        }
        ImageGradient<T, D> gradient = null;
        ImageHessian<D> hessian = null;
        if (feature.getRequiresGradient() || feature.getRequiresHessian()) {
            gradient = FactoryDerivative.sobel(inputType, derivType);
        }
        if (feature.getRequiresHessian()) {
            hessian = FactoryDerivative.hessianSobel(derivType);
        }
        return new GeneralToInterestPoint<T, D>(feature, gradient, hessian, scaleRadius, derivType);
    }

    public static <T extends ImageGray<T>, D extends ImageGray<D>> InterestPointDetector<T> wrapDetector(FeatureLaplacePyramid<T, D> feature, double[] scales, boolean pyramid, Class<T> inputType) {
        PyramidFloat<T> ss = pyramid ? FactoryPyramid.scaleSpacePyramid(scales, inputType) : FactoryPyramid.scaleSpace(scales, inputType);
        return new WrapFLPtoInterestPoint<T, D>(feature, ss);
    }

    public static <T extends ImageGray<T>, D extends ImageGray<D>> InterestPointDetector<T> wrapDetector(FeaturePyramid<T, D> feature, double[] scales, boolean pyramid, Class<T> inputType) {
        PyramidFloat<T> ss = pyramid ? FactoryPyramid.scaleSpacePyramid(scales, inputType) : FactoryPyramid.scaleSpace(scales, inputType);
        return new WrapFPtoInterestPoint<T, D>(feature, ss);
    }

    public static <T extends ImageGray<T>> InterestPointDetector<T> fastHessian(ConfigFastHessian config, Class<T> imageType) {
        return new WrapFHtoInterestPoint(FactoryInterestPointAlgs.fastHessian(config), imageType);
    }

    public static <T extends ImageGray<T>> InterestPointDetector<T> sift(@Nullable ConfigSiftScaleSpace configSS, @Nullable ConfigSiftDetector configDet, Class<T> imageType) {
        if (configSS == null) {
            configSS = new ConfigSiftScaleSpace();
        }
        if (configDet == null) {
            configDet = new ConfigSiftDetector();
        }
        SiftScaleSpace ss = new SiftScaleSpace(configSS.firstOctave, configSS.lastOctave, configSS.numScales, configSS.sigma0);
        NonMaxLimiter nonmax = FactoryFeatureExtractor.nonmaxLimiter(configDet.extract, configDet.selector, configDet.maxFeaturesPerScale);
        FeatureSelectLimitIntensity<ScalePoint> selectorAll = FactorySelectLimit.intensity(configDet.selector);
        SiftDetector detector = new SiftDetector(selectorAll, configDet.edgeR, nonmax);
        detector.maxFeaturesAll = configDet.maxFeaturesAll;
        return new WrapSiftDetector<T>(ss, detector, imageType);
    }
}

