/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.encoding.impl;

import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;

public class ImplConvertNV21_MT {
    public static void nv21ToGray(byte[] dataNV, GrayU8 output) {
        int yStride = output.width;
        if (yStride == output.width && !output.isSubimage()) {
            System.arraycopy(dataNV, 0, output.data, 0, output.width * output.height);
        } else {
            BoofConcurrency.loopFor(0, output.height, y -> {
                int indexOut = output.startIndex + y * output.stride;
                System.arraycopy(dataNV, y * yStride, output.data, indexOut, output.width);
            });
        }
    }

    public static void nv21ToGray(byte[] dataNV, GrayF32 output) {
        BoofConcurrency.loopFor(0, output.height, y -> {
            int indexIn = y * output.width;
            int indexOut = output.startIndex + y * output.stride;
            for (int x = 0; x < output.width; ++x) {
                output.data[indexOut++] = dataNV[indexIn++] & 0xFF;
            }
        });
    }

    public static void nv21ToPlanarYuv_U8(byte[] dataNV, Planar<GrayU8> output) {
        GrayU8 Y2 = output.getBand(0);
        GrayU8 U = output.getBand(1);
        GrayU8 V = output.getBand(2);
        int uvStride = output.width / 2;
        ImplConvertNV21_MT.nv21ToGray(dataNV, Y2);
        int startUV = output.width * output.height;
        BoofConcurrency.loopFor(0, output.height, row -> {
            int indexUV = startUV + row / 2 * (2 * uvStride);
            int indexOut = output.startIndex + row * output.stride;
            int col = 0;
            while (col < output.width) {
                U.data[indexOut] = dataNV[indexUV];
                V.data[indexOut] = dataNV[indexUV + 1];
                indexUV += 2 * (col & 1);
                ++col;
                ++indexOut;
            }
        });
    }

    public static void nv21ToPlanarYuv_F32(byte[] dataNV, Planar<GrayF32> output) {
        GrayF32 Y2 = output.getBand(0);
        GrayF32 U = output.getBand(1);
        GrayF32 V = output.getBand(2);
        int uvStride = output.width / 2;
        ImplConvertNV21_MT.nv21ToGray(dataNV, Y2);
        int startUV = output.width * output.height;
        BoofConcurrency.loopFor(0, output.height, row -> {
            int indexUV = startUV + row / 2 * (2 * uvStride);
            int indexOut = output.startIndex + row * output.stride;
            int col = 0;
            while (col < output.width) {
                U.data[indexOut] = (dataNV[indexUV] & 0xFF) - 128;
                V.data[indexOut] = (dataNV[indexUV + 1] & 0xFF) - 128;
                indexUV += 2 * (col & 1);
                ++col;
                ++indexOut;
            }
        });
    }

    public static void nv21ToPlanarRgb_U8(byte[] dataNV, Planar<GrayU8> output) {
        GrayU8 R = output.getBand(0);
        GrayU8 G = output.getBand(1);
        GrayU8 B = output.getBand(2);
        int yStride = output.width;
        int uvStride = output.width / 2;
        int startUV = yStride * output.height;
        BoofConcurrency.loopFor(0, output.height, row -> {
            int indexY = row * yStride;
            int indexUV = startUV + row / 2 * (2 * uvStride);
            int indexOut = output.startIndex + row * output.stride;
            int col = 0;
            while (col < output.width) {
                int y = 1191 * ((dataNV[indexY++] & 0xFF) - 16);
                int cr = (dataNV[indexUV] & 0xFF) - 128;
                int cb = (dataNV[indexUV + 1] & 0xFF) - 128;
                y = (y >>> 31 ^ 1) * y;
                int r = y + 1836 * cr >> 10;
                int g = y - 547 * cr - 218 * cb >> 10;
                int b = y + 2165 * cb >> 10;
                r *= r >>> 31 ^ 1;
                g *= g >>> 31 ^ 1;
                b *= b >>> 31 ^ 1;
                if (r > 255) {
                    r = 255;
                }
                if (g > 255) {
                    g = 255;
                }
                if (b > 255) {
                    b = 255;
                }
                R.data[indexOut] = (byte)r;
                G.data[indexOut] = (byte)g;
                B.data[indexOut] = (byte)b;
                indexUV += 2 * (col & 1);
                ++col;
                ++indexOut;
            }
        });
    }

    public static void nv21ToInterleaved_U8(byte[] dataNV, InterleavedU8 output) {
        int yStride = output.width;
        int uvStride = output.width / 2;
        int startUV = yStride * output.height;
        BoofConcurrency.loopFor(0, output.height, row -> {
            int indexY = row * yStride;
            int indexUV = startUV + row / 2 * (2 * uvStride);
            int indexOut = output.startIndex + row * output.stride;
            for (int col = 0; col < output.width; ++col) {
                int y = 1191 * ((dataNV[indexY++] & 0xFF) - 16);
                int cr = (dataNV[indexUV] & 0xFF) - 128;
                int cb = (dataNV[indexUV + 1] & 0xFF) - 128;
                y = (y >>> 31 ^ 1) * y;
                int r = y + 1836 * cr >> 10;
                int g = y - 547 * cr - 218 * cb >> 10;
                int b = y + 2165 * cb >> 10;
                r *= r >>> 31 ^ 1;
                g *= g >>> 31 ^ 1;
                b *= b >>> 31 ^ 1;
                if (r > 255) {
                    r = 255;
                }
                if (g > 255) {
                    g = 255;
                }
                if (b > 255) {
                    b = 255;
                }
                output.data[indexOut++] = (byte)r;
                output.data[indexOut++] = (byte)g;
                output.data[indexOut++] = (byte)b;
                indexUV += 2 * (col & 1);
            }
        });
    }

    public static void nv21ToPlanarRgb_F32(byte[] dataNV, Planar<GrayF32> output) {
        GrayF32 R = output.getBand(0);
        GrayF32 G = output.getBand(1);
        GrayF32 B = output.getBand(2);
        int yStride = output.width;
        int uvStride = output.width / 2;
        int startUV = yStride * output.height;
        BoofConcurrency.loopFor(0, output.height, row -> {
            int indexY = row * yStride;
            int indexUV = startUV + row / 2 * (2 * uvStride);
            int indexOut = output.startIndex + row * output.stride;
            int col = 0;
            while (col < output.width) {
                int y = 1191 * ((dataNV[indexY++] & 0xFF) - 16);
                int cr = (dataNV[indexUV] & 0xFF) - 128;
                int cb = (dataNV[indexUV + 1] & 0xFF) - 128;
                y = (y >>> 31 ^ 1) * y;
                int r = y + 1836 * cr >> 10;
                int g = y - 547 * cr - 218 * cb >> 10;
                int b = y + 2165 * cb >> 10;
                r *= r >>> 31 ^ 1;
                g *= g >>> 31 ^ 1;
                b *= b >>> 31 ^ 1;
                if (r > 255) {
                    r = 255;
                }
                if (g > 255) {
                    g = 255;
                }
                if (b > 255) {
                    b = 255;
                }
                R.data[indexOut] = r;
                G.data[indexOut] = g;
                B.data[indexOut] = b;
                indexUV += 2 * (col & 1);
                ++col;
                ++indexOut;
            }
        });
    }

    public static void nv21ToInterleaved_F32(byte[] dataNV, InterleavedF32 output) {
        int yStride = output.width;
        int uvStride = output.width / 2;
        int startUV = yStride * output.height;
        BoofConcurrency.loopFor(0, output.height, row -> {
            int indexY = row * yStride;
            int indexUV = startUV + row / 2 * (2 * uvStride);
            int indexOut = output.startIndex + row * output.stride;
            for (int col = 0; col < output.width; ++col) {
                int y = 1191 * ((dataNV[indexY++] & 0xFF) - 16);
                int cr = (dataNV[indexUV] & 0xFF) - 128;
                int cb = (dataNV[indexUV + 1] & 0xFF) - 128;
                y = (y >>> 31 ^ 1) * y;
                int r = y + 1836 * cr >> 10;
                int g = y - 547 * cr - 218 * cb >> 10;
                int b = y + 2165 * cb >> 10;
                r *= r >>> 31 ^ 1;
                g *= g >>> 31 ^ 1;
                b *= b >>> 31 ^ 1;
                if (r > 255) {
                    r = 255;
                }
                if (g > 255) {
                    g = 255;
                }
                if (b > 255) {
                    b = 255;
                }
                output.data[indexOut++] = r;
                output.data[indexOut++] = g;
                output.data[indexOut++] = b;
                indexUV += 2 * (col & 1);
            }
        });
    }
}

