/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.encoding;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.color.ColorFormat;
import boofcv.core.encoding.impl.ImplConvertYuv420_888;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;
import java.nio.ByteBuffer;
import org.ddogleg.struct.DogArray_I8;
import org.jetbrains.annotations.Nullable;
import pabeles.concurrency.GrowArray;

public class ConvertYuv420_888 {
    public static byte[] declareWork(int strideY, int strideUV, byte[] work) {
        int workLength = strideY + 2 * strideUV;
        if (work == null || work.length < workLength) {
            return new byte[workLength];
        }
        return work;
    }

    public static void yuvToBoof(ByteBuffer bufferY, ByteBuffer bufferU, ByteBuffer bufferV, int width, int height, int strideY, int strideUV, int stridePixelUV, ColorFormat colorOutput, ImageBase output, @Nullable GrowArray<DogArray_I8> workArrays) {
        if (output instanceof GrayU8) {
            ConvertYuv420_888.yuvToGray(bufferY, width, height, strideY, (GrayU8)output);
            return;
        }
        if (output instanceof GrayF32) {
            ConvertYuv420_888.yuvToGray(bufferY, width, height, strideY, (GrayF32)output, workArrays);
            return;
        }
        if (output.getImageType().getFamily() == ImageType.Family.PLANAR) {
            switch (colorOutput) {
                case RGB: {
                    switch (output.getImageType().getDataType()) {
                        case U8: {
                            ConvertYuv420_888.yuvToPlanarRgbU8(bufferY, bufferU, bufferV, width, height, strideY, strideUV, stridePixelUV, (Planar)output, workArrays);
                            return;
                        }
                        case F32: {
                            ConvertYuv420_888.yuvToPlanarRgbF32(bufferY, bufferU, bufferV, width, height, strideY, strideUV, stridePixelUV, (Planar)output, workArrays);
                            return;
                        }
                    }
                    break;
                }
                case YUV: {
                    switch (output.getImageType().getDataType()) {
                        case U8: {
                            ConvertYuv420_888.yuvToPlanarYuvU8(bufferY, bufferU, bufferV, width, height, strideY, strideUV, stridePixelUV, (Planar)output, workArrays);
                            return;
                        }
                    }
                }
            }
        } else if (output.getImageType().getFamily() == ImageType.Family.INTERLEAVED) {
            switch (colorOutput) {
                case RGB: {
                    switch (output.getImageType().getDataType()) {
                        case U8: {
                            ConvertYuv420_888.yuvToInterleavedRgbU8(bufferY, bufferU, bufferV, width, height, strideY, strideUV, stridePixelUV, (InterleavedU8)output, workArrays);
                            return;
                        }
                        case F32: {
                            ConvertYuv420_888.yuvToInterleavedRgbF32(bufferY, bufferU, bufferV, width, height, strideY, strideUV, stridePixelUV, (InterleavedF32)output, workArrays);
                            return;
                        }
                    }
                    break;
                }
                case YUV: {
                    switch (output.getImageType().getDataType()) {
                        case U8: {
                            ConvertYuv420_888.yuvToInterleavedYuvU8(bufferY, bufferU, bufferV, width, height, strideY, strideUV, stridePixelUV, (InterleavedU8)output, workArrays);
                            return;
                        }
                    }
                }
            }
        }
        throw new RuntimeException("Not yet supported. format=" + colorOutput + " out=" + output.getImageType());
    }

    public static <T extends ImageGray<T>> T yuvToGray(ByteBuffer bufferY, int width, int height, int strideRow, T output, @Nullable GrowArray<DogArray_I8> workArrays, Class<T> outputType) {
        if (outputType == GrayU8.class) {
            return (T)ConvertYuv420_888.yuvToGray(bufferY, width, height, strideRow, (GrayU8)output);
        }
        if (outputType == GrayF32.class) {
            return (T)ConvertYuv420_888.yuvToGray(bufferY, width, height, strideRow, (GrayF32)output, workArrays);
        }
        throw new IllegalArgumentException("Unsupported BoofCV Image Type " + outputType.getSimpleName());
    }

    public static GrayF32 yuvToGray(ByteBuffer bufferY, int width, int height, int strideRow, @Nullable GrayF32 output, @Nullable GrowArray<DogArray_I8> workArrays) {
        output = InputSanityCheck.declareOrReshape(output, width, height, GrayF32.class);
        workArrays = BoofMiscOps.checkDeclare(workArrays, DogArray_I8::new);
        byte[] work = BoofMiscOps.checkDeclare(workArrays.grow(), width, false);
        int indexDst = 0;
        int y = 0;
        int indexRow = 0;
        while (y < height) {
            bufferY.position(indexRow);
            bufferY.get(work, 0, width);
            for (int x = 0; x < width; ++x) {
                output.data[indexDst++] = work[x] & 0xFF;
            }
            ++y;
            indexRow += strideRow;
        }
        return output;
    }

    public static GrayU8 yuvToGray(ByteBuffer bufferY, int width, int height, int strideRow, @Nullable GrayU8 output) {
        output = InputSanityCheck.declareOrReshape(output, width, height, GrayU8.class);
        int indexDst = 0;
        int y = 0;
        int indexRow = 0;
        while (y < height) {
            bufferY.position(indexRow);
            bufferY.get(output.data, indexDst, width);
            ++y;
            indexRow += strideRow;
            indexDst += width;
        }
        return output;
    }

    public static Planar<GrayU8> yuvToPlanarRgbU8(ByteBuffer bufferY, ByteBuffer bufferU, ByteBuffer bufferV, int width, int height, int strideY, int strideUV, int stridePixelUV, @Nullable Planar<GrayU8> output, @Nullable GrowArray<DogArray_I8> workArrays) {
        output = InputSanityCheck.declareOrReshape(output, width, height, 3, GrayU8.class);
        workArrays = BoofMiscOps.checkDeclare(workArrays, DogArray_I8::new);
        final byte[] red = output.getBand((int)0).data;
        final byte[] green = output.getBand((int)1).data;
        final byte[] blue = output.getBand((int)2).data;
        ProcessorYuvRgb processor = new ProcessorYuvRgb(){
            int indexOut = 0;

            @Override
            public void processRGB(int r, int g, int b) {
                red[this.indexOut] = (byte)r;
                green[this.indexOut] = (byte)g;
                blue[this.indexOut++] = (byte)b;
            }
        };
        ImplConvertYuv420_888.processYuv(bufferY, bufferU, bufferV, width, height, strideY, strideUV, stridePixelUV, workArrays, processor);
        return output;
    }

    public static Planar<GrayF32> yuvToPlanarRgbF32(ByteBuffer bufferY, ByteBuffer bufferU, ByteBuffer bufferV, int width, int height, int strideY, int strideUV, int stridePixelUV, @Nullable Planar<GrayF32> output, @Nullable GrowArray<DogArray_I8> workArrays) {
        output = InputSanityCheck.declareOrReshape(output, width, height, 3, GrayF32.class);
        workArrays = BoofMiscOps.checkDeclare(workArrays, DogArray_I8::new);
        final float[] red = output.getBand((int)0).data;
        final float[] green = output.getBand((int)1).data;
        final float[] blue = output.getBand((int)2).data;
        ProcessorYuvRgb processor = new ProcessorYuvRgb(){
            int indexOut = 0;

            @Override
            public void processRGB(int r, int g, int b) {
                red[this.indexOut] = r;
                green[this.indexOut] = g;
                blue[this.indexOut++] = b;
            }
        };
        ImplConvertYuv420_888.processYuv(bufferY, bufferU, bufferV, width, height, strideY, strideUV, stridePixelUV, workArrays, processor);
        return output;
    }

    public static InterleavedU8 yuvToInterleavedRgbU8(ByteBuffer bufferY, ByteBuffer bufferU, ByteBuffer bufferV, int width, int height, int strideY, int strideUV, int stridePixelUV, @Nullable InterleavedU8 output, @Nullable GrowArray<DogArray_I8> workArrays) {
        output = InputSanityCheck.declareOrReshape(output, width, height, 3, InterleavedU8.class);
        workArrays = BoofMiscOps.checkDeclare(workArrays, DogArray_I8::new);
        final InterleavedU8 _output = output;
        ProcessorYuvRgb processor = new ProcessorYuvRgb(){
            int indexOut = 0;

            @Override
            public void processRGB(int r, int g, int b) {
                _output.data[this.indexOut++] = (byte)r;
                _output.data[this.indexOut++] = (byte)g;
                _output.data[this.indexOut++] = (byte)b;
            }
        };
        ImplConvertYuv420_888.processYuv(bufferY, bufferU, bufferV, width, height, strideY, strideUV, stridePixelUV, workArrays, processor);
        return output;
    }

    public static InterleavedF32 yuvToInterleavedRgbF32(ByteBuffer bufferY, ByteBuffer bufferU, ByteBuffer bufferV, int width, int height, int strideY, int strideUV, int stridePixelUV, @Nullable InterleavedF32 output, @Nullable GrowArray<DogArray_I8> workArrays) {
        output = InputSanityCheck.declareOrReshape(output, width, height, 3, InterleavedF32.class);
        workArrays = BoofMiscOps.checkDeclare(workArrays, DogArray_I8::new);
        final InterleavedF32 _output = output;
        ProcessorYuvRgb processor = new ProcessorYuvRgb(){
            int indexOut = 0;

            @Override
            public void processRGB(int r, int g, int b) {
                _output.data[this.indexOut++] = r;
                _output.data[this.indexOut++] = g;
                _output.data[this.indexOut++] = b;
            }
        };
        ImplConvertYuv420_888.processYuv(bufferY, bufferU, bufferV, width, height, strideY, strideUV, stridePixelUV, workArrays, processor);
        return output;
    }

    public static Planar<GrayU8> yuvToPlanarYuvU8(ByteBuffer bufferY, ByteBuffer bufferU, ByteBuffer bufferV, int width, int height, int strideY, int strideUV, int stridePixelUV, @Nullable Planar<GrayU8> output, @Nullable GrowArray<DogArray_I8> workArrays) {
        output = InputSanityCheck.declareOrReshape(output, width, height, 3, GrayU8.class);
        workArrays = BoofMiscOps.checkDeclare(workArrays, DogArray_I8::new);
        final byte[] dataY = output.getBand((int)0).data;
        final byte[] dataU = output.getBand((int)1).data;
        final byte[] dataV = output.getBand((int)2).data;
        ProcessorYuv processor = new ProcessorYuv(){
            int indexOut = 0;

            @Override
            public void processYUV(int y, int u, int v) {
                dataY[this.indexOut] = (byte)y;
                dataU[this.indexOut] = (byte)u;
                dataV[this.indexOut++] = (byte)v;
            }
        };
        ImplConvertYuv420_888.processYuv(bufferY, bufferU, bufferV, width, height, strideY, strideUV, stridePixelUV, workArrays, processor);
        return output;
    }

    public static InterleavedU8 yuvToInterleavedYuvU8(ByteBuffer bufferY, ByteBuffer bufferU, ByteBuffer bufferV, int width, int height, int strideY, int strideUV, int stridePixelUV, @Nullable InterleavedU8 output, @Nullable GrowArray<DogArray_I8> workArrays) {
        output = InputSanityCheck.declareOrReshape(output, width, height, 3, InterleavedU8.class);
        workArrays = BoofMiscOps.checkDeclare(workArrays, DogArray_I8::new);
        final byte[] data = output.data;
        ProcessorYuv processor = new ProcessorYuv(){
            int indexOut = 0;

            @Override
            public final void processYUV(int y, int u, int v) {
                data[this.indexOut++] = (byte)y;
                data[this.indexOut++] = (byte)u;
                data[this.indexOut++] = (byte)v;
            }
        };
        ImplConvertYuv420_888.processYuv(bufferY, bufferU, bufferV, width, height, strideY, strideUV, stridePixelUV, workArrays, processor);
        return output;
    }

    public static interface ProcessorYuv {
        public void processYUV(int var1, int var2, int var3);
    }

    static abstract class ProcessorYuvRgb
    implements ProcessorYuv {
        ProcessorYuvRgb() {
        }

        @Override
        public final void processYUV(int y, int u, int v) {
            int Y2 = 1191 * (y - 16);
            int CR = u - 128;
            int CB = v - 128;
            Y2 = (Y2 >>> 31 ^ 1) * Y2;
            int r = Y2 + 1836 * CR >> 10;
            int g = Y2 - 547 * CR - 218 * CB >> 10;
            int b = Y2 + 2165 * CB >> 10;
            r *= r >>> 31 ^ 1;
            g *= g >>> 31 ^ 1;
            b *= b >>> 31 ^ 1;
            if (r > 255) {
                r = 255;
            }
            if (g > 255) {
                g = 255;
            }
            if (b > 255) {
                b = 255;
            }
            this.processRGB(r, g, b);
        }

        public abstract void processRGB(int var1, int var2, int var3);
    }
}

