/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.structure.expand;

import boofcv.alg.structure.ConfigProjectiveReconstruction;
import boofcv.alg.structure.PairwiseGraphUtils;
import boofcv.alg.structure.PairwiseImageGraph;
import boofcv.alg.structure.SceneWorkingGraph;
import boofcv.misc.BoofMiscOps;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public abstract class ExpandByOneView
implements VerbosePrint {
    @Nullable
    protected PrintStream verbose;
    protected SceneWorkingGraph workGraph;
    public PairwiseGraphUtils utils;
    protected List<PairwiseImageGraph.Motion> validCandidates = new ArrayList<PairwiseImageGraph.Motion>();

    protected ExpandByOneView(ConfigProjectiveReconstruction configProjective) {
        this.utils = new PairwiseGraphUtils(configProjective);
    }

    protected ExpandByOneView() {
        this(new ConfigProjectiveReconstruction());
    }

    public boolean selectTwoConnections(PairwiseImageGraph.View target, List<PairwiseImageGraph.Motion> connections) {
        connections.clear();
        this.createListOfValid(target, this.validCandidates);
        int considered = 0;
        double bestScore = 0.0;
        for (int connIdxB = 0; connIdxB < this.validCandidates.size(); ++connIdxB) {
            PairwiseImageGraph.Motion connectB = this.validCandidates.get(connIdxB);
            PairwiseImageGraph.View viewB = connectB.other(target);
            if (connectB.score3D < bestScore) continue;
            for (int connIdxC = connIdxB + 1; connIdxC < this.validCandidates.size(); ++connIdxC) {
                PairwiseImageGraph.Motion connectC = this.validCandidates.get(connIdxC);
                PairwiseImageGraph.View viewC = connectC.other(target);
                PairwiseImageGraph.Motion connectBtoC = viewB.findMotion(viewC);
                if (connectBtoC == null || !connectBtoC.is3D) continue;
                double score = BoofMiscOps.min(connectB.score3D, connectC.score3D, connectBtoC.score3D);
                ++considered;
                if (!(score > bestScore)) continue;
                bestScore = score;
                connections.clear();
                connections.add(connectB);
                connections.add(connectC);
            }
        }
        if (this.verbose != null) {
            this.verbose.printf("best pair: score=%.2f from pairs=%d views.size=%d\n", bestScore, considered, this.validCandidates.size());
        }
        return !connections.isEmpty();
    }

    void createListOfValid(PairwiseImageGraph.View target, List<PairwiseImageGraph.Motion> validConnections) {
        validConnections.clear();
        for (int connectionIdx = 0; connectionIdx < target.connections.size; ++connectionIdx) {
            PairwiseImageGraph.Motion connectB = (PairwiseImageGraph.Motion)target.connections.get(connectionIdx);
            if (!connectB.is3D || !this.workGraph.isKnown(connectB.other(target))) continue;
            validConnections.add(connectB);
        }
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix(this, out);
    }

    public PairwiseGraphUtils getUtils() {
        return this.utils;
    }

    public void setUtils(PairwiseGraphUtils utils) {
        this.utils = utils;
    }
}

