/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.structure;

import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureProjective;
import boofcv.alg.structure.ConfigProjectiveReconstruction;
import boofcv.alg.structure.LookUpCameraInfo;
import boofcv.alg.structure.LookUpSimilarImages;
import boofcv.alg.structure.PairwiseGraphUtils;
import boofcv.alg.structure.PairwiseImageGraph;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.ElevateViewInfo;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.AssociatedTriple;
import boofcv.struct.geo.AssociatedTupleDN;
import boofcv.struct.image.ImageDimension;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point4D_F64;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.io.PrintStream;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastArray;
import org.ddogleg.struct.VerbosePrint;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.jetbrains.annotations.Nullable;

public class ProjectiveInitializeAllCommon
implements VerbosePrint {
    public PairwiseGraphUtils utils;
    protected final DogArray<DogArray_I32> inlierIndexes = new DogArray<DogArray_I32>(DogArray_I32::new, DogArray_I32::reset);
    protected final FastArray<PairwiseImageGraph.View> viewsByStructureIndex = new FastArray<PairwiseImageGraph.View>(PairwiseImageGraph.View.class);
    @Nullable
    private PrintStream verbose;
    protected final int[] selectedTriple = new int[2];
    protected final DogArray<Point4D_F64> points3D = new DogArray<Point4D_F64>(Point4D_F64::new);
    protected final DogArray<AssociatedPair> assocPixel = new DogArray<AssociatedPair>(AssociatedPair::new);
    protected final ImageDimension shape = new ImageDimension();
    protected final DogArray_I32 seedToStructure = new DogArray_I32();
    TIntIntMap dbToCamera = new TIntIntHashMap(){
        {
            this.no_entry_value = -1;
        }
    };

    public ProjectiveInitializeAllCommon(ConfigProjectiveReconstruction configProjective) {
        this.utils = new PairwiseGraphUtils(configProjective);
    }

    public ProjectiveInitializeAllCommon() {
        this(new ConfigProjectiveReconstruction());
    }

    public boolean projectiveSceneN(LookUpSimilarImages dbSimilar, LookUpCameraInfo dbCams, PairwiseImageGraph.View seed, DogArray_I32 seedFeatsIdx, DogArray_I32 seedConnIdx) {
        BoofMiscOps.checkTrue(seedFeatsIdx.size >= 6, "need at least 6 common features to estimate camera matrix");
        BoofMiscOps.checkTrue(seed.connections.size >= seedConnIdx.size, "Can't have more seed connection indexes than actual connections");
        if (this.verbose != null) {
            this.verbose.println("ENTER projectiveSceneN: seed='" + seed.id + "' common.size=" + seedFeatsIdx.size + " conn.size=" + seedConnIdx.size);
        }
        if (seedConnIdx.size < 2) {
            if (this.verbose != null) {
                this.verbose.println("2-views, a.k.a. stereo, is a special case and requires different logic and isn't yet supported");
            }
            return false;
        }
        this.utils.dbSimilar = dbSimilar;
        this.utils.dbCams = dbCams;
        this.viewsByStructureIndex.reset();
        this.inlierIndexes.resetResize(1 + seedConnIdx.size);
        if (!this.selectInitialTriplet(seed, seedConnIdx, this.selectedTriple)) {
            if (this.verbose != null) {
                this.verbose.println("FAILED: Select initial triplet");
            }
            return false;
        }
        this.utils.seed = seed;
        this.utils.viewB = ((PairwiseImageGraph.Motion)this.utils.seed.connections.get(this.selectedTriple[0])).other(seed);
        this.utils.viewC = ((PairwiseImageGraph.Motion)this.utils.seed.connections.get(this.selectedTriple[1])).other(seed);
        this.utils.createThreeViewLookUpTables();
        this.utils.findFullyConnectedTriple(seedFeatsIdx);
        if (this.verbose != null) {
            this.verbose.println("Selected Triplet: seed='" + this.utils.seed.id + "' viewB='" + this.utils.viewB.id + "' viewC='" + this.utils.viewC.id + "' common.size=" + this.utils.commonIdx.size + " connections.size=" + seedConnIdx.size);
        }
        if (this.utils.commonIdx.isEmpty()) {
            if (this.verbose != null) {
                this.verbose.println("FAILED: No common features found");
            }
            return false;
        }
        this.utils.createTripleFromCommon(this.verbose);
        if (!this.utils.estimateProjectiveCamerasRobustly()) {
            if (this.verbose != null) {
                this.verbose.println("FAILED: Created projective from initial triplet");
            }
            return false;
        }
        this.createStructureLookUpTables(seed);
        if (seedConnIdx.size > 2) {
            this.initializeStructureForAllViews(dbCams, this.utils.ransac.getMatchSet().size(), seed, seedConnIdx);
            if (!this.findRemainingCameraMatrices(dbSimilar, dbCams, seed, seedConnIdx)) {
                if (this.verbose != null) {
                    this.verbose.println("FAILED: Finding remaining cameras. TODO recover from this");
                }
                return false;
            }
        } else {
            this.utils.initializeSbaSceneThreeView(true);
            this.utils.initializeSbaObservationsThreeView();
            this.viewsByStructureIndex.resize(3);
            this.viewsByStructureIndex.set(0, this.utils.seed);
            this.viewsByStructureIndex.set(1, this.utils.viewB);
            this.viewsByStructureIndex.set(2, this.utils.viewC);
        }
        this.viewsByStructureIndex.forIdx((i, o) -> BoofMiscOps.checkTrue(o != null));
        this.createObservationsForBundleAdjustment(seedConnIdx);
        return this.utils.refineWithBundleAdjustment();
    }

    private void initializeStructureForAllViews(LookUpCameraInfo db, int numberOfFeatures, PairwiseImageGraph.View seed, DogArray_I32 seedConnIdx) {
        this.utils.observations.initialize(1 + seedConnIdx.size);
        this.utils.structure.initialize(1 + seedConnIdx.size, numberOfFeatures);
        this.viewsByStructureIndex.resize(this.utils.structure.views.size, null);
        this.utils.triangulateFeatures();
        db.lookupViewShape(seed.id, this.shape);
        this.utils.structure.setView(0, true, this.utils.P1, this.shape.width, this.shape.height);
        int indexSbaViewB = 1 + seedConnIdx.indexOf(this.selectedTriple[0]);
        int indexSbaViewC = 1 + seedConnIdx.indexOf(this.selectedTriple[1]);
        BoofMiscOps.checkTrue(indexSbaViewB > 0 && indexSbaViewC > 0, "indexOf() failed");
        for (int i = 0; i < 2; ++i) {
            PairwiseImageGraph.Motion motion = (PairwiseImageGraph.Motion)seed.connections.get(this.selectedTriple[i]);
            PairwiseImageGraph.View view = motion.other(seed);
            db.lookupViewShape(view.id, this.shape);
            this.utils.structure.setView(i == 0 ? indexSbaViewB : indexSbaViewC, false, i == 0 ? this.utils.P2 : this.utils.P3, this.shape.width, this.shape.height);
        }
        this.viewsByStructureIndex.set(0, seed);
        this.viewsByStructureIndex.set(indexSbaViewB, this.utils.viewB);
        this.viewsByStructureIndex.set(indexSbaViewC, this.utils.viewC);
        SceneObservations.View view1 = this.utils.observations.getView(0);
        SceneObservations.View view2 = this.utils.observations.getView(indexSbaViewB);
        SceneObservations.View view3 = this.utils.observations.getView(indexSbaViewC);
        for (int i = 0; i < this.utils.inliersThreeView.size(); ++i) {
            AssociatedTriple t = (AssociatedTriple)this.utils.inliersThreeView.get(i);
            view1.add(i, (float)t.p1.x, (float)t.p1.y);
            view2.add(i, (float)t.p2.x, (float)t.p2.y);
            view3.add(i, (float)t.p3.x, (float)t.p3.y);
        }
    }

    void createStructureLookUpTables(PairwiseImageGraph.View viewA) {
        int numInliers = this.utils.ransac.getMatchSet().size();
        this.seedToStructure.resize(viewA.totalObservations);
        this.seedToStructure.fill(-1);
        DogArray_I32 inlierToSeed = (DogArray_I32)this.inlierIndexes.get(0);
        inlierToSeed.resize(numInliers);
        for (int i = 0; i < numInliers; ++i) {
            int inputIdx = this.utils.ransac.getInputIndex(i);
            inlierToSeed.data[i] = this.utils.commonIdx.get(inputIdx);
            BoofMiscOps.checkTrue(this.seedToStructure.data[inlierToSeed.data[i]] == -1);
            this.seedToStructure.data[inlierToSeed.data[i]] = i;
        }
    }

    boolean selectInitialTriplet(PairwiseImageGraph.View seed, DogArray_I32 edgeIdxs, int[] selected) {
        BoofMiscOps.checkTrue(selected.length == 2);
        double bestScore = 0.0;
        for (int i = 0; i < edgeIdxs.size; ++i) {
            int edgeI = edgeIdxs.get(i);
            PairwiseImageGraph.View viewB = ((PairwiseImageGraph.Motion)seed.connections.get(edgeI)).other(seed);
            for (int j = i + 1; j < edgeIdxs.size; ++j) {
                int edgeJ = edgeIdxs.get(j);
                PairwiseImageGraph.View viewC = ((PairwiseImageGraph.Motion)seed.connections.get(edgeJ)).other(seed);
                double s = this.scoreTripleView(seed, viewB, viewC);
                if (!(s > bestScore)) continue;
                bestScore = s;
                selected[0] = edgeI;
                selected[1] = edgeJ;
            }
        }
        return bestScore != 0.0;
    }

    double scoreTripleView(PairwiseImageGraph.View seedA, PairwiseImageGraph.View viewB, PairwiseImageGraph.View viewC) {
        PairwiseImageGraph.Motion motionAB = Objects.requireNonNull(seedA.findMotion(viewB));
        PairwiseImageGraph.Motion motionAC = Objects.requireNonNull(seedA.findMotion(viewC));
        PairwiseImageGraph.Motion motionBC = viewB.findMotion(viewC);
        if (motionBC == null) {
            return 0.0;
        }
        double score = 0.0;
        score += motionAB.score3D;
        score += motionAC.score3D;
        return score += motionBC.score3D;
    }

    boolean findRemainingCameraMatrices(LookUpSimilarImages dbSimilar, LookUpCameraInfo dbCams, PairwiseImageGraph.View seed, DogArray_I32 seedConnIdx) {
        int i;
        int numInliers = ((DogArray_I32)this.inlierIndexes.get((int)0)).size;
        BoofMiscOps.checkTrue(numInliers == this.utils.inliersThreeView.size());
        this.points3D.reset();
        for (i = 0; i < this.utils.structure.points.size; ++i) {
            ((SceneStructureCommon.Point[])this.utils.structure.points.data)[i].get(this.points3D.grow());
        }
        this.assocPixel.resize(numInliers);
        for (i = 0; i < numInliers; ++i) {
            ((AssociatedPair)this.assocPixel.get((int)i)).p1.setTo(((AssociatedTriple)this.utils.inliersThreeView.get((int)i)).p1);
        }
        DMatrixRMaj cameraMatrix = new DMatrixRMaj(3, 4);
        for (int motionIdx = 0; motionIdx < seedConnIdx.size; ++motionIdx) {
            int connectionIdx = seedConnIdx.get(motionIdx);
            if (connectionIdx == this.selectedTriple[0] || connectionIdx == this.selectedTriple[1]) continue;
            PairwiseImageGraph.Motion edge = (PairwiseImageGraph.Motion)seed.connections.get(connectionIdx);
            PairwiseImageGraph.View viewI = edge.other(seed);
            dbCams.lookupCalibration(viewI.id, this.utils.priorCamB);
            dbSimilar.lookupPixelFeats(viewI.id, this.utils.featsB);
            BoofMiscOps.offsetPixels(this.utils.featsB.toList(), -this.utils.priorCamB.cx, -this.utils.priorCamB.cy);
            if (!this.computeCameraMatrix(seed, edge, this.utils.featsB, cameraMatrix)) {
                if (this.verbose != null) {
                    this.verbose.println("Pose estimator failed! view='" + viewI.id + "'");
                }
                return false;
            }
            if (this.verbose != null) {
                this.verbose.println("Expanded initial scene to include view='" + viewI.id + "'");
            }
            int indexSbaView = motionIdx + 1;
            dbCams.lookupViewShape(edge.other((PairwiseImageGraph.View)seed).id, this.shape);
            this.utils.structure.setView(indexSbaView, false, cameraMatrix, this.shape.width, this.shape.height);
            SceneObservations.View sbaObsView = this.utils.observations.getView(indexSbaView);
            BoofMiscOps.checkTrue(sbaObsView.size() == 0, "Must be reset to initial state first");
            for (int i2 = 0; i2 < numInliers; ++i2) {
                Point2D_F64 p = ((AssociatedPair)this.assocPixel.get((int)i2)).p2;
                sbaObsView.add(i2, (float)p.x, (float)p.y);
            }
            this.viewsByStructureIndex.set(indexSbaView, viewI);
        }
        return true;
    }

    boolean computeCameraMatrix(PairwiseImageGraph.View seed, PairwiseImageGraph.Motion edge, DogArray<Point2D_F64> featsB, DMatrixRMaj cameraMatrix) {
        DogArray_I32 inlierToSeed = (DogArray_I32)this.inlierIndexes.get(0);
        BoofMiscOps.checkTrue(this.assocPixel.size == inlierToSeed.size);
        PairwiseGraphUtils.createTableViewAtoB(seed, edge, this.utils.table_A_to_B);
        for (int i = 0; i < inlierToSeed.size; ++i) {
            int seedIdx = inlierToSeed.get(i);
            int dstIdx = this.utils.table_A_to_B.data[seedIdx];
            ((AssociatedPair)this.assocPixel.get((int)i)).p2.setTo((Point2D_F64)featsB.get(dstIdx));
        }
        if (this.utils.poseEstimator.processHomogenous(this.assocPixel.toList(), this.points3D.toList())) {
            cameraMatrix.setTo(this.utils.poseEstimator.getProjective());
            return true;
        }
        return false;
    }

    protected void createObservationsForBundleAdjustment(DogArray_I32 seedConnIdx) {
        DogArray_I32 inlierToSeed = (DogArray_I32)this.inlierIndexes.get(0);
        this.utils.observations.initialize(this.inlierIndexes.size);
        SceneObservations.View obsView = this.utils.observations.getView(0);
        for (int i = 0; i < inlierToSeed.size; ++i) {
            int id = inlierToSeed.data[i];
            Point2D_F64 o = (Point2D_F64)this.utils.featsA.get(id);
            id = this.seedToStructure.data[id];
            obsView.add(id, (float)o.x, (float)o.y);
        }
        for (int motionIdx = 0; motionIdx < seedConnIdx.size(); ++motionIdx) {
            SceneObservations.View obsView2 = this.utils.observations.getView(motionIdx + 1);
            PairwiseImageGraph.Motion m = (PairwiseImageGraph.Motion)this.utils.seed.connections.get(seedConnIdx.get(motionIdx));
            PairwiseImageGraph.View v = m.other(this.utils.seed);
            boolean seedIsSrc = m.src == this.utils.seed;
            this.utils.dbCams.lookupCalibration(this.utils.dbCams.viewToCamera(v.id), this.utils.priorCamB);
            this.utils.dbSimilar.lookupPixelFeats(v.id, this.utils.featsB);
            BoofMiscOps.offsetPixels(this.utils.featsB.toList(), -this.utils.priorCamB.cx, -this.utils.priorCamB.cy);
            DogArray_I32 connInlierIndexes = (DogArray_I32)this.inlierIndexes.get(motionIdx + 1);
            connInlierIndexes.resize(inlierToSeed.size);
            for (int epipolarInlierIdx = 0; epipolarInlierIdx < m.inliers.size; ++epipolarInlierIdx) {
                AssociatedIndex a = (AssociatedIndex)m.inliers.get(epipolarInlierIdx);
                int structId = this.seedToStructure.data[seedIsSrc ? a.src : a.dst];
                if (structId < 0) continue;
                connInlierIndexes.set(structId, seedIsSrc ? a.dst : a.src);
                Point2D_F64 o = (Point2D_F64)this.utils.featsB.get(seedIsSrc ? a.dst : a.src);
                obsView2.add(structId, (float)o.x, (float)o.y);
            }
        }
    }

    public void lookupInfoForMetricElevation(List<String> viewIds, DogArray<ElevateViewInfo> views, DogArray<DMatrixRMaj> cameraMatrices, DogArray<AssociatedTupleDN> observations) {
        int numViews = this.utils.structure.views.size;
        viewIds.clear();
        views.resize(numViews);
        cameraMatrices.resize(numViews - 1);
        observations.resize(((DogArray_I32)this.inlierIndexes.get((int)0)).size);
        TIntIntHashMap dbToCamera = new TIntIntHashMap(){
            {
                this.no_entry_value = -1;
            }
        };
        for (int obsIdx = 0; obsIdx < observations.size; ++obsIdx) {
            ((AssociatedTupleDN)observations.get(obsIdx)).resize(numViews);
        }
        for (int viewIdx = 0; viewIdx < numViews; ++viewIdx) {
            SceneStructureProjective.View pview = (SceneStructureProjective.View)this.utils.structure.views.get(viewIdx);
            if (viewIdx != 0) {
                ((DMatrixRMaj)cameraMatrices.get(viewIdx - 1)).setTo(pview.worldToView);
            } else {
                BoofMiscOps.checkTrue(MatrixFeatures_DDRM.isIdentity(pview.worldToView, 1.0E-8));
            }
            String id = ((PairwiseImageGraph.View)this.viewsByStructureIndex.get((int)viewIdx)).id;
            viewIds.add(id);
            int cameraDB = this.utils.dbCams.viewToCamera(id);
            int cameraIdx = dbToCamera.get(cameraDB);
            if (cameraIdx == -1) {
                cameraIdx = dbToCamera.size();
                dbToCamera.put(cameraDB, cameraIdx);
            }
            ((ElevateViewInfo)views.get(viewIdx)).setTo(pview.width, pview.height, cameraIdx);
            SceneObservations.View oview = (SceneObservations.View)this.utils.observations.views.get(viewIdx);
            BoofMiscOps.checkTrue(oview.size() == observations.size);
            for (int obsIdx = 0; obsIdx < observations.size; ++obsIdx) {
                int featureIdx = oview.getPointId(obsIdx);
                BoofMiscOps.checkTrue(featureIdx != -1, "Every feature should be visible in all views");
                oview.getPixel(obsIdx, ((AssociatedTupleDN)observations.get(featureIdx)).get(viewIdx));
            }
        }
    }

    public SceneStructureProjective getStructure() {
        return this.utils.structure;
    }

    public PairwiseImageGraph.View getPairwiseGraphViewByStructureIndex(int index) {
        return (PairwiseImageGraph.View)this.viewsByStructureIndex.get(index);
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix(this, out);
    }

    public PairwiseGraphUtils getUtils() {
        return this.utils;
    }

    public void setUtils(PairwiseGraphUtils utils) {
        this.utils = utils;
    }

    public DogArray<DogArray_I32> getInlierIndexes() {
        return this.inlierIndexes;
    }
}

