/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.scene.vocabtree;

import boofcv.alg.scene.vocabtree.HierarchicalVocabularyTree;
import boofcv.misc.BoofLambdas;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.ConfigLength;
import boofcv.struct.PackedArray;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import org.ddogleg.clustering.kmeans.StandardKMeans;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F64;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public class LearnHierarchicalTree<Point>
implements VerbosePrint {
    public ConfigLength minimumPointsForChildren = ConfigLength.fixed(0.0);
    protected final DogArray<PackedArray<Point>> listPoints;
    protected final DogArray<StandardKMeans<Point>> listKMeans;
    protected final DogArray<DogArray_F64> listWeights = new DogArray<DogArray_F64>(DogArray_F64::new);
    protected int pointsRequiredForChildren;
    protected int totalPoints;
    @Nullable
    protected PrintStream verbose;

    public LearnHierarchicalTree(BoofLambdas.Factory<PackedArray<Point>> factoryStorage, BoofLambdas.Factory<StandardKMeans<Point>> factoryKMeans, long randomSeed) {
        this.listPoints = new DogArray<PackedArray>(factoryStorage::newInstance, PackedArray::reset);
        this.listKMeans = new DogArray<StandardKMeans>(0, factoryKMeans::newInstance);
        this.listKMeans.setInitialize(kmeans -> kmeans.initialize(randomSeed));
    }

    public void process(PackedArray<Point> points, HierarchicalVocabularyTree<Point> tree) {
        tree.checkConfig();
        tree.reset();
        this.totalPoints = points.size();
        if (points.size() == 0) {
            if (this.verbose != null) {
                this.verbose.println("No points to process!");
            }
            return;
        }
        this.listPoints.resize(tree.maximumLevel);
        this.listKMeans.resize(tree.maximumLevel);
        this.listWeights.resize(tree.maximumLevel);
        this.pointsRequiredForChildren = Math.max(1, this.minimumPointsForChildren.computeI(points.size()) - 1);
        if (this.verbose != null) {
            this.verbose.println("pointsRequiredForChildren=" + this.pointsRequiredForChildren + " points.size=" + points.size());
        }
        this.processLevel(points, tree, 0, 0);
    }

    private void processLevel(PackedArray<Point> pointsInParent, HierarchicalVocabularyTree<Point> tree, int level, int parentNodeIdx) {
        if (level >= tree.maximumLevel || pointsInParent.size() <= this.pointsRequiredForChildren) {
            return;
        }
        StandardKMeans kmeans = (StandardKMeans)this.listKMeans.get(level);
        kmeans.process(pointsInParent, tree.branchFactor);
        DogArray_I32 assignments = kmeans.getAssignments();
        List clusterMeans = kmeans.getBestClusters().toList();
        for (int label = 0; label < clusterMeans.size(); ++label) {
            tree.addNode(parentNodeIdx, label, clusterMeans.get(label));
        }
        if (this.verbose != null) {
            this.verbose.println("level=" + level + " kmeans.score=" + kmeans.getBestClusterScore());
        }
        HierarchicalVocabularyTree.Node parent = (HierarchicalVocabularyTree.Node)tree.nodes.get(parentNodeIdx);
        PackedArray pointsInBranch = (PackedArray)this.listPoints.get(level);
        pointsInBranch.reserve(pointsInParent.size() / (tree.branchFactor - 1));
        this.processChildren(tree, level, parent, pointsInParent, clusterMeans, assignments, pointsInBranch);
    }

    private void processChildren(HierarchicalVocabularyTree<Point> tree, int level, HierarchicalVocabularyTree.Node parent, PackedArray<Point> pointsInParent, List<Point> clusterMeans, DogArray_I32 assignments, PackedArray<Point> pointsInBranch) {
        int sumLabeledPoints = 0;
        for (int label = 0; label < clusterMeans.size(); ++label) {
            int nodeIdx = parent.childrenIndexes.get(label);
            pointsInBranch.reset();
            for (int pointIdx = 0; pointIdx < pointsInParent.size(); ++pointIdx) {
                if (assignments.get(pointIdx) != label) continue;
                pointsInBranch.append(pointsInParent.getTemp(pointIdx));
            }
            sumLabeledPoints += pointsInBranch.size();
            if (this.verbose != null) {
                this.verbose.println("level=" + level + " branch=" + label + " points.size=" + pointsInBranch.size());
            }
            this.processLevel(pointsInBranch, tree, level + 1, nodeIdx);
        }
        BoofMiscOps.checkEq(sumLabeledPoints, pointsInParent.size());
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> set) {
        this.verbose = BoofMiscOps.addPrefix(this, out);
    }
}

