/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.scene.ann;

import boofcv.alg.scene.bow.BowDistanceTypes;
import boofcv.alg.scene.bow.BowMatch;
import boofcv.alg.scene.bow.BowUtils;
import boofcv.alg.scene.bow.InvertedFile;
import boofcv.alg.scene.nister2006.TupleMapDistanceNorm;
import boofcv.misc.BoofLambdas;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.struct.BigDogArray_I32;
import org.ddogleg.struct.BigDogGrowth;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F32;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public class RecognitionNearestNeighborInvertedFile<Point>
implements VerbosePrint {
    protected NearestNeighbor<Point> nearestNeighbor;
    protected TupleMapDistanceNorm distanceFunction = new TupleMapDistanceNorm.L2();
    protected final BigDogArray_I32 imagesDB = new BigDogArray_I32(100, 10000, BigDogGrowth.GROW_FIRST);
    DogArray<BowMatch> matches = new DogArray<BowMatch>(BowMatch::new, BowMatch::reset);
    DogArray<InvertedFile> invertedFiles = new DogArray<InvertedFile>(InvertedFile::new, InvertedFile::reset);
    public NearestNeighbor.Search<Point> search;
    public final NnData<Point> searchResult = new NnData();
    DogArray_I32 imageIdx_to_match = new DogArray_I32();
    DogArray_I32 wordHistogram = new DogArray_I32();
    public DogArray_I32 observedWords = new DogArray_I32();
    DogArray_F32 tmpDescWeights = new DogArray_F32();
    @Nullable
    PrintStream verbose;

    public void initialize(NearestNeighbor<Point> nearestNeighbor, int numWords) {
        this.nearestNeighbor = nearestNeighbor;
        this.invertedFiles.resize(numWords);
        this.imagesDB.reset();
        this.wordHistogram.resetResize(numWords, 0);
        this.search = nearestNeighbor.createSearch();
    }

    public void clearImages() {
        this.imagesDB.reset();
        int numWords = this.invertedFiles.size;
        this.invertedFiles.reset();
        this.invertedFiles.resize(numWords);
    }

    public void addImage(int imageID, List<Point> imageFeatures) {
        if (imageFeatures.isEmpty()) {
            return;
        }
        int imageIdx = this.imagesDB.size;
        this.imagesDB.append(imageID);
        this.computeWordHistogram(imageFeatures);
        this.computeImageDescriptor(imageFeatures.size());
        for (int i = 0; i < this.observedWords.size; ++i) {
            int word = this.observedWords.get(i);
            ((InvertedFile)this.invertedFiles.get(word)).addImage(imageIdx, this.tmpDescWeights.get(i));
        }
    }

    void computeWordHistogram(List<Point> imageFeatures) {
        this.observedWords.reset();
        for (int featureIdx = 0; featureIdx < imageFeatures.size(); ++featureIdx) {
            if (!this.search.findNearest(imageFeatures.get(featureIdx), -1.0, this.searchResult)) continue;
            int count = this.wordHistogram.data[this.searchResult.index];
            this.wordHistogram.data[this.searchResult.index] = count + 1;
            if (count != 0) continue;
            this.observedWords.add(this.searchResult.index);
        }
    }

    void computeImageDescriptor(float totalUniqueWordsSeenByImage) {
        this.tmpDescWeights.reset();
        for (int i = 0; i < this.observedWords.size; ++i) {
            int word = this.observedWords.get(i);
            float termFrequency = (float)this.wordHistogram.get(word) / totalUniqueWordsSeenByImage;
            this.tmpDescWeights.add(termFrequency);
            this.wordHistogram.set(word, 0);
        }
        this.distanceFunction.normalize(this.tmpDescWeights);
    }

    public boolean query(List<Point> queryImage, @Nullable BoofLambdas.FilterInt filter, int limit) {
        this.matches.reset();
        if (queryImage.isEmpty()) {
            return false;
        }
        this.computeWordHistogram(queryImage);
        this.computeImageDescriptor(queryImage.size());
        this.findAndScoreMatches();
        if (this.matches.isEmpty()) {
            return false;
        }
        if (this.verbose != null) {
            this.verbose.println("raw matches.size=" + this.matches.size);
        }
        for (int candidateIter = 0; candidateIter < this.matches.size; ++candidateIter) {
            BowMatch c = (BowMatch)this.matches.get(candidateIter);
            this.imageIdx_to_match.set(c.identification, -1);
            c.identification = this.imagesDB.get(c.identification);
        }
        BowUtils.filterAndSortMatches(this.matches, filter, limit);
        return this.matches.size > 0;
    }

    void findAndScoreMatches() {
        this.imageIdx_to_match.resize(this.imagesDB.size, -1);
        this.matches.reset();
        for (int wordIdx = 0; wordIdx < this.observedWords.size; ++wordIdx) {
            float queryWordWeight = this.tmpDescWeights.get(wordIdx);
            int word = this.observedWords.get(wordIdx);
            InvertedFile invertedFile = (InvertedFile)this.invertedFiles.get(word);
            int N = invertedFile.weights.size;
            for (int invertedIdx = 0; invertedIdx < N; ++invertedIdx) {
                BowMatch m;
                int imageIdx = invertedFile.get(invertedIdx);
                int matchIdx = this.imageIdx_to_match.get(imageIdx);
                if (matchIdx == -1) {
                    this.imageIdx_to_match.set(imageIdx, this.matches.size);
                    m = this.matches.grow();
                    m.identification = imageIdx;
                } else {
                    m = (BowMatch)this.matches.get(matchIdx);
                }
                m.error += this.distanceFunction.distanceUpdate(queryWordWeight, invertedFile.weights.get(invertedIdx));
            }
        }
    }

    public void setDistanceType(BowDistanceTypes type) {
        TupleMapDistanceNorm tupleMapDistanceNorm;
        switch (type) {
            case L1: {
                tupleMapDistanceNorm = new TupleMapDistanceNorm.L1();
                break;
            }
            case L2: {
                tupleMapDistanceNorm = new TupleMapDistanceNorm.L2();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + type);
            }
        }
        this.distanceFunction = tupleMapDistanceNorm;
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = out;
    }

    public NearestNeighbor<Point> getNearestNeighbor() {
        return this.nearestNeighbor;
    }

    public TupleMapDistanceNorm getDistanceFunction() {
        return this.distanceFunction;
    }

    public void setDistanceFunction(TupleMapDistanceNorm distanceFunction) {
        this.distanceFunction = distanceFunction;
    }

    public BigDogArray_I32 getImagesDB() {
        return this.imagesDB;
    }

    public DogArray<BowMatch> getMatches() {
        return this.matches;
    }

    public DogArray<InvertedFile> getInvertedFiles() {
        return this.invertedFiles;
    }
}

