/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.mvs.impl;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.mvs.DisparityParameters;
import boofcv.misc.BoofLambdas;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import georegression.struct.point.Point2D_F64;

public class ImplMultiViewStereoOps {
    public static void disparityToCloud(GrayF32 disparity, GrayU8 mask, DisparityParameters parameters, BoofLambdas.PixXyzConsumer_F64 consumer) {
        InputSanityCheck.checkSameShape(disparity, mask);
        CameraPinhole intrinsic = parameters.pinhole;
        double baseline = parameters.baseline;
        double disparityMin = parameters.disparityMin;
        double[] R = parameters.rotateToRectified.data;
        Point2D_F64 norm = new Point2D_F64();
        for (int pixY = 0; pixY < disparity.height; ++pixY) {
            int indexDisp = disparity.startIndex + pixY * disparity.stride;
            int indexMask = mask.startIndex + pixY * mask.stride;
            int pixX = 0;
            while (pixX < disparity.width) {
                float d;
                if (mask.data[indexMask] == 0 && !((d = disparity.data[indexDisp]) >= (float)parameters.disparityRange)) {
                    PerspectiveOps.convertPixelToNorm(intrinsic, pixX, pixY, norm);
                    double Z2 = baseline * intrinsic.fx / ((double)d + disparityMin);
                    double X2 = Z2 * norm.x;
                    double Y2 = Z2 * norm.y;
                    double outX = R[0] * X2 + R[3] * Y2 + R[6] * Z2;
                    double outY = R[1] * X2 + R[4] * Y2 + R[7] * Z2;
                    double outZ = R[2] * X2 + R[5] * Y2 + R[8] * Z2;
                    consumer.process(pixX, pixY, outX, outY, outZ);
                }
                ++pixX;
                ++indexDisp;
                ++indexMask;
            }
        }
    }

    public static void disparityToCloud(GrayF32 disparity, DisparityParameters parameters, PixelTransform<Point2D_F64> pixelToNorm, BoofLambdas.PixXyzConsumer_F64 consumer) {
        CameraPinhole intrinsic = parameters.pinhole;
        double baseline = parameters.baseline;
        double disparityMin = parameters.disparityMin;
        double[] R = parameters.rotateToRectified.data;
        Point2D_F64 norm = new Point2D_F64();
        for (int pixY = 0; pixY < disparity.height; ++pixY) {
            int indexDisp = disparity.startIndex + pixY * disparity.stride;
            int pixX = 0;
            while (pixX < disparity.width) {
                float d = disparity.data[indexDisp];
                if (!(d >= (float)parameters.disparityRange)) {
                    pixelToNorm.compute(pixX, pixY, norm);
                    double Z2 = baseline * intrinsic.fx / ((double)d + disparityMin);
                    double X2 = Z2 * norm.x;
                    double Y2 = Z2 * norm.y;
                    double outX = R[0] * X2 + R[3] * Y2 + R[6] * Z2;
                    double outY = R[1] * X2 + R[4] * Y2 + R[7] * Z2;
                    double outZ = R[2] * X2 + R[5] * Y2 + R[8] * Z2;
                    consumer.process(pixX, pixY, outX, outY, outZ);
                }
                ++pixX;
                ++indexDisp;
            }
        }
    }

    public static void disparityToCloud(GrayU8 disparity, DisparityParameters parameters, PixelTransform<Point2D_F64> pixelToNorm, BoofLambdas.PixXyzConsumer_F64 consumer) {
        CameraPinhole intrinsic = parameters.pinhole;
        double baseline = parameters.baseline;
        double disparityMin = parameters.disparityMin;
        double[] R = parameters.rotateToRectified.data;
        Point2D_F64 norm = new Point2D_F64();
        for (int pixY = 0; pixY < disparity.height; ++pixY) {
            int indexDisp = disparity.startIndex + pixY * disparity.stride;
            int pixX = 0;
            while (pixX < disparity.width) {
                int d = disparity.data[indexDisp] & 0xFF;
                if (d < parameters.disparityRange) {
                    pixelToNorm.compute(pixX, pixY, norm);
                    double Z2 = baseline * intrinsic.fx / ((double)d + disparityMin);
                    double X2 = Z2 * norm.x;
                    double Y2 = Z2 * norm.y;
                    double outX = R[0] * X2 + R[3] * Y2 + R[6] * Z2;
                    double outY = R[1] * X2 + R[4] * Y2 + R[7] * Z2;
                    double outZ = R[2] * X2 + R[5] * Y2 + R[8] * Z2;
                    consumer.process(pixX, pixY, outX, outY, outZ);
                }
                ++pixX;
                ++indexDisp;
            }
        }
    }
}

