/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.misc;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.misc.impl.ImplImageMiscOps;
import boofcv.alg.misc.impl.ImplImageMiscOps_MT;
import boofcv.concurrency.BoofConcurrency;
import boofcv.misc.BoofLambdas;
import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.border.ImageBorder_F64;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.border.ImageBorder_S64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedI16;
import boofcv.struct.image.InterleavedI8;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedS64;
import boofcv.struct.image.InterleavedS8;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;
import java.util.Random;
import org.jetbrains.annotations.Nullable;

public class ImageMiscOps {
    public static int MIN_ELEMENTS_CONCURRENT = 160000;

    public static boolean runConcurrent(ImageBase image) {
        return ImageMiscOps.runConcurrent(image.width * image.height);
    }

    public static boolean runConcurrent(int numElements) {
        return BoofConcurrency.isUseConcurrent() && numElements >= MIN_ELEMENTS_CONCURRENT;
    }

    public static <T extends GrayI8<T>> void copy(int srcX, int srcY, int dstX, int dstY, int width, int height, T input, ImageBorder_S32<T> border, GrayI8 output) {
        ImplImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, input, border, output);
    }

    public static void copy(int srcX, int srcY, int dstX, int dstY, int width, int height, GrayI8 input, GrayI8 output) {
        ImplImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, input, output);
    }

    public static void copy(int srcX, int srcY, int dstX, int dstY, int width, int height, InterleavedI8 input, InterleavedI8 output) {
        ImplImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, input, output);
    }

    public static void fill(GrayI8 image, int value) {
        ImplImageMiscOps.fill(image, value);
    }

    public static void fill(InterleavedI8 image, int value) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.fill(image, value);
        } else {
            ImplImageMiscOps.fill(image, value);
        }
    }

    public static void fill(InterleavedI8 image, int[] values) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.fill(image, values);
        } else {
            ImplImageMiscOps.fill(image, values);
        }
    }

    public static void fillBand(InterleavedI8 image, int band, int value) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.fillBand(image, band, value);
        } else {
            ImplImageMiscOps.fillBand(image, band, value);
        }
    }

    public static void insertBand(GrayI8 input, int band, InterleavedI8 output) {
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.insertBand(input, band, output);
        } else {
            ImplImageMiscOps.insertBand(input, band, output);
        }
    }

    public static void extractBand(InterleavedI8 input, int band, GrayI8 output) {
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.extractBand(input, band, output);
        } else {
            ImplImageMiscOps.extractBand(input, band, output);
        }
    }

    public static void fillBorder(GrayI8 image, int value, int radius) {
        ImplImageMiscOps.fillBorder(image, value, radius);
    }

    public static void fillBorder(GrayI8 image, int value, int borderX0, int borderY0, int borderX1, int borderY1) {
        ImplImageMiscOps.fillBorder(image, value, borderX0, borderY0, borderX1, borderY1);
    }

    public static void fillRectangle(GrayI8 image, int value, int x0, int y0, int width, int height) {
        ImplImageMiscOps.fillRectangle(image, value, x0, y0, width, height);
    }

    public static void fillRectangle(InterleavedI8 image, int value, int x0, int y0, int width, int height) {
        ImplImageMiscOps.fillRectangle(image, value, x0, y0, width, height);
    }

    public static void fillUniform(GrayI8 img, Random rand, int min, int max) {
        ImplImageMiscOps.fillUniform(img, rand, min, max);
    }

    public static void fillUniform(InterleavedI8 img, Random rand, int min, int max) {
        ImplImageMiscOps.fillUniform(img, rand, min, max);
    }

    public static void fillGaussian(GrayI8 input, Random rand, double mean, double sigma, int lowerBound, int upperBound) {
        ImplImageMiscOps.fillGaussian(input, rand, mean, sigma, lowerBound, upperBound);
    }

    public static void fillGaussian(InterleavedI8 input, Random rand, double mean, double sigma, int lowerBound, int upperBound) {
        ImplImageMiscOps.fillGaussian(input, rand, mean, sigma, lowerBound, upperBound);
    }

    public static void flipVertical(GrayI8 image) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.flipVertical(image);
        } else {
            ImplImageMiscOps.flipVertical(image);
        }
    }

    public static void flipHorizontal(GrayI8 image) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.flipHorizontal(image);
        } else {
            ImplImageMiscOps.flipHorizontal(image);
        }
    }

    public static <T extends GrayI8<T>> T transpose(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        ImplImageMiscOps.transpose(input, output);
        return output;
    }

    public static void rotateCW(GrayI8 image) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.rotateCW(image);
        } else {
            ImplImageMiscOps.rotateCW(image);
        }
    }

    public static <T extends InterleavedI8<T>> T transpose(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.transpose(input, output);
        } else {
            ImplImageMiscOps.transpose(input, output);
        }
        return output;
    }

    public static <T extends GrayI8<T>> T rotateCW(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.rotateCW(input, output);
        } else {
            ImplImageMiscOps.rotateCW(input, output);
        }
        return output;
    }

    public static <T extends InterleavedI8<T>> T rotateCW(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.rotateCW(input, output);
        } else {
            ImplImageMiscOps.rotateCW(input, output);
        }
        return output;
    }

    public static void rotateCCW(GrayI8 image) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.rotateCCW(image);
        } else {
            ImplImageMiscOps.rotateCCW(image);
        }
    }

    public static <T extends GrayI8<T>> T rotateCCW(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.rotateCCW(input, output);
        } else {
            ImplImageMiscOps.rotateCCW(input, output);
        }
        return output;
    }

    public static <T extends InterleavedI8<T>> T rotateCCW(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.rotateCCW(input, output);
        } else {
            ImplImageMiscOps.rotateCCW(input, output);
        }
        return output;
    }

    public static <T extends GrayI8<T>> void growBorder(T src, ImageBorder_S32<T> border, int borderX0, int borderY0, int borderX1, int borderY1, T dst) {
        if (ImageMiscOps.runConcurrent(src)) {
            ImplImageMiscOps_MT.growBorder(src, border, borderX0, borderY0, borderX1, borderY1, dst);
        } else {
            ImplImageMiscOps.growBorder(src, border, borderX0, borderY0, borderX1, borderY1, dst);
        }
    }

    public static void findAndProcess(GrayI8 input, BoofLambdas.Match_I8 finder, BoofLambdas.ProcessIIB process) {
        ImplImageMiscOps.findAndProcess(input, finder, process);
    }

    public static <T extends GrayI16<T>> void copy(int srcX, int srcY, int dstX, int dstY, int width, int height, T input, ImageBorder_S32<T> border, GrayI16 output) {
        ImplImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, input, border, output);
    }

    public static void copy(int srcX, int srcY, int dstX, int dstY, int width, int height, GrayI16 input, GrayI16 output) {
        ImplImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, input, output);
    }

    public static void copy(int srcX, int srcY, int dstX, int dstY, int width, int height, InterleavedI16 input, InterleavedI16 output) {
        ImplImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, input, output);
    }

    public static void fill(GrayI16 image, int value) {
        ImplImageMiscOps.fill(image, value);
    }

    public static void fill(InterleavedI16 image, int value) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.fill(image, value);
        } else {
            ImplImageMiscOps.fill(image, value);
        }
    }

    public static void fill(InterleavedI16 image, int[] values) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.fill(image, values);
        } else {
            ImplImageMiscOps.fill(image, values);
        }
    }

    public static void fillBand(InterleavedI16 image, int band, int value) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.fillBand(image, band, value);
        } else {
            ImplImageMiscOps.fillBand(image, band, value);
        }
    }

    public static void insertBand(GrayI16 input, int band, InterleavedI16 output) {
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.insertBand(input, band, output);
        } else {
            ImplImageMiscOps.insertBand(input, band, output);
        }
    }

    public static void extractBand(InterleavedI16 input, int band, GrayI16 output) {
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.extractBand(input, band, output);
        } else {
            ImplImageMiscOps.extractBand(input, band, output);
        }
    }

    public static void fillBorder(GrayI16 image, int value, int radius) {
        ImplImageMiscOps.fillBorder(image, value, radius);
    }

    public static void fillBorder(GrayI16 image, int value, int borderX0, int borderY0, int borderX1, int borderY1) {
        ImplImageMiscOps.fillBorder(image, value, borderX0, borderY0, borderX1, borderY1);
    }

    public static void fillRectangle(GrayI16 image, int value, int x0, int y0, int width, int height) {
        ImplImageMiscOps.fillRectangle(image, value, x0, y0, width, height);
    }

    public static void fillRectangle(InterleavedI16 image, int value, int x0, int y0, int width, int height) {
        ImplImageMiscOps.fillRectangle(image, value, x0, y0, width, height);
    }

    public static void fillUniform(GrayI16 img, Random rand, int min, int max) {
        ImplImageMiscOps.fillUniform(img, rand, min, max);
    }

    public static void fillUniform(InterleavedI16 img, Random rand, int min, int max) {
        ImplImageMiscOps.fillUniform(img, rand, min, max);
    }

    public static void fillGaussian(GrayI16 input, Random rand, double mean, double sigma, int lowerBound, int upperBound) {
        ImplImageMiscOps.fillGaussian(input, rand, mean, sigma, lowerBound, upperBound);
    }

    public static void fillGaussian(InterleavedI16 input, Random rand, double mean, double sigma, int lowerBound, int upperBound) {
        ImplImageMiscOps.fillGaussian(input, rand, mean, sigma, lowerBound, upperBound);
    }

    public static void flipVertical(GrayI16 image) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.flipVertical(image);
        } else {
            ImplImageMiscOps.flipVertical(image);
        }
    }

    public static void flipHorizontal(GrayI16 image) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.flipHorizontal(image);
        } else {
            ImplImageMiscOps.flipHorizontal(image);
        }
    }

    public static <T extends GrayI16<T>> T transpose(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        ImplImageMiscOps.transpose(input, output);
        return output;
    }

    public static void rotateCW(GrayI16 image) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.rotateCW(image);
        } else {
            ImplImageMiscOps.rotateCW(image);
        }
    }

    public static <T extends InterleavedI16<T>> T transpose(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.transpose(input, output);
        } else {
            ImplImageMiscOps.transpose(input, output);
        }
        return output;
    }

    public static <T extends GrayI16<T>> T rotateCW(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.rotateCW(input, output);
        } else {
            ImplImageMiscOps.rotateCW(input, output);
        }
        return output;
    }

    public static <T extends InterleavedI16<T>> T rotateCW(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.rotateCW(input, output);
        } else {
            ImplImageMiscOps.rotateCW(input, output);
        }
        return output;
    }

    public static void rotateCCW(GrayI16 image) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.rotateCCW(image);
        } else {
            ImplImageMiscOps.rotateCCW(image);
        }
    }

    public static <T extends GrayI16<T>> T rotateCCW(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.rotateCCW(input, output);
        } else {
            ImplImageMiscOps.rotateCCW(input, output);
        }
        return output;
    }

    public static <T extends InterleavedI16<T>> T rotateCCW(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.rotateCCW(input, output);
        } else {
            ImplImageMiscOps.rotateCCW(input, output);
        }
        return output;
    }

    public static <T extends GrayI16<T>> void growBorder(T src, ImageBorder_S32<T> border, int borderX0, int borderY0, int borderX1, int borderY1, T dst) {
        if (ImageMiscOps.runConcurrent(src)) {
            ImplImageMiscOps_MT.growBorder(src, border, borderX0, borderY0, borderX1, borderY1, dst);
        } else {
            ImplImageMiscOps.growBorder(src, border, borderX0, borderY0, borderX1, borderY1, dst);
        }
    }

    public static void findAndProcess(GrayI16 input, BoofLambdas.Match_I16 finder, BoofLambdas.ProcessIIB process) {
        ImplImageMiscOps.findAndProcess(input, finder, process);
    }

    public static void copy(int srcX, int srcY, int dstX, int dstY, int width, int height, GrayS32 input, ImageBorder_S32 border, GrayS32 output) {
        ImplImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, input, border, output);
    }

    public static void copy(int srcX, int srcY, int dstX, int dstY, int width, int height, GrayS32 input, GrayS32 output) {
        ImplImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, input, output);
    }

    public static void copy(int srcX, int srcY, int dstX, int dstY, int width, int height, InterleavedS32 input, InterleavedS32 output) {
        ImplImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, input, output);
    }

    public static void fill(GrayS32 image, int value) {
        ImplImageMiscOps.fill(image, value);
    }

    public static void fill(InterleavedS32 image, int value) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.fill(image, value);
        } else {
            ImplImageMiscOps.fill(image, value);
        }
    }

    public static void fill(InterleavedS32 image, int[] values) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.fill(image, values);
        } else {
            ImplImageMiscOps.fill(image, values);
        }
    }

    public static void fillBand(InterleavedS32 image, int band, int value) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.fillBand(image, band, value);
        } else {
            ImplImageMiscOps.fillBand(image, band, value);
        }
    }

    public static void insertBand(GrayS32 input, int band, InterleavedS32 output) {
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.insertBand(input, band, output);
        } else {
            ImplImageMiscOps.insertBand(input, band, output);
        }
    }

    public static void extractBand(InterleavedS32 input, int band, GrayS32 output) {
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.extractBand(input, band, output);
        } else {
            ImplImageMiscOps.extractBand(input, band, output);
        }
    }

    public static void fillBorder(GrayS32 image, int value, int radius) {
        ImplImageMiscOps.fillBorder(image, value, radius);
    }

    public static void fillBorder(GrayS32 image, int value, int borderX0, int borderY0, int borderX1, int borderY1) {
        ImplImageMiscOps.fillBorder(image, value, borderX0, borderY0, borderX1, borderY1);
    }

    public static void fillRectangle(GrayS32 image, int value, int x0, int y0, int width, int height) {
        ImplImageMiscOps.fillRectangle(image, value, x0, y0, width, height);
    }

    public static void fillRectangle(InterleavedS32 image, int value, int x0, int y0, int width, int height) {
        ImplImageMiscOps.fillRectangle(image, value, x0, y0, width, height);
    }

    public static void fillUniform(GrayS32 img, Random rand, int min, int max) {
        ImplImageMiscOps.fillUniform(img, rand, min, max);
    }

    public static void fillUniform(InterleavedS32 img, Random rand, int min, int max) {
        ImplImageMiscOps.fillUniform(img, rand, min, max);
    }

    public static void fillGaussian(GrayS32 input, Random rand, double mean, double sigma, int lowerBound, int upperBound) {
        ImplImageMiscOps.fillGaussian(input, rand, mean, sigma, lowerBound, upperBound);
    }

    public static void fillGaussian(InterleavedS32 input, Random rand, double mean, double sigma, int lowerBound, int upperBound) {
        ImplImageMiscOps.fillGaussian(input, rand, mean, sigma, lowerBound, upperBound);
    }

    public static void flipVertical(GrayS32 image) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.flipVertical(image);
        } else {
            ImplImageMiscOps.flipVertical(image);
        }
    }

    public static void flipHorizontal(GrayS32 image) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.flipHorizontal(image);
        } else {
            ImplImageMiscOps.flipHorizontal(image);
        }
    }

    public static <T extends GrayS32> T transpose(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        ImplImageMiscOps.transpose(input, output);
        return output;
    }

    public static void rotateCW(GrayS32 image) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.rotateCW(image);
        } else {
            ImplImageMiscOps.rotateCW(image);
        }
    }

    public static <T extends InterleavedS32> T transpose(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.transpose(input, output);
        } else {
            ImplImageMiscOps.transpose(input, output);
        }
        return output;
    }

    public static <T extends GrayS32> T rotateCW(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.rotateCW(input, output);
        } else {
            ImplImageMiscOps.rotateCW(input, output);
        }
        return output;
    }

    public static <T extends InterleavedS32> T rotateCW(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.rotateCW(input, output);
        } else {
            ImplImageMiscOps.rotateCW(input, output);
        }
        return output;
    }

    public static void rotateCCW(GrayS32 image) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.rotateCCW(image);
        } else {
            ImplImageMiscOps.rotateCCW(image);
        }
    }

    public static <T extends GrayS32> T rotateCCW(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.rotateCCW(input, output);
        } else {
            ImplImageMiscOps.rotateCCW(input, output);
        }
        return output;
    }

    public static <T extends InterleavedS32> T rotateCCW(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.rotateCCW(input, output);
        } else {
            ImplImageMiscOps.rotateCCW(input, output);
        }
        return output;
    }

    public static void growBorder(GrayS32 src, ImageBorder_S32 border, int borderX0, int borderY0, int borderX1, int borderY1, GrayS32 dst) {
        if (ImageMiscOps.runConcurrent(src)) {
            ImplImageMiscOps_MT.growBorder(src, border, borderX0, borderY0, borderX1, borderY1, dst);
        } else {
            ImplImageMiscOps.growBorder(src, border, borderX0, borderY0, borderX1, borderY1, dst);
        }
    }

    public static void findAndProcess(GrayS32 input, BoofLambdas.Match_S32 finder, BoofLambdas.ProcessIIB process) {
        ImplImageMiscOps.findAndProcess(input, finder, process);
    }

    public static void copy(int srcX, int srcY, int dstX, int dstY, int width, int height, GrayS64 input, ImageBorder_S64 border, GrayS64 output) {
        ImplImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, input, border, output);
    }

    public static void copy(int srcX, int srcY, int dstX, int dstY, int width, int height, GrayS64 input, GrayS64 output) {
        ImplImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, input, output);
    }

    public static void copy(int srcX, int srcY, int dstX, int dstY, int width, int height, InterleavedS64 input, InterleavedS64 output) {
        ImplImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, input, output);
    }

    public static void fill(GrayS64 image, long value) {
        ImplImageMiscOps.fill(image, value);
    }

    public static void fill(InterleavedS64 image, long value) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.fill(image, value);
        } else {
            ImplImageMiscOps.fill(image, value);
        }
    }

    public static void fill(InterleavedS64 image, long[] values) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.fill(image, values);
        } else {
            ImplImageMiscOps.fill(image, values);
        }
    }

    public static void fillBand(InterleavedS64 image, int band, long value) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.fillBand(image, band, value);
        } else {
            ImplImageMiscOps.fillBand(image, band, value);
        }
    }

    public static void insertBand(GrayS64 input, int band, InterleavedS64 output) {
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.insertBand(input, band, output);
        } else {
            ImplImageMiscOps.insertBand(input, band, output);
        }
    }

    public static void extractBand(InterleavedS64 input, int band, GrayS64 output) {
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.extractBand(input, band, output);
        } else {
            ImplImageMiscOps.extractBand(input, band, output);
        }
    }

    public static void fillBorder(GrayS64 image, long value, int radius) {
        ImplImageMiscOps.fillBorder(image, value, radius);
    }

    public static void fillBorder(GrayS64 image, long value, int borderX0, int borderY0, int borderX1, int borderY1) {
        ImplImageMiscOps.fillBorder(image, value, borderX0, borderY0, borderX1, borderY1);
    }

    public static void fillRectangle(GrayS64 image, long value, int x0, int y0, int width, int height) {
        ImplImageMiscOps.fillRectangle(image, value, x0, y0, width, height);
    }

    public static void fillRectangle(InterleavedS64 image, long value, int x0, int y0, int width, int height) {
        ImplImageMiscOps.fillRectangle(image, value, x0, y0, width, height);
    }

    public static void fillUniform(GrayS64 img, Random rand, long min, long max) {
        ImplImageMiscOps.fillUniform(img, rand, min, max);
    }

    public static void fillUniform(InterleavedS64 img, Random rand, long min, long max) {
        ImplImageMiscOps.fillUniform(img, rand, min, max);
    }

    public static void fillGaussian(GrayS64 input, Random rand, double mean, double sigma, long lowerBound, long upperBound) {
        ImplImageMiscOps.fillGaussian(input, rand, mean, sigma, lowerBound, upperBound);
    }

    public static void fillGaussian(InterleavedS64 input, Random rand, double mean, double sigma, long lowerBound, long upperBound) {
        ImplImageMiscOps.fillGaussian(input, rand, mean, sigma, lowerBound, upperBound);
    }

    public static void flipVertical(GrayS64 image) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.flipVertical(image);
        } else {
            ImplImageMiscOps.flipVertical(image);
        }
    }

    public static void flipHorizontal(GrayS64 image) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.flipHorizontal(image);
        } else {
            ImplImageMiscOps.flipHorizontal(image);
        }
    }

    public static <T extends GrayS64> T transpose(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        ImplImageMiscOps.transpose(input, output);
        return output;
    }

    public static void rotateCW(GrayS64 image) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.rotateCW(image);
        } else {
            ImplImageMiscOps.rotateCW(image);
        }
    }

    public static <T extends InterleavedS64> T transpose(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.transpose(input, output);
        } else {
            ImplImageMiscOps.transpose(input, output);
        }
        return output;
    }

    public static <T extends GrayS64> T rotateCW(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.rotateCW(input, output);
        } else {
            ImplImageMiscOps.rotateCW(input, output);
        }
        return output;
    }

    public static <T extends InterleavedS64> T rotateCW(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.rotateCW(input, output);
        } else {
            ImplImageMiscOps.rotateCW(input, output);
        }
        return output;
    }

    public static void rotateCCW(GrayS64 image) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.rotateCCW(image);
        } else {
            ImplImageMiscOps.rotateCCW(image);
        }
    }

    public static <T extends GrayS64> T rotateCCW(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.rotateCCW(input, output);
        } else {
            ImplImageMiscOps.rotateCCW(input, output);
        }
        return output;
    }

    public static <T extends InterleavedS64> T rotateCCW(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.rotateCCW(input, output);
        } else {
            ImplImageMiscOps.rotateCCW(input, output);
        }
        return output;
    }

    public static void growBorder(GrayS64 src, ImageBorder_S64 border, int borderX0, int borderY0, int borderX1, int borderY1, GrayS64 dst) {
        if (ImageMiscOps.runConcurrent(src)) {
            ImplImageMiscOps_MT.growBorder(src, border, borderX0, borderY0, borderX1, borderY1, dst);
        } else {
            ImplImageMiscOps.growBorder(src, border, borderX0, borderY0, borderX1, borderY1, dst);
        }
    }

    public static void findAndProcess(GrayS64 input, BoofLambdas.Match_S64 finder, BoofLambdas.ProcessIIB process) {
        ImplImageMiscOps.findAndProcess(input, finder, process);
    }

    public static void copy(int srcX, int srcY, int dstX, int dstY, int width, int height, GrayF32 input, ImageBorder_F32 border, GrayF32 output) {
        ImplImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, input, border, output);
    }

    public static void copy(int srcX, int srcY, int dstX, int dstY, int width, int height, GrayF32 input, GrayF32 output) {
        ImplImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, input, output);
    }

    public static void copy(int srcX, int srcY, int dstX, int dstY, int width, int height, InterleavedF32 input, InterleavedF32 output) {
        ImplImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, input, output);
    }

    public static void fill(GrayF32 image, float value) {
        ImplImageMiscOps.fill(image, value);
    }

    public static void fill(InterleavedF32 image, float value) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.fill(image, value);
        } else {
            ImplImageMiscOps.fill(image, value);
        }
    }

    public static void fill(InterleavedF32 image, float[] values) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.fill(image, values);
        } else {
            ImplImageMiscOps.fill(image, values);
        }
    }

    public static void fillBand(InterleavedF32 image, int band, float value) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.fillBand(image, band, value);
        } else {
            ImplImageMiscOps.fillBand(image, band, value);
        }
    }

    public static void insertBand(GrayF32 input, int band, InterleavedF32 output) {
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.insertBand(input, band, output);
        } else {
            ImplImageMiscOps.insertBand(input, band, output);
        }
    }

    public static void extractBand(InterleavedF32 input, int band, GrayF32 output) {
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.extractBand(input, band, output);
        } else {
            ImplImageMiscOps.extractBand(input, band, output);
        }
    }

    public static void fillBorder(GrayF32 image, float value, int radius) {
        ImplImageMiscOps.fillBorder(image, value, radius);
    }

    public static void fillBorder(GrayF32 image, float value, int borderX0, int borderY0, int borderX1, int borderY1) {
        ImplImageMiscOps.fillBorder(image, value, borderX0, borderY0, borderX1, borderY1);
    }

    public static void fillRectangle(GrayF32 image, float value, int x0, int y0, int width, int height) {
        ImplImageMiscOps.fillRectangle(image, value, x0, y0, width, height);
    }

    public static void fillRectangle(InterleavedF32 image, float value, int x0, int y0, int width, int height) {
        ImplImageMiscOps.fillRectangle(image, value, x0, y0, width, height);
    }

    public static void fillUniform(GrayF32 img, Random rand, float min, float max) {
        ImplImageMiscOps.fillUniform(img, rand, min, max);
    }

    public static void fillUniform(InterleavedF32 img, Random rand, float min, float max) {
        ImplImageMiscOps.fillUniform(img, rand, min, max);
    }

    public static void fillGaussian(GrayF32 input, Random rand, double mean, double sigma, float lowerBound, float upperBound) {
        ImplImageMiscOps.fillGaussian(input, rand, mean, sigma, lowerBound, upperBound);
    }

    public static void fillGaussian(InterleavedF32 input, Random rand, double mean, double sigma, float lowerBound, float upperBound) {
        ImplImageMiscOps.fillGaussian(input, rand, mean, sigma, lowerBound, upperBound);
    }

    public static void flipVertical(GrayF32 image) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.flipVertical(image);
        } else {
            ImplImageMiscOps.flipVertical(image);
        }
    }

    public static void flipHorizontal(GrayF32 image) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.flipHorizontal(image);
        } else {
            ImplImageMiscOps.flipHorizontal(image);
        }
    }

    public static <T extends GrayF32> T transpose(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        ImplImageMiscOps.transpose(input, output);
        return output;
    }

    public static void rotateCW(GrayF32 image) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.rotateCW(image);
        } else {
            ImplImageMiscOps.rotateCW(image);
        }
    }

    public static <T extends InterleavedF32> T transpose(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.transpose(input, output);
        } else {
            ImplImageMiscOps.transpose(input, output);
        }
        return output;
    }

    public static <T extends GrayF32> T rotateCW(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.rotateCW(input, output);
        } else {
            ImplImageMiscOps.rotateCW(input, output);
        }
        return output;
    }

    public static <T extends InterleavedF32> T rotateCW(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.rotateCW(input, output);
        } else {
            ImplImageMiscOps.rotateCW(input, output);
        }
        return output;
    }

    public static void rotateCCW(GrayF32 image) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.rotateCCW(image);
        } else {
            ImplImageMiscOps.rotateCCW(image);
        }
    }

    public static <T extends GrayF32> T rotateCCW(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.rotateCCW(input, output);
        } else {
            ImplImageMiscOps.rotateCCW(input, output);
        }
        return output;
    }

    public static <T extends InterleavedF32> T rotateCCW(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.rotateCCW(input, output);
        } else {
            ImplImageMiscOps.rotateCCW(input, output);
        }
        return output;
    }

    public static void growBorder(GrayF32 src, ImageBorder_F32 border, int borderX0, int borderY0, int borderX1, int borderY1, GrayF32 dst) {
        if (ImageMiscOps.runConcurrent(src)) {
            ImplImageMiscOps_MT.growBorder(src, border, borderX0, borderY0, borderX1, borderY1, dst);
        } else {
            ImplImageMiscOps.growBorder(src, border, borderX0, borderY0, borderX1, borderY1, dst);
        }
    }

    public static void findAndProcess(GrayF32 input, BoofLambdas.Match_F32 finder, BoofLambdas.ProcessIIB process) {
        ImplImageMiscOps.findAndProcess(input, finder, process);
    }

    public static void copy(int srcX, int srcY, int dstX, int dstY, int width, int height, GrayF64 input, ImageBorder_F64 border, GrayF64 output) {
        ImplImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, input, border, output);
    }

    public static void copy(int srcX, int srcY, int dstX, int dstY, int width, int height, GrayF64 input, GrayF64 output) {
        ImplImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, input, output);
    }

    public static void copy(int srcX, int srcY, int dstX, int dstY, int width, int height, InterleavedF64 input, InterleavedF64 output) {
        ImplImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, input, output);
    }

    public static void fill(GrayF64 image, double value) {
        ImplImageMiscOps.fill(image, value);
    }

    public static void fill(InterleavedF64 image, double value) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.fill(image, value);
        } else {
            ImplImageMiscOps.fill(image, value);
        }
    }

    public static void fill(InterleavedF64 image, double[] values) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.fill(image, values);
        } else {
            ImplImageMiscOps.fill(image, values);
        }
    }

    public static void fillBand(InterleavedF64 image, int band, double value) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.fillBand(image, band, value);
        } else {
            ImplImageMiscOps.fillBand(image, band, value);
        }
    }

    public static void insertBand(GrayF64 input, int band, InterleavedF64 output) {
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.insertBand(input, band, output);
        } else {
            ImplImageMiscOps.insertBand(input, band, output);
        }
    }

    public static void extractBand(InterleavedF64 input, int band, GrayF64 output) {
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.extractBand(input, band, output);
        } else {
            ImplImageMiscOps.extractBand(input, band, output);
        }
    }

    public static void fillBorder(GrayF64 image, double value, int radius) {
        ImplImageMiscOps.fillBorder(image, value, radius);
    }

    public static void fillBorder(GrayF64 image, double value, int borderX0, int borderY0, int borderX1, int borderY1) {
        ImplImageMiscOps.fillBorder(image, value, borderX0, borderY0, borderX1, borderY1);
    }

    public static void fillRectangle(GrayF64 image, double value, int x0, int y0, int width, int height) {
        ImplImageMiscOps.fillRectangle(image, value, x0, y0, width, height);
    }

    public static void fillRectangle(InterleavedF64 image, double value, int x0, int y0, int width, int height) {
        ImplImageMiscOps.fillRectangle(image, value, x0, y0, width, height);
    }

    public static void fillUniform(GrayF64 img, Random rand, double min, double max) {
        ImplImageMiscOps.fillUniform(img, rand, min, max);
    }

    public static void fillUniform(InterleavedF64 img, Random rand, double min, double max) {
        ImplImageMiscOps.fillUniform(img, rand, min, max);
    }

    public static void fillGaussian(GrayF64 input, Random rand, double mean, double sigma, double lowerBound, double upperBound) {
        ImplImageMiscOps.fillGaussian(input, rand, mean, sigma, lowerBound, upperBound);
    }

    public static void fillGaussian(InterleavedF64 input, Random rand, double mean, double sigma, double lowerBound, double upperBound) {
        ImplImageMiscOps.fillGaussian(input, rand, mean, sigma, lowerBound, upperBound);
    }

    public static void flipVertical(GrayF64 image) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.flipVertical(image);
        } else {
            ImplImageMiscOps.flipVertical(image);
        }
    }

    public static void flipHorizontal(GrayF64 image) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.flipHorizontal(image);
        } else {
            ImplImageMiscOps.flipHorizontal(image);
        }
    }

    public static <T extends GrayF64> T transpose(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        ImplImageMiscOps.transpose(input, output);
        return output;
    }

    public static void rotateCW(GrayF64 image) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.rotateCW(image);
        } else {
            ImplImageMiscOps.rotateCW(image);
        }
    }

    public static <T extends InterleavedF64> T transpose(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.transpose(input, output);
        } else {
            ImplImageMiscOps.transpose(input, output);
        }
        return output;
    }

    public static <T extends GrayF64> T rotateCW(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.rotateCW(input, output);
        } else {
            ImplImageMiscOps.rotateCW(input, output);
        }
        return output;
    }

    public static <T extends InterleavedF64> T rotateCW(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.rotateCW(input, output);
        } else {
            ImplImageMiscOps.rotateCW(input, output);
        }
        return output;
    }

    public static void rotateCCW(GrayF64 image) {
        if (ImageMiscOps.runConcurrent(image)) {
            ImplImageMiscOps_MT.rotateCCW(image);
        } else {
            ImplImageMiscOps.rotateCCW(image);
        }
    }

    public static <T extends GrayF64> T rotateCCW(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.rotateCCW(input, output);
        } else {
            ImplImageMiscOps.rotateCCW(input, output);
        }
        return output;
    }

    public static <T extends InterleavedF64> T rotateCCW(T input, @Nullable T output) {
        output = InputSanityCheck.declareOutput(input, output);
        if (ImageMiscOps.runConcurrent(input)) {
            ImplImageMiscOps_MT.rotateCCW(input, output);
        } else {
            ImplImageMiscOps.rotateCCW(input, output);
        }
        return output;
    }

    public static void growBorder(GrayF64 src, ImageBorder_F64 border, int borderX0, int borderY0, int borderX1, int borderY1, GrayF64 dst) {
        if (ImageMiscOps.runConcurrent(src)) {
            ImplImageMiscOps_MT.growBorder(src, border, borderX0, borderY0, borderX1, borderY1, dst);
        } else {
            ImplImageMiscOps.growBorder(src, border, borderX0, borderY0, borderX1, borderY1, dst);
        }
    }

    public static void findAndProcess(GrayF64 input, BoofLambdas.Match_F64 finder, BoofLambdas.ProcessIIB process) {
        ImplImageMiscOps.findAndProcess(input, finder, process);
    }

    public static void addUniform(GrayU8 input, Random rand, int min, int max) {
        ImplImageMiscOps.addUniform(input, rand, min, max);
    }

    public static void addUniform(InterleavedU8 input, Random rand, int min, int max) {
        ImplImageMiscOps.addUniform(input, rand, min, max);
    }

    public static void addGaussian(GrayU8 image, Random rand, double sigma, int lowerBound, int upperBound) {
        ImplImageMiscOps.addGaussian(image, rand, sigma, lowerBound, upperBound);
    }

    public static void addGaussian(InterleavedU8 image, Random rand, double sigma, int lowerBound, int upperBound) {
        ImplImageMiscOps.addGaussian(image, rand, sigma, lowerBound, upperBound);
    }

    public static void addUniform(GrayS8 input, Random rand, int min, int max) {
        ImplImageMiscOps.addUniform(input, rand, min, max);
    }

    public static void addUniform(InterleavedS8 input, Random rand, int min, int max) {
        ImplImageMiscOps.addUniform(input, rand, min, max);
    }

    public static void addGaussian(GrayS8 image, Random rand, double sigma, int lowerBound, int upperBound) {
        ImplImageMiscOps.addGaussian(image, rand, sigma, lowerBound, upperBound);
    }

    public static void addGaussian(InterleavedS8 image, Random rand, double sigma, int lowerBound, int upperBound) {
        ImplImageMiscOps.addGaussian(image, rand, sigma, lowerBound, upperBound);
    }

    public static void addUniform(GrayU16 input, Random rand, int min, int max) {
        ImplImageMiscOps.addUniform(input, rand, min, max);
    }

    public static void addUniform(InterleavedU16 input, Random rand, int min, int max) {
        ImplImageMiscOps.addUniform(input, rand, min, max);
    }

    public static void addGaussian(GrayU16 image, Random rand, double sigma, int lowerBound, int upperBound) {
        ImplImageMiscOps.addGaussian(image, rand, sigma, lowerBound, upperBound);
    }

    public static void addGaussian(InterleavedU16 image, Random rand, double sigma, int lowerBound, int upperBound) {
        ImplImageMiscOps.addGaussian(image, rand, sigma, lowerBound, upperBound);
    }

    public static void addUniform(GrayS16 input, Random rand, int min, int max) {
        ImplImageMiscOps.addUniform(input, rand, min, max);
    }

    public static void addUniform(InterleavedS16 input, Random rand, int min, int max) {
        ImplImageMiscOps.addUniform(input, rand, min, max);
    }

    public static void addGaussian(GrayS16 image, Random rand, double sigma, int lowerBound, int upperBound) {
        ImplImageMiscOps.addGaussian(image, rand, sigma, lowerBound, upperBound);
    }

    public static void addGaussian(InterleavedS16 image, Random rand, double sigma, int lowerBound, int upperBound) {
        ImplImageMiscOps.addGaussian(image, rand, sigma, lowerBound, upperBound);
    }

    public static void addUniform(GrayS32 input, Random rand, int min, int max) {
        ImplImageMiscOps.addUniform(input, rand, min, max);
    }

    public static void addUniform(InterleavedS32 input, Random rand, int min, int max) {
        ImplImageMiscOps.addUniform(input, rand, min, max);
    }

    public static void addGaussian(GrayS32 image, Random rand, double sigma, int lowerBound, int upperBound) {
        ImplImageMiscOps.addGaussian(image, rand, sigma, lowerBound, upperBound);
    }

    public static void addGaussian(InterleavedS32 image, Random rand, double sigma, int lowerBound, int upperBound) {
        ImplImageMiscOps.addGaussian(image, rand, sigma, lowerBound, upperBound);
    }

    public static void addUniform(GrayS64 input, Random rand, long min, long max) {
        ImplImageMiscOps.addUniform(input, rand, min, max);
    }

    public static void addUniform(InterleavedS64 input, Random rand, long min, long max) {
        ImplImageMiscOps.addUniform(input, rand, min, max);
    }

    public static void addGaussian(GrayS64 image, Random rand, double sigma, long lowerBound, long upperBound) {
        ImplImageMiscOps.addGaussian(image, rand, sigma, lowerBound, upperBound);
    }

    public static void addGaussian(InterleavedS64 image, Random rand, double sigma, long lowerBound, long upperBound) {
        ImplImageMiscOps.addGaussian(image, rand, sigma, lowerBound, upperBound);
    }

    public static void addUniform(GrayF32 input, Random rand, float min, float max) {
        ImplImageMiscOps.addUniform(input, rand, min, max);
    }

    public static void addUniform(InterleavedF32 input, Random rand, float min, float max) {
        ImplImageMiscOps.addUniform(input, rand, min, max);
    }

    public static void addGaussian(GrayF32 image, Random rand, double sigma, float lowerBound, float upperBound) {
        ImplImageMiscOps.addGaussian(image, rand, sigma, lowerBound, upperBound);
    }

    public static void addGaussian(InterleavedF32 image, Random rand, double sigma, float lowerBound, float upperBound) {
        ImplImageMiscOps.addGaussian(image, rand, sigma, lowerBound, upperBound);
    }

    public static void addUniform(GrayF64 input, Random rand, double min, double max) {
        ImplImageMiscOps.addUniform(input, rand, min, max);
    }

    public static void addUniform(InterleavedF64 input, Random rand, double min, double max) {
        ImplImageMiscOps.addUniform(input, rand, min, max);
    }

    public static void addGaussian(GrayF64 image, Random rand, double sigma, double lowerBound, double upperBound) {
        ImplImageMiscOps.addGaussian(image, rand, sigma, lowerBound, upperBound);
    }

    public static void addGaussian(InterleavedF64 image, Random rand, double sigma, double lowerBound, double upperBound) {
        ImplImageMiscOps.addGaussian(image, rand, sigma, lowerBound, upperBound);
    }
}

