/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.selfcalib;

import boofcv.misc.BoofMiscOps;
import boofcv.misc.ConfigConverge;
import georegression.struct.point.Point3D_F64;
import java.io.PrintStream;
import java.util.Set;
import org.ddogleg.optimization.FactoryOptimization;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.derivative.NumericalJacobianForward_DDRM;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F64;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.VerbosePrint;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.NormOps_DDRM;
import org.jetbrains.annotations.Nullable;

public class RefineDualQuadraticAlgebraicError
implements VerbosePrint {
    public UnconstrainedLeastSquares<DMatrixRMaj> minimizer = FactoryOptimization.levenbergMarquardt(null, false);
    public boolean knownAspect = false;
    public boolean knownPrinciplePoint = false;
    public final ConfigConverge converge = new ConfigConverge(1.0E-12, 1.0E-8, 20);
    public final Point3D_F64 planeAtInfinity = new Point3D_F64();
    public final DogArray<CameraState> cameras = new DogArray<CameraState>(CameraState::new, CameraState::reset);
    DogArray<CameraState> priorCameras = new DogArray<CameraState>(CameraState::new, CameraState::reset);
    Point3D_F64 priorPlaneAtInfinity = new Point3D_F64();
    DogArray_I32 viewToCamera = new DogArray_I32();
    DogArray<DMatrixRMaj> projectiveCameras = new DogArray<DMatrixRMaj>(() -> new DMatrixRMaj(3, 4), DMatrixRMaj::zero);
    ResidualFunction function = new ResidualFunction();
    DogArray_F64 parameters = new DogArray_F64();
    DMatrixRMaj w = new DMatrixRMaj(3, 3);
    DMatrixRMaj p = new DMatrixRMaj(3, 1);
    DMatrixRMaj pw = new DMatrixRMaj(3, 1);
    @Nullable
    PrintStream verbose;

    public void initialize(int numCameras, int numViews) {
        BoofMiscOps.checkTrue(numCameras >= 1 && numCameras <= numViews);
        BoofMiscOps.checkTrue(numViews >= 2);
        this.priorCameras.resetResize(numCameras);
        this.cameras.resetResize(numCameras);
        this.projectiveCameras.resetResize(numViews);
        this.viewToCamera.resetResize(numViews, -1);
    }

    public void setCamera(int cameraIndex, double fx, double cx, double cy, double aspectRatio) {
        ((CameraState)this.priorCameras.get(cameraIndex)).setTo(fx, aspectRatio, cx, cy);
    }

    public void setViewToCamera(int viewIndex, int cameraIndex) {
        this.viewToCamera.set(viewIndex, cameraIndex);
    }

    public void setProjective(int cameraIndex, DMatrixRMaj P) {
        BoofMiscOps.checkEq(3, P.numRows);
        BoofMiscOps.checkEq(4, P.numCols);
        ((DMatrixRMaj)this.projectiveCameras.get(cameraIndex)).setTo(P);
    }

    public void setPlaneAtInfinity(double x, double y, double z) {
        this.priorPlaneAtInfinity.setTo(x, y, z);
    }

    public boolean refine() {
        int iterations;
        BoofMiscOps.checkTrue(this.viewToCamera.get(0) != -1, "You must specify view to camera");
        for (int cameraIdx = 0; cameraIdx < this.priorCameras.size; ++cameraIdx) {
            ((CameraState)this.cameras.get(cameraIdx)).setTo((CameraState)this.priorCameras.get(cameraIdx));
        }
        this.parameters.resize(this.function.getNumOfInputsN());
        this.encodeParameters(this.priorPlaneAtInfinity, this.priorCameras, this.parameters.data);
        this.minimizer.setFunction(this.function, new NumericalJacobianForward_DDRM(new ResidualFunction()));
        this.minimizer.initialize(this.parameters.data, this.converge.ftol, this.converge.gtol);
        double errorBefore = this.minimizer.getFunctionValue();
        for (iterations = 0; iterations < this.converge.maxIterations && !this.minimizer.iterate(); ++iterations) {
        }
        if (this.verbose != null) {
            this.verbose.printf("before=%.2e after=%.2e iterations=%d converged=%s\n", errorBefore, this.minimizer.getFunctionValue(), iterations, this.minimizer.isConverged());
        }
        this.decodeParameters(this.minimizer.getParameters(), this.cameras, this.planeAtInfinity);
        for (int i = 0; i < this.cameras.size; ++i) {
            CameraState c = (CameraState)this.cameras.get(i);
            if (!(c.fx <= 0.0) && !(c.aspectRatio <= 0.0)) continue;
            return false;
        }
        return true;
    }

    protected void encodeParameters(Point3D_F64 planeAtInfinity, DogArray<CameraState> cameras, double[] parameters) {
        parameters[0] = planeAtInfinity.x;
        parameters[1] = planeAtInfinity.y;
        parameters[2] = planeAtInfinity.z;
        int paramIndex = 3;
        for (int cameraIdx = 0; cameraIdx < cameras.size; ++cameraIdx) {
            CameraState work = (CameraState)cameras.get(cameraIdx);
            parameters[paramIndex++] = work.fx;
            if (!this.knownAspect) {
                parameters[paramIndex++] = work.aspectRatio;
            }
            if (this.knownPrinciplePoint) continue;
            parameters[paramIndex++] = work.cx;
            parameters[paramIndex++] = work.cy;
        }
    }

    protected void decodeParameters(double[] parameters, DogArray<CameraState> cameras, Point3D_F64 planeAtInfinity) {
        planeAtInfinity.setTo(parameters[0], parameters[1], parameters[2]);
        int paramIndex = 3;
        for (int cameraIdx = 0; cameraIdx < cameras.size; ++cameraIdx) {
            CameraState work = (CameraState)cameras.get(cameraIdx);
            work.fx = parameters[paramIndex++];
            if (!this.knownAspect) {
                work.aspectRatio = parameters[paramIndex++];
            }
            if (this.knownPrinciplePoint) continue;
            work.cx = parameters[paramIndex++];
            work.cy = parameters[paramIndex++];
        }
    }

    protected void encodeKK(CameraState camera, DMatrixRMaj kk) {
        double fx = camera.fx;
        double fy = camera.aspectRatio * fx;
        double cx = camera.cx;
        double cy = camera.cy;
        kk.data[0] = fx * fx + cx * cx;
        kk.data[1] = cx * cy;
        kk.data[2] = cx;
        kk.data[3] = kk.data[1];
        kk.data[4] = fy * fy + cy * cy;
        kk.data[5] = cy;
        kk.data[6] = kk.data[2];
        kk.data[7] = kk.data[5];
        kk.data[8] = 1.0;
    }

    protected void encodeQ(CameraState camera, double infx, double infy, double infz, DMatrixRMaj Q) {
        this.p.data[0] = infx;
        this.p.data[1] = infy;
        this.p.data[2] = infz;
        this.encodeKK(camera, this.w);
        CommonOps_DDRM.insert(this.w, Q, 0, 0);
        CommonOps_DDRM.multTransA(this.p, this.w, this.pw);
        double dot = CommonOps_DDRM.dot(this.pw, this.p);
        for (int i = 0; i < 3; ++i) {
            Q.unsafe_set(i, 3, -this.pw.get(i));
            Q.unsafe_set(3, i, -this.pw.get(i));
        }
        Q.unsafe_set(3, 3, dot);
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix(this, out);
    }

    public UnconstrainedLeastSquares<DMatrixRMaj> getMinimizer() {
        return this.minimizer;
    }

    public void setMinimizer(UnconstrainedLeastSquares<DMatrixRMaj> minimizer) {
        this.minimizer = minimizer;
    }

    public boolean isKnownAspect() {
        return this.knownAspect;
    }

    public void setKnownAspect(boolean knownAspect) {
        this.knownAspect = knownAspect;
    }

    public boolean isKnownPrinciplePoint() {
        return this.knownPrinciplePoint;
    }

    public void setKnownPrinciplePoint(boolean knownPrinciplePoint) {
        this.knownPrinciplePoint = knownPrinciplePoint;
    }

    public ConfigConverge getConverge() {
        return this.converge;
    }

    public Point3D_F64 getPlaneAtInfinity() {
        return this.planeAtInfinity;
    }

    public DogArray<CameraState> getCameras() {
        return this.cameras;
    }

    private class ResidualFunction
    implements FunctionNtoM {
        DMatrixRMaj Q = new DMatrixRMaj(4, 4);
        DMatrixRMaj KK = new DMatrixRMaj(3, 3);
        DMatrixRMaj PQ = new DMatrixRMaj(3, 4);
        DMatrixRMaj PQP = new DMatrixRMaj(3, 3);

        private ResidualFunction() {
        }

        @Override
        public void process(double[] input, double[] output) {
            RefineDualQuadraticAlgebraicError.this.decodeParameters(input, RefineDualQuadraticAlgebraicError.this.cameras, RefineDualQuadraticAlgebraicError.this.planeAtInfinity);
            RefineDualQuadraticAlgebraicError.this.encodeQ((CameraState)RefineDualQuadraticAlgebraicError.this.cameras.get(RefineDualQuadraticAlgebraicError.this.viewToCamera.get(0)), RefineDualQuadraticAlgebraicError.this.planeAtInfinity.x, RefineDualQuadraticAlgebraicError.this.planeAtInfinity.y, RefineDualQuadraticAlgebraicError.this.planeAtInfinity.z, this.Q);
            int indexOutput = 0;
            for (int projectiveIdx = 0; projectiveIdx < RefineDualQuadraticAlgebraicError.this.projectiveCameras.size; ++projectiveIdx) {
                int cameraIndex = RefineDualQuadraticAlgebraicError.this.viewToCamera.get(projectiveIdx);
                RefineDualQuadraticAlgebraicError.this.encodeKK((CameraState)RefineDualQuadraticAlgebraicError.this.cameras.get(cameraIndex), this.KK);
                DMatrixRMaj P = (DMatrixRMaj)RefineDualQuadraticAlgebraicError.this.projectiveCameras.get(projectiveIdx);
                CommonOps_DDRM.mult(P, this.Q, this.PQ);
                CommonOps_DDRM.multTransB(this.PQ, P, this.PQP);
                CommonOps_DDRM.divide(this.PQP, NormOps_DDRM.normPInf(this.PQP));
                CommonOps_DDRM.divide(this.KK, NormOps_DDRM.normPInf(this.KK));
                output[indexOutput++] = this.KK.data[0] - this.PQP.data[0];
                output[indexOutput++] = 2.0 * (this.KK.data[1] - this.PQP.data[1]);
                output[indexOutput++] = 2.0 * (this.KK.data[2] - this.PQP.data[2]);
                output[indexOutput++] = this.KK.data[4] - this.PQP.data[4];
                output[indexOutput++] = 2.0 * (this.KK.data[5] - this.PQP.data[5]);
                output[indexOutput++] = this.KK.data[8] - this.PQP.data[8];
            }
        }

        @Override
        public int getNumOfInputsN() {
            int paramsPerCamera = 1;
            if (!RefineDualQuadraticAlgebraicError.this.knownAspect) {
                ++paramsPerCamera;
            }
            if (!RefineDualQuadraticAlgebraicError.this.knownPrinciplePoint) {
                paramsPerCamera += 2;
            }
            return 3 + paramsPerCamera * RefineDualQuadraticAlgebraicError.this.priorCameras.size;
        }

        @Override
        public int getNumOfOutputsM() {
            return 6 * RefineDualQuadraticAlgebraicError.this.projectiveCameras.size;
        }
    }

    public static class CameraState {
        public double fx;
        public double aspectRatio;
        public double cx;
        public double cy;

        public void reset() {
            this.fx = 0.0;
            this.aspectRatio = 1.0;
            this.cy = 0.0;
            this.cx = 0.0;
        }

        public void setTo(double fx, double aspectRatio, double cx, double cy) {
            this.fx = fx;
            this.aspectRatio = aspectRatio;
            this.cx = cx;
            this.cy = cy;
        }

        public void setTo(CameraState src) {
            this.fx = src.fx;
            this.aspectRatio = src.aspectRatio;
            this.cx = src.cx;
            this.cy = src.cy;
        }
    }
}

