/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.robust;

import boofcv.alg.geo.robust.DistanceFromModelViews;
import boofcv.alg.geo.robust.ModelGeneratorViews;
import boofcv.alg.geo.robust.ModelMatcherViews;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.ElevateViewInfo;
import org.ddogleg.fitting.modelset.ModelManager;
import org.ddogleg.fitting.modelset.ransac.Ransac;

public class RansacProjective<Model, Point>
extends Ransac<Model, Point>
implements ModelMatcherViews<Model, Point, ElevateViewInfo> {
    private final DistanceFromModelViews<Model, Point, ElevateViewInfo> modelDistance;
    private final ModelGeneratorViews<Model, Point, ElevateViewInfo> modelGenerator;

    public RansacProjective(long randSeed, ModelManager<Model> modelManager, ModelGeneratorViews<Model, Point, ElevateViewInfo> modelGenerator, DistanceFromModelViews<Model, Point, ElevateViewInfo> modelDistance, int maxIterations, double thresholdFit) {
        super(randSeed, maxIterations, thresholdFit, modelManager, modelDistance.getPointType());
        this.setModel(() -> modelGenerator, () -> modelDistance);
        this.modelDistance = modelDistance;
        this.modelGenerator = modelGenerator;
        BoofMiscOps.checkTrue(modelDistance.getNumberOfViews() == modelGenerator.getNumberOfViews());
    }

    @Override
    public void setView(int view, ElevateViewInfo info) {
        this.modelDistance.setView(view, info);
        this.modelGenerator.setView(view, info);
    }

    @Override
    public int getNumberOfViews() {
        return this.modelDistance.getNumberOfViews();
    }
}

