/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.pose;

import boofcv.alg.geo.DistanceFromModelMultiView;
import boofcv.alg.geo.NormalizedToPixelError;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.sfm.Stereo2D3D;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.List;

public class PnPStereoDistanceReprojectionSq
implements DistanceFromModelMultiView<Se3_F64, Stereo2D3D> {
    private Se3_F64 worldToLeft;
    private final Point3D_F64 X = new Point3D_F64();
    private Se3_F64 leftToRight = new Se3_F64();
    private NormalizedToPixelError leftPixelError = new NormalizedToPixelError();
    private NormalizedToPixelError rightPixelError = new NormalizedToPixelError();

    public PnPStereoDistanceReprojectionSq(NormalizedToPixelError leftPixelError, NormalizedToPixelError rightPixelError, Se3_F64 leftToRight) {
        this.leftPixelError = leftPixelError;
        this.rightPixelError = rightPixelError;
        this.leftToRight = leftToRight;
    }

    public PnPStereoDistanceReprojectionSq() {
    }

    public void setLeftToRight(Se3_F64 leftToRight) {
        this.leftToRight.setTo(leftToRight);
    }

    @Override
    public void setModel(Se3_F64 worldToLeft) {
        this.worldToLeft = worldToLeft;
    }

    @Override
    public double distance(Stereo2D3D pt) {
        SePointOps_F64.transform(this.worldToLeft, pt.location, this.X);
        if (this.X.z <= 0.0) {
            return Double.MAX_VALUE;
        }
        Point2D_F64 p = pt.leftObs;
        double errorLeft = this.leftPixelError.errorSq(this.X.x / this.X.z, this.X.y / this.X.z, p.x, p.y);
        SePointOps_F64.transform(this.leftToRight, this.X, this.X);
        if (this.X.z <= 0.0) {
            return Double.MAX_VALUE;
        }
        p = pt.rightObs;
        double errorRight = this.rightPixelError.errorSq(this.X.x / this.X.z, this.X.y / this.X.z, p.x, p.y);
        return errorLeft + errorRight;
    }

    @Override
    public void distances(List<Stereo2D3D> observations, double[] distance) {
        for (int i = 0; i < observations.size(); ++i) {
            distance[i] = this.distance(observations.get(i));
        }
    }

    @Override
    public Class<Stereo2D3D> getPointType() {
        return Stereo2D3D.class;
    }

    @Override
    public Class<Se3_F64> getModelType() {
        return Se3_F64.class;
    }

    @Override
    public void setIntrinsic(int view, CameraPinhole intrinsic) {
        if (view == 0) {
            this.leftPixelError.setTo(intrinsic.fx, intrinsic.fy, intrinsic.skew);
        } else if (view == 1) {
            this.rightPixelError.setTo(intrinsic.fx, intrinsic.fy, intrinsic.skew);
        } else {
            throw new IllegalArgumentException("View must be 0 or 1");
        }
    }

    @Override
    public int getNumberOfViews() {
        return 2;
    }

    public void setStereoParameters(StereoParameters param) {
        param.right_to_left.invert(this.leftToRight);
        this.setIntrinsic(0, param.left);
        this.setIntrinsic(1, param.right);
    }

    public DistanceFromModelMultiView<Se3_F64, Stereo2D3D> newConcurrentChild() {
        return new PnPStereoDistanceReprojectionSq(this.leftPixelError, this.rightPixelError, this.leftToRight);
    }
}

