/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.f;

import boofcv.struct.geo.AssociatedPair;
import georegression.geometry.GeometryMath_F64;
import java.util.List;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class DistanceEpipolarConstraint
implements DistanceFromModel<DMatrixRMaj, AssociatedPair> {
    DMatrixRMaj M = new DMatrixRMaj(3, 3);

    @Override
    public void setModel(DMatrixRMaj F) {
        double v = CommonOps_DDRM.elementMaxAbs(F);
        CommonOps_DDRM.scale(1.0 / v, F, this.M);
    }

    @Override
    public double distance(AssociatedPair pt) {
        return Math.abs(GeometryMath_F64.innerProd(pt.p2, this.M, pt.p1));
    }

    @Override
    public void distances(List<AssociatedPair> associatedPairs, double[] distance) {
        for (int i = 0; i < associatedPairs.size(); ++i) {
            distance[i] = this.distance(associatedPairs.get(i));
        }
    }

    @Override
    public Class<AssociatedPair> getPointType() {
        return AssociatedPair.class;
    }

    @Override
    public Class<DMatrixRMaj> getModelType() {
        return DMatrixRMaj.class;
    }
}

