/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration;

import boofcv.abst.geo.Estimate1ofEpipolar;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.struct.geo.AssociatedPair;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrixRMaj;

public class Zhang99ComputeTargetHomography {
    private final Estimate1ofEpipolar computeHomography = FactoryMultiView.homographyDLT(true);
    private final DMatrixRMaj found = new DMatrixRMaj(3, 3);
    List<Point2D_F64> worldPoints;

    public Zhang99ComputeTargetHomography(List<Point2D_F64> worldPoints) {
        this.worldPoints = worldPoints;
    }

    public boolean computeHomography(CalibrationObservation observedPoints) {
        if (observedPoints.size() < 4) {
            throw new IllegalArgumentException("At least 4 points needed in each set of observations.  Filter these first please");
        }
        ArrayList<AssociatedPair> pairs = new ArrayList<AssociatedPair>();
        for (int i = 0; i < observedPoints.size(); ++i) {
            int which = observedPoints.get((int)i).index;
            Point2D_F64 obs = (Point2D_F64)observedPoints.get((int)i).p;
            pairs.add(new AssociatedPair(this.worldPoints.get(which), obs, true));
        }
        return this.computeHomography.process(pairs, this.found);
    }

    public DMatrixRMaj getHomography() {
        return this.found.copy();
    }
}

