/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration;

import boofcv.abst.geo.bundle.BundleAdjustment;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.abst.geo.calibration.ImageResults;
import boofcv.alg.geo.bundle.BundleAdjustmentMetricResidualFunction;
import boofcv.alg.geo.bundle.CodecSceneStructureMetric;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.alg.geo.calibration.Zhang99CalibrationMatrixFromHomographies;
import boofcv.alg.geo.calibration.Zhang99ComputeTargetHomography;
import boofcv.alg.geo.calibration.Zhang99DecomposeHomography;
import boofcv.alg.geo.calibration.cameras.Zhang99Camera;
import boofcv.factory.geo.ConfigBundleAdjustment;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraModel;
import boofcv.struct.geo.PointIndex2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se3_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.ddogleg.optimization.lm.ConfigLevenbergMarquardt;
import org.ddogleg.struct.VerbosePrint;
import org.ejml.data.DMatrixRMaj;
import org.jetbrains.annotations.Nullable;

public class CalibrationPlanarGridZhang99
implements VerbosePrint {
    Zhang99Camera cameraGenerator;
    public boolean zeroSkew = true;
    private final Zhang99ComputeTargetHomography computeHomography;
    private final Zhang99CalibrationMatrixFromHomographies computeK;
    private final Zhang99DecomposeHomography decomposeH = new Zhang99DecomposeHomography();
    public SceneStructureMetric structure;
    public SceneObservations observations;
    private Listener listener;
    private final List<Point2D_F64> layout;
    private boolean robust = false;
    @Nullable
    private PrintStream verbose = null;

    public CalibrationPlanarGridZhang99(List<Point2D_F64> layout, Zhang99Camera cameraGenerator) {
        this.cameraGenerator = cameraGenerator;
        this.layout = layout;
        this.computeHomography = new Zhang99ComputeTargetHomography(layout);
        this.computeK = new Zhang99CalibrationMatrixFromHomographies();
    }

    public boolean process(List<CalibrationObservation> observations) {
        this.computeK.setAssumeZeroSkew(this.zeroSkew);
        if (!this.linearEstimate(observations)) {
            return false;
        }
        this.status("Non-linear refinement");
        return this.performBundleAdjustment();
    }

    protected boolean linearEstimate(List<CalibrationObservation> observations) {
        DMatrixRMaj H;
        this.status("Estimating Homographies");
        ArrayList<DMatrixRMaj> homographies = new ArrayList<DMatrixRMaj>();
        ArrayList<Se3_F64> motions = new ArrayList<Se3_F64>();
        for (int i = 0; i < observations.size(); ++i) {
            CalibrationObservation obs = observations.get(i);
            if (!this.computeHomography.computeHomography(obs)) {
                return false;
            }
            H = this.computeHomography.getHomography();
            homographies.add(H);
        }
        this.status("Estimating Calibration Matrix");
        this.computeK.process(homographies);
        DMatrixRMaj K = this.computeK.getCalibrationMatrix();
        this.decomposeH.setCalibrationMatrix(K);
        for (int i = 0; i < homographies.size(); ++i) {
            H = (DMatrixRMaj)homographies.get(i);
            motions.add(this.decomposeH.decompose(H));
        }
        this.status("Initial Model Parameters");
        this.convertIntoBundleStructure(motions, K, homographies, observations);
        return true;
    }

    private void status(String message) {
        if (this.listener != null && !this.listener.zhangUpdate(message)) {
            throw new RuntimeException("User requested termination of calibration");
        }
    }

    public boolean performBundleAdjustment() {
        BundleAdjustment<SceneStructureMetric> bundleAdjustment;
        ConfigLevenbergMarquardt configLM = new ConfigLevenbergMarquardt();
        configLM.hessianScaling = false;
        ConfigBundleAdjustment configSBA = new ConfigBundleAdjustment();
        configSBA.configOptimizer = configLM;
        if (this.robust) {
            configLM.mixture = 0.0;
            bundleAdjustment = FactoryMultiView.bundleDenseMetric(true, configSBA);
        } else {
            bundleAdjustment = FactoryMultiView.bundleSparseMetric(configSBA);
        }
        bundleAdjustment.setVerbose(this.verbose, null);
        bundleAdjustment.configure(1.0E-20, 1.0E-20, 200);
        bundleAdjustment.setParameters(this.structure, this.observations);
        return bundleAdjustment.optimize(this.structure);
    }

    public void convertIntoBundleStructure(List<Se3_F64> motions, DMatrixRMaj K, List<DMatrixRMaj> homographies, List<CalibrationObservation> calibrationObservations) {
        this.structure = new SceneStructureMetric(false);
        this.structure.initialize(1, motions.size(), -1, this.layout.size(), 1);
        this.observations = new SceneObservations();
        this.observations.initialize(motions.size(), true);
        this.structure.setCamera(0, false, this.cameraGenerator.initializeCamera(K, homographies, calibrationObservations));
        this.structure.setRigid(0, true, new Se3_F64(), this.layout.size());
        SceneStructureMetric.Rigid rigid = ((SceneStructureMetric.Rigid[])this.structure.rigids.data)[0];
        for (int i = 0; i < this.layout.size(); ++i) {
            rigid.setPoint(i, this.layout.get((int)i).x, this.layout.get((int)i).y, 0.0);
        }
        for (int viewIdx = 0; viewIdx < motions.size(); ++viewIdx) {
            this.structure.setView(viewIdx, 0, false, motions.get(viewIdx));
            SceneObservations.View v = this.observations.getViewRigid(viewIdx);
            CalibrationObservation ca = calibrationObservations.get(viewIdx);
            for (int j = 0; j < ca.size(); ++j) {
                PointIndex2D_F64 p = ca.get(j);
                v.add(p.index, (float)((Point2D_F64)p.p).x, (float)((Point2D_F64)p.p).y);
                this.structure.connectPointToView(p.index, viewIdx);
            }
        }
    }

    public List<ImageResults> computeErrors() {
        ArrayList<ImageResults> errors = new ArrayList<ImageResults>();
        double[] parameters = new double[this.structure.getParameterCount()];
        double[] residuals = new double[this.observations.getObservationCount() * 2];
        CodecSceneStructureMetric codec = new CodecSceneStructureMetric();
        codec.encode(this.structure, parameters);
        BundleAdjustmentMetricResidualFunction function = new BundleAdjustmentMetricResidualFunction();
        function.configure(this.structure, this.observations);
        function.process(parameters, residuals);
        int idx = 0;
        for (int i = 0; i < this.observations.viewsRigid.size; ++i) {
            SceneObservations.View v = ((SceneObservations.View[])this.observations.viewsRigid.data)[i];
            ImageResults r = new ImageResults(v.size());
            double sumX = 0.0;
            double sumY = 0.0;
            double meanErrorMag = 0.0;
            double maxError = 0.0;
            for (int j = 0; j < v.size(); ++j) {
                double d = residuals[idx++];
                r.residuals[j * 2] = d;
                double x = d;
                double d2 = residuals[idx++];
                r.residuals[j * 2 + 1] = d2;
                double y = d2;
                double nerr = r.pointError[j] = Math.sqrt(x * x + y * y);
                meanErrorMag += nerr;
                maxError = Math.max(maxError, nerr);
                sumX += x;
                sumY += y;
            }
            r.biasX = sumX / (double)v.size();
            r.biasY = sumY / (double)v.size();
            r.meanError = meanErrorMag / (double)v.size();
            r.maxError = maxError;
            errors.add(r);
        }
        return errors;
    }

    public CameraModel getCameraModel() {
        return this.cameraGenerator.getCameraModel(((SceneStructureCommon.Camera)this.structure.cameras.get((int)0)).model);
    }

    public static void applyDistortion(Point2D_F64 normPt, double[] radial, double t1, double t2) {
        double r2;
        double x = normPt.x;
        double y = normPt.y;
        double a = 0.0;
        double r2i = r2 = x * x + y * y;
        for (int i = 0; i < radial.length; ++i) {
            a += radial[i] * r2i;
            r2i *= r2;
        }
        normPt.x = x + x * a + 2.0 * t1 * x * y + t2 * (r2 + 2.0 * x * x);
        normPt.y = y + y * a + t1 * (r2 + 2.0 * y * y) + 2.0 * t2 * x * y;
    }

    public static int totalPoints(List<CalibrationObservation> observations) {
        int total = 0;
        for (int i = 0; i < observations.size(); ++i) {
            total += observations.get(i).size();
        }
        return total;
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix(this, out);
    }

    public boolean isZeroSkew() {
        return this.zeroSkew;
    }

    public void setZeroSkew(boolean zeroSkew) {
        this.zeroSkew = zeroSkew;
    }

    public SceneStructureMetric getStructure() {
        return this.structure;
    }

    public Listener getListener() {
        return this.listener;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public boolean isRobust() {
        return this.robust;
    }

    public void setRobust(boolean robust) {
        this.robust = robust;
    }

    public static interface Listener {
        public boolean zhangUpdate(String var1);
    }
}

