/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative.impl;

import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;

public class GradientThree_Standard_MT {
    public static void process(GrayF32 orig, GrayF32 derivX, GrayF32 derivY) {
        float[] data = orig.data;
        float[] imgX = derivX.data;
        float[] imgY = derivY.data;
        int width = orig.getWidth();
        int height = orig.getHeight() - 1;
        int stride = orig.stride;
        BoofConcurrency.loopFor(1, height, y -> {
            int indexSrc;
            int indexX = derivX.startIndex + derivX.stride * y + 1;
            int indexY = derivY.startIndex + derivY.stride * y + 1;
            int endX = indexSrc + width - 2;
            for (indexSrc = orig.startIndex + stride * y + 1; indexSrc < endX; ++indexSrc) {
                imgX[indexX++] = (data[indexSrc + 1] - data[indexSrc - 1]) * 0.5f;
                imgY[indexY++] = (data[indexSrc + stride] - data[indexSrc - stride]) * 0.5f;
            }
        });
    }

    public static void process(GrayU8 orig, GrayS16 derivX, GrayS16 derivY) {
        byte[] data = orig.data;
        short[] imgX = derivX.data;
        short[] imgY = derivY.data;
        int width = orig.getWidth();
        int height = orig.getHeight() - 1;
        int stride = orig.stride;
        BoofConcurrency.loopFor(1, height, y -> {
            int indexSrc;
            int indexX = derivX.startIndex + derivX.stride * y + 1;
            int indexY = derivY.startIndex + derivY.stride * y + 1;
            int endX = indexSrc + width - 2;
            for (indexSrc = orig.startIndex + stride * y + 1; indexSrc < endX; ++indexSrc) {
                imgX[indexX++] = (short)((data[indexSrc + 1] & 0xFF) - (data[indexSrc - 1] & 0xFF));
                imgY[indexY++] = (short)((data[indexSrc + stride] & 0xFF) - (data[indexSrc - stride] & 0xFF));
            }
        });
    }

    public static void process(GrayU8 orig, GrayS32 derivX, GrayS32 derivY) {
        byte[] data = orig.data;
        int[] imgX = derivX.data;
        int[] imgY = derivY.data;
        int width = orig.getWidth();
        int height = orig.getHeight() - 1;
        int stride = orig.stride;
        BoofConcurrency.loopFor(1, height, y -> {
            int indexSrc;
            int indexX = derivX.startIndex + derivX.stride * y + 1;
            int indexY = derivY.startIndex + derivY.stride * y + 1;
            int endX = indexSrc + width - 2;
            for (indexSrc = orig.startIndex + stride * y + 1; indexSrc < endX; ++indexSrc) {
                imgX[indexX++] = (data[indexSrc + 1] & 0xFF) - (data[indexSrc - 1] & 0xFF);
                imgY[indexY++] = (data[indexSrc + stride] & 0xFF) - (data[indexSrc - stride] & 0xFF);
            }
        });
    }

    public static void process(GrayS16 orig, GrayS16 derivX, GrayS16 derivY) {
        short[] data = orig.data;
        short[] imgX = derivX.data;
        short[] imgY = derivY.data;
        int width = orig.getWidth();
        int height = orig.getHeight() - 1;
        int stride = orig.stride;
        BoofConcurrency.loopFor(1, height, y -> {
            int indexSrc;
            int indexX = derivX.startIndex + derivX.stride * y + 1;
            int indexY = derivY.startIndex + derivY.stride * y + 1;
            int endX = indexSrc + width - 2;
            for (indexSrc = orig.startIndex + stride * y + 1; indexSrc < endX; ++indexSrc) {
                imgX[indexX++] = (short)(data[indexSrc + 1] - data[indexSrc - 1]);
                imgY[indexY++] = (short)(data[indexSrc + stride] - data[indexSrc - stride]);
            }
        });
    }
}

