/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative;

import boofcv.alg.InputSanityCheck;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.Planar;

public class GradientReduceToSingle {
    public static void maxf(Planar<GrayF32> inX, Planar<GrayF32> inY, GrayF32 outX, GrayF32 outY) {
        InputSanityCheck.checkSameShape(inX, inY);
        InputSanityCheck.reshapeOneIn(inX, outX, outY);
        InputSanityCheck.checkIndexing(inX, inY);
        InputSanityCheck.checkIndexing(outX, outY);
        for (int y = 0; y < inX.height; ++y) {
            int indexIn = inX.startIndex + inX.stride * y;
            int indexOut = outX.startIndex + outX.stride * y;
            int x = 0;
            while (x < inX.width) {
                float maxValueX = ((GrayF32[])inX.bands)[0].data[indexIn];
                float maxValueY = ((GrayF32[])inY.bands)[0].data[indexIn];
                float maxNorm = maxValueX * maxValueX + maxValueY * maxValueY;
                for (int band = 1; band < ((GrayF32[])inX.bands).length; ++band) {
                    float valueX = ((GrayF32[])inX.bands)[band].data[indexIn];
                    float valueY = ((GrayF32[])inY.bands)[band].data[indexIn];
                    float n = valueX * valueX + valueY * valueY;
                    if (!(n > maxNorm)) continue;
                    maxNorm = n;
                    maxValueX = valueX;
                    maxValueY = valueY;
                }
                outX.data[indexOut] = maxValueX;
                outY.data[indexOut] = maxValueY;
                ++x;
                ++indexIn;
                ++indexOut;
            }
        }
    }

    public static void maxf(Planar<GrayU8> inX, Planar<GrayU8> inY, GrayU8 outX, GrayU8 outY) {
        InputSanityCheck.checkSameShape(inX, inY);
        InputSanityCheck.reshapeOneIn(inX, outX, outY);
        InputSanityCheck.checkIndexing(inX, inY);
        InputSanityCheck.checkIndexing(outX, outY);
        for (int y = 0; y < inX.height; ++y) {
            int indexIn = inX.startIndex + inX.stride * y;
            int indexOut = outX.startIndex + outX.stride * y;
            int x = 0;
            while (x < inX.width) {
                int maxValueX = ((GrayU8[])inX.bands)[0].data[indexIn] & 0xFF;
                int maxValueY = ((GrayU8[])inY.bands)[0].data[indexIn] & 0xFF;
                int maxNorm = maxValueX * maxValueX + maxValueY * maxValueY;
                for (int band = 1; band < ((GrayU8[])inX.bands).length; ++band) {
                    int valueX = ((GrayU8[])inX.bands)[band].data[indexIn] & 0xFF;
                    int valueY = ((GrayU8[])inY.bands)[band].data[indexIn] & 0xFF;
                    int n = valueX * valueX + valueY * valueY;
                    if (n <= maxNorm) continue;
                    maxNorm = n;
                    maxValueX = valueX;
                    maxValueY = valueY;
                }
                outX.data[indexOut] = (byte)maxValueX;
                outY.data[indexOut] = (byte)maxValueY;
                ++x;
                ++indexIn;
                ++indexOut;
            }
        }
    }
}

