/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary.impl;

import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;

public class ImplBinaryImageOps_MT {
    public static void logicAnd(GrayU8 inputA, GrayU8 inputB, GrayU8 output) {
        BoofConcurrency.loopFor(0, inputA.height, y -> {
            int indexA = inputA.startIndex + y * inputA.stride;
            int indexB = inputB.startIndex + y * inputB.stride;
            int indexOut = output.startIndex + y * output.stride;
            int end = indexA + inputA.width;
            while (indexA < end) {
                byte valA = inputA.data[indexA];
                output.data[indexOut] = valA == 1 && valA == inputB.data[indexB] ? (byte)1 : (byte)0;
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        });
    }

    public static void logicOr(GrayU8 inputA, GrayU8 inputB, GrayU8 output) {
        BoofConcurrency.loopFor(0, inputA.height, y -> {
            int indexA = inputA.startIndex + y * inputA.stride;
            int indexB = inputB.startIndex + y * inputB.stride;
            int indexOut = output.startIndex + y * output.stride;
            int end = indexA + inputA.width;
            while (indexA < end) {
                output.data[indexOut] = inputA.data[indexA] == 1 || 1 == inputB.data[indexB] ? (byte)1 : (byte)0;
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        });
    }

    public static void logicXor(GrayU8 inputA, GrayU8 inputB, GrayU8 output) {
        BoofConcurrency.loopFor(0, inputA.height, y -> {
            int indexA = inputA.startIndex + y * inputA.stride;
            int indexB = inputB.startIndex + y * inputB.stride;
            int indexOut = output.startIndex + y * output.stride;
            int end = indexA + inputA.width;
            while (indexA < end) {
                output.data[indexOut] = inputA.data[indexA] != inputB.data[indexB] ? (byte)1 : (byte)0;
                ++indexA;
                ++indexB;
                ++indexOut;
            }
        });
    }

    public static void invert(GrayU8 input, GrayU8 output) {
        BoofConcurrency.loopFor(0, input.height, y -> {
            int index = input.startIndex + y * input.stride;
            int indexOut = output.startIndex + y * output.stride;
            int end = index + input.width;
            while (index < end) {
                output.data[indexOut] = input.data[index] == 0 ? (byte)1 : (byte)0;
                ++index;
                ++indexOut;
            }
        });
    }

    public static void relabel(GrayS32 input, int[] labels) {
        BoofConcurrency.loopFor(0, input.height, y -> {
            int index;
            int end = index + input.width;
            for (index = input.startIndex + y * input.stride; index < end; ++index) {
                int val = input.data[index];
                input.data[index] = labels[val];
            }
        });
    }

    public static void labelToBinary(GrayS32 labelImage, GrayU8 binaryImage) {
        BoofConcurrency.loopFor(0, labelImage.height, y -> {
            int indexIn = labelImage.startIndex + y * labelImage.stride;
            int indexOut = binaryImage.startIndex + y * binaryImage.stride;
            int end = indexIn + labelImage.width;
            while (indexIn < end) {
                binaryImage.data[indexOut] = 0 == labelImage.data[indexIn] ? (byte)0 : (byte)1;
                ++indexIn;
                ++indexOut;
            }
        });
    }

    public static void labelToBinary(GrayS32 labelImage, GrayU8 binaryImage, boolean[] selectedBlobs) {
        BoofConcurrency.loopFor(0, labelImage.height, y -> {
            int indexIn = labelImage.startIndex + y * labelImage.stride;
            int indexOut = binaryImage.startIndex + y * binaryImage.stride;
            int end = indexIn + labelImage.width;
            while (indexIn < end) {
                int val = labelImage.data[indexIn];
                binaryImage.data[indexOut] = selectedBlobs[val] ? (byte)1 : (byte)0;
                ++indexIn;
                ++indexOut;
            }
        });
    }
}

