/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.square;

import boofcv.abst.filter.binary.BinaryContourFinder;
import boofcv.abst.filter.binary.BinaryContourHelper;
import boofcv.abst.filter.binary.InputToBinary;
import boofcv.abst.geo.Estimate1ofEpipolar;
import boofcv.abst.geo.RefineEpipolar;
import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.distort.PixelTransformCached_F32;
import boofcv.alg.distort.PointTransformHomography_F32;
import boofcv.alg.fiducial.square.FoundFiducial;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.shapes.polygon.DetectPolygonBinaryGrayRefine;
import boofcv.alg.shapes.polygon.DetectPolygonFromContour;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.factory.distort.FactoryDistort;
import boofcv.factory.geo.EpipolarError;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.border.BorderType;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.distort.DoNothing2Transform2_F64;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.distort.PointToPixelTransform_F32;
import boofcv.struct.distort.SequencePoint2Transform2_F32;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import georegression.geometry.UtilPolygons2D_F64;
import georegression.struct.ConvertFloatType;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.VerbosePrint;
import org.ejml.UtilEjml;
import org.ejml.data.DMatrixRMaj;
import org.ejml.ops.DConvertMatrixStruct;
import org.jetbrains.annotations.Nullable;

public abstract class BaseDetectFiducialSquare<T extends ImageGray<T>>
implements VerbosePrint {
    private final DogArray<FoundFiducial> found = new DogArray<FoundFiducial>(FoundFiducial::new);
    InputToBinary<T> inputToBinary;
    DetectPolygonBinaryGrayRefine<T> squareDetector;
    BinaryContourHelper contourHelper;
    GrayF32 square;
    private final Estimate1ofEpipolar computeHomography = FactoryMultiView.homographyDLT(true);
    private final RefineEpipolar refineHomography = FactoryMultiView.homographyRefine(1.0E-4, 100, EpipolarError.SAMPSON);
    private final DMatrixRMaj H = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj H_refined = new DMatrixRMaj(3, 3);
    private final Homography2D_F64 H_fixed = new Homography2D_F64();
    private final List<AssociatedPair> pairsRemovePerspective = new ArrayList<AssociatedPair>();
    private final ImageDistort<T, GrayF32> removePerspective;
    private final PointTransformHomography_F32 transformHomography = new PointTransformHomography_F32();
    private Point2Transform2_F64 undistToDist = new DoNothing2Transform2_F64();
    protected double borderWidthFraction;
    private final double minimumBorderBlackFraction;
    private final Result result = new Result();
    private final Class<T> inputType;
    private double thresholdSideRatio = 0.05;
    @Nullable
    PrintStream verbose;
    private final Polygon2D_F64 interpolationHack = new Polygon2D_F64(4);
    List<Polygon2D_F64> candidates = new ArrayList<Polygon2D_F64>();
    List<DetectPolygonFromContour.Info> candidatesInfo = new ArrayList<DetectPolygonFromContour.Info>();

    protected BaseDetectFiducialSquare(InputToBinary<T> inputToBinary, DetectPolygonBinaryGrayRefine<T> squareDetector, boolean binaryCopy, double borderWidthFraction, double minimumBorderBlackFraction, int squarePixels, Class<T> inputType) {
        squareDetector.getDetector().setOutputClockwiseUpY(false);
        squareDetector.getDetector().setConvex(true);
        squareDetector.getDetector().setNumberOfSides(4, 4);
        if (borderWidthFraction <= 0.0 || borderWidthFraction >= 0.5) {
            throw new RuntimeException("Border width fraction must be 0 < x < 0.5");
        }
        this.borderWidthFraction = borderWidthFraction;
        this.minimumBorderBlackFraction = minimumBorderBlackFraction;
        this.inputToBinary = inputToBinary;
        this.squareDetector = squareDetector;
        this.inputType = inputType;
        this.square = new GrayF32(squarePixels, squarePixels);
        for (int i = 0; i < 4; ++i) {
            this.pairsRemovePerspective.add(new AssociatedPair());
        }
        InterpolatePixelS<T> interp = FactoryInterpolation.nearestNeighborPixelS(inputType);
        interp.setBorder((ImageBorder<T>)FactoryImageBorder.single(BorderType.EXTENDED, inputType));
        this.removePerspective = FactoryDistort.distortSB(false, interp, GrayF32.class);
        this.removePerspective.setModel(new PointToPixelTransform_F32(this.transformHomography));
        BinaryContourFinder contourFinder = squareDetector.getDetector().getContourFinder();
        this.contourHelper = new BinaryContourHelper(contourFinder, binaryCopy);
    }

    public void configure(@Nullable LensDistortionNarrowFOV distortion, int width, int height, boolean cache) {
        if (distortion == null) {
            this.removePerspective.setModel(new PointToPixelTransform_F32(this.transformHomography));
            this.squareDetector.setLensDistortion(width, height, null, null);
            this.undistToDist = new DoNothing2Transform2_F64();
        } else {
            Point2Transform2_F32 pointDistToUndist = distortion.undistort_F32(true, true);
            Point2Transform2_F32 pointUndistToDist = distortion.distort_F32(true, true);
            PixelTransform<Point2D_F32> distToUndist = new PointToPixelTransform_F32(pointDistToUndist);
            PixelTransform<Point2D_F32> undistToDist = new PointToPixelTransform_F32(pointUndistToDist);
            Point2D_F32 test = new Point2D_F32();
            pointDistToUndist.compute(0.0f, 0.0f, test);
            if (test.norm() <= UtilEjml.TEST_F32) {
                this.configure(null, width, height, false);
            } else {
                if (cache) {
                    distToUndist = new PixelTransformCached_F32(width, height, distToUndist);
                    undistToDist = new PixelTransformCached_F32(width, height, undistToDist);
                }
                this.squareDetector.setLensDistortion(width, height, distToUndist, undistToDist);
                SequencePoint2Transform2_F32 pointSquareToInput = new SequencePoint2Transform2_F32(this.transformHomography, pointUndistToDist);
                PointToPixelTransform_F32 squareToInput = new PointToPixelTransform_F32(pointSquareToInput);
                this.removePerspective.setModel(squareToInput);
                this.undistToDist = distortion.distort_F64(true, true);
            }
        }
    }

    public void process(T gray) {
        this.configureContourDetector(gray);
        this.contourHelper.reshape(((ImageGray)gray).width, ((ImageGray)gray).height);
        this.inputToBinary.process(gray, this.contourHelper.withoutPadding());
        this.squareDetector.process(gray, this.contourHelper.padded());
        this.squareDetector.refineAll();
        this.squareDetector.getPolygons(this.candidates, this.candidatesInfo);
        this.found.reset();
        if (this.verbose != null) {
            this.verbose.println("---------- Got Polygons! " + this.candidates.size());
        }
        for (int i = 0; i < this.candidates.size(); ++i) {
            double pixelThreshold;
            double foundFraction;
            Polygon2D_F64 p = this.candidates.get(i);
            if (!this.checkSideSize(p)) {
                if (this.verbose == null) continue;
                this.verbose.println("_ rejected side aspect ratio or size");
                continue;
            }
            double best = Double.MAX_VALUE;
            for (int j = 0; j < 4; ++j) {
                double found = p.get(0).normSq();
                if (found < best) {
                    best = found;
                    this.interpolationHack.setTo(p);
                }
                UtilPolygons2D_F64.shiftDown(p);
            }
            p.setTo(this.interpolationHack);
            this.pairsRemovePerspective.get(0).setTo(0.0, 0.0, p.get((int)0).x, p.get((int)0).y);
            this.pairsRemovePerspective.get(1).setTo(this.square.width, 0.0, p.get((int)1).x, p.get((int)1).y);
            this.pairsRemovePerspective.get(2).setTo(this.square.width, this.square.height, p.get((int)2).x, p.get((int)2).y);
            this.pairsRemovePerspective.get(3).setTo(0.0, this.square.height, p.get((int)3).x, p.get((int)3).y);
            if (!this.computeHomography.process(this.pairsRemovePerspective, this.H)) {
                if (this.verbose == null) continue;
                this.verbose.println("_ rejected initial homography");
                continue;
            }
            if (!this.refineHomography.fitModel(this.pairsRemovePerspective, this.H, this.H_refined)) {
                if (this.verbose == null) continue;
                this.verbose.println("_ rejected refine homography");
                continue;
            }
            DConvertMatrixStruct.convert(this.H_refined, this.H_fixed);
            ConvertFloatType.convert(this.H_fixed, this.transformHomography.getModel());
            this.removePerspective.apply(gray, this.square);
            DetectPolygonFromContour.Info info = this.candidatesInfo.get(i);
            if (this.minimumBorderBlackFraction > 0.0 && (foundFraction = this.computeFractionBoundary((float)(pixelThreshold = (info.edgeInside + info.edgeOutside) / 2.0))) < this.minimumBorderBlackFraction) {
                if (this.verbose == null) continue;
                this.verbose.println("_ rejected black border fraction " + foundFraction);
                continue;
            }
            if (this.processSquare(this.square, this.result, info.edgeInside, info.edgeOutside)) {
                this.prepareForOutput(p, this.result);
                if (this.verbose == null) continue;
                this.verbose.println("_ accepted!");
                continue;
            }
            if (this.verbose == null) continue;
            this.verbose.println("_ rejected process square");
        }
    }

    private boolean checkSideSize(Polygon2D_F64 p) {
        double max = 0.0;
        double min = Double.MAX_VALUE;
        for (int i = 0; i < p.size(); ++i) {
            double l = p.getSideLength(i);
            max = Math.max(max, l);
            min = Math.min(min, l);
        }
        if (min < 10.0) {
            return false;
        }
        return !(min / max < this.thresholdSideRatio);
    }

    private void configureContourDetector(T gray) {
        int maxContourSize = Math.min(((ImageGray)gray).width, ((ImageGray)gray).height) * 4;
        BinaryContourFinder contourFinder = this.squareDetector.getDetector().getContourFinder();
        contourFinder.setMaxContour(maxContourSize);
        contourFinder.setSaveInnerContour(false);
    }

    protected double computeFractionBoundary(float pixelThreshold) {
        int x;
        int y;
        int w = this.square.width;
        int radius = (int)((double)w * this.borderWidthFraction);
        int innerWidth = w - 2 * radius;
        int total = w * w - innerWidth * innerWidth;
        int count = 0;
        for (y = 0; y < radius; ++y) {
            int indexTop = y * w;
            int indexBottom = (w - radius + y) * w;
            for (x = 0; x < w; ++x) {
                int n = indexTop++;
                if (this.square.data[n] < pixelThreshold) {
                    ++count;
                }
                int n2 = indexBottom++;
                if (!(this.square.data[n2] < pixelThreshold)) continue;
                ++count;
            }
        }
        for (y = radius; y < w - radius; ++y) {
            int indexLeft = y * w;
            int indexRight = y * w + w - radius;
            for (x = 0; x < radius; ++x) {
                int n = indexLeft++;
                if (this.square.data[n] < pixelThreshold) {
                    ++count;
                }
                int n3 = indexRight++;
                if (!(this.square.data[n3] < pixelThreshold)) continue;
                ++count;
            }
        }
        return (double)count / (double)total;
    }

    private void prepareForOutput(Polygon2D_F64 imageShape, Result result) {
        int rotationCCW = (4 - result.rotation) % 4;
        for (int j = 0; j < rotationCCW; ++j) {
            UtilPolygons2D_F64.shiftUp(imageShape);
        }
        FoundFiducial f = this.found.grow();
        f.id = result.which;
        f.encodingError = result.error;
        for (int i = 0; i < 4; ++i) {
            Point2D_F64 a = imageShape.get(i);
            this.undistToDist.compute(a.x, a.y, f.distortedPixels.get(i));
        }
    }

    public DogArray<FoundFiducial> getFound() {
        return this.found;
    }

    protected abstract boolean processSquare(GrayF32 var1, Result var2, double var3, double var5);

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix(this, out);
    }

    public GrayU8 getBinary() {
        return this.contourHelper.withoutPadding();
    }

    public InputToBinary<T> getInputToBinary() {
        return this.inputToBinary;
    }

    public DetectPolygonBinaryGrayRefine<T> getSquareDetector() {
        return this.squareDetector;
    }

    public double getBorderWidthFraction() {
        return this.borderWidthFraction;
    }

    public Class<T> getInputType() {
        return this.inputType;
    }

    public double getThresholdSideRatio() {
        return this.thresholdSideRatio;
    }

    public void setThresholdSideRatio(double thresholdSideRatio) {
        this.thresholdSideRatio = thresholdSideRatio;
    }

    public static class Result {
        int which;
        double lengthSide;
        int rotation;
        double error;
    }
}

