/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import boofcv.alg.fiducial.calib.squares.SquareGraph;
import boofcv.alg.fiducial.calib.squares.SquareNode;
import boofcv.alg.fiducial.qrcode.PositionPatternNode;
import georegression.struct.line.LineSegment2D_F64;
import georegression.struct.point.Point2D_F64;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import org.ddogleg.nn.FactoryNearestNeighbor;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public class QrCodePositionPatternGraphGenerator
implements VerbosePrint {
    int maxVersionQR = 40;
    SquareGraph graph = new SquareGraph();
    private final NearestNeighbor<SquareNode> nn = FactoryNearestNeighbor.kdtree(new SquareNode.KdTreeSquareNode());
    private final NearestNeighbor.Search<SquareNode> search = this.nn.createSearch();
    private final DogArray<NnData<SquareNode>> searchResults = new DogArray<Object>(NnData::new);
    protected LineSegment2D_F64 lineA = new LineSegment2D_F64();
    protected LineSegment2D_F64 lineB = new LineSegment2D_F64();
    protected LineSegment2D_F64 connectLine = new LineSegment2D_F64();
    protected Point2D_F64 intersection = new Point2D_F64();

    public QrCodePositionPatternGraphGenerator() {
    }

    public QrCodePositionPatternGraphGenerator(int maxVersionQR) {
        this.maxVersionQR = maxVersionQR;
    }

    public void process(List<PositionPatternNode> positionPatterns) {
        this.graph.reset();
        this.nn.setPoints(positionPatterns, false);
        for (int i = 0; i < positionPatterns.size(); ++i) {
            PositionPatternNode f = positionPatterns.get(i);
            double maximumQrCodeWidth = f.largestSide * ((double)(17 + 4 * this.maxVersionQR) - 7.0) / 7.0;
            double searchRadius = 1.2 * maximumQrCodeWidth;
            searchRadius *= searchRadius;
            this.search.findNearest(f, searchRadius, Integer.MAX_VALUE, this.searchResults);
            if (this.searchResults.size <= 1) continue;
            for (int j = 0; j < this.searchResults.size; ++j) {
                NnData r = (NnData)this.searchResults.get(j);
                if (r.point == f) continue;
                this.considerConnect(f, (SquareNode)r.point);
            }
        }
    }

    void considerConnect(SquareNode node0, SquareNode node1) {
        this.lineA.a = node0.center;
        this.lineA.b = node1.center;
        int intersection0 = this.graph.findSideIntersect(node0, this.lineA, this.intersection, this.lineB);
        this.connectLine.a.setTo(this.intersection);
        int intersection1 = this.graph.findSideIntersect(node1, this.lineA, this.intersection, this.lineB);
        this.connectLine.b.setTo(this.intersection);
        if (intersection1 < 0 || intersection0 < 0) {
            return;
        }
        double side0 = node0.sideLengths[intersection0];
        double side1 = node1.sideLengths[intersection1];
        double sideLoc0 = this.connectLine.a.distance(node0.square.get(intersection0)) / side0;
        double sideLoc1 = this.connectLine.b.distance(node1.square.get(intersection1)) / side1;
        if (Math.abs(sideLoc0 - 0.5) > 0.35 || Math.abs(sideLoc1 - 0.5) > 0.35) {
            return;
        }
        if (Math.abs(side0 - side1) / Math.max(side0, side1) > 0.25) {
            return;
        }
        if (!this.graph.almostParallel(node0, intersection0, node1, intersection1)) {
            return;
        }
        double ratio = Math.max(node0.smallestSide / node1.largestSide, node1.smallestSide / node0.largestSide);
        if (ratio > 1.3) {
            return;
        }
        double angle = this.graph.acuteAngle(node0, intersection0, node1, intersection1);
        double score = this.lineA.getLength() * (1.0 + angle / 0.1);
        this.graph.checkConnect(node0, intersection0, node1, intersection1, score);
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
    }

    public int getMaxVersionQR() {
        return this.maxVersionQR;
    }

    public void setMaxVersionQR(int maxVersionQR) {
        this.maxVersionQR = maxVersionQR;
    }
}

