/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import boofcv.abst.filter.binary.BinaryContourFinder;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.fiducial.calib.squares.SquareGraph;
import boofcv.alg.fiducial.qrcode.PositionPatternNode;
import boofcv.alg.interpolate.InterpolatePixelDistortS;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.shapes.polygon.DetectPolygonBinaryGrayRefine;
import boofcv.alg.shapes.polygon.DetectPolygonFromContour;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.misc.BoofMiscOps;
import boofcv.misc.MovingAverage;
import boofcv.struct.border.BorderType;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.distort.PointToPixelTransform_F32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import georegression.geometry.UtilLine2D_F64;
import georegression.geometry.UtilPoint2D_F64;
import georegression.struct.line.LineParametric2D_F64;
import georegression.struct.line.LineSegment2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public class QrCodePositionPatternDetector<T extends ImageGray<T>>
implements VerbosePrint {
    InterpolatePixelS<T> interpolate;
    double maxContourFraction = 1.3333333333333333;
    DetectPolygonBinaryGrayRefine<T> squareDetector;
    DogArray<PositionPatternNode> positionPatterns = new DogArray<PositionPatternNode>(PositionPatternNode::new, PositionPatternNode::reset);
    protected MovingAverage profilingMS = new MovingAverage(0.8);
    @Nullable
    PrintStream verbose = null;
    LineSegment2D_F64 segment = new LineSegment2D_F64();
    LineParametric2D_F64 parametric = new LineParametric2D_F64();
    float[] samples = new float[46];
    int[] length = new int[12];
    int[] type = new int[12];

    public QrCodePositionPatternDetector(DetectPolygonBinaryGrayRefine<T> squareDetector) {
        this.squareDetector = squareDetector;
        squareDetector.getDetector().setConvex(true);
        squareDetector.getDetector().setOutputClockwiseUpY(false);
        squareDetector.getDetector().setNumberOfSides(4, 4);
        this.interpolate = FactoryInterpolation.bilinearPixelS(squareDetector.getInputType(), BorderType.EXTENDED);
    }

    public void resetRuntimeProfiling() {
        this.squareDetector.resetRuntimeProfiling();
    }

    public void process(T gray, GrayU8 binary) {
        this.configureContourDetector(gray);
        this.interpolate.setImage(gray);
        this.squareDetector.process(gray, binary);
        long time0 = System.nanoTime();
        this.squaresToPositionList();
        long time1 = System.nanoTime();
        if (this.verbose != null) {
            this.verbose.printf("squares=%d position_pattern=%d\n", this.squareDetector.getPolygonInfo().size(), this.positionPatterns.size);
        }
        this.profilingMS.update((double)(time1 - time0) * 1.0E-6);
    }

    public void setLensDistortion(int width, int height, @Nullable LensDistortionNarrowFOV model) {
        this.interpolate = FactoryInterpolation.bilinearPixelS(this.squareDetector.getInputType(), BorderType.EXTENDED);
        if (model != null) {
            PointToPixelTransform_F32 distToUndist = new PointToPixelTransform_F32(model.undistort_F32(true, true));
            PointToPixelTransform_F32 undistToDist = new PointToPixelTransform_F32(model.distort_F32(true, true));
            this.squareDetector.setLensDistortion(width, height, distToUndist, undistToDist);
            Point2Transform2_F32 u2d = model.distort_F32(true, true);
            this.interpolate = new InterpolatePixelDistortS<T>(this.interpolate, u2d);
        } else {
            this.squareDetector.setLensDistortion(width, height, null, null);
        }
    }

    private void configureContourDetector(T gray) {
        int maxContourSize = (int)((double)Math.min(((ImageGray)gray).width, ((ImageGray)gray).height) * this.maxContourFraction);
        BinaryContourFinder contourFinder = this.squareDetector.getDetector().getContourFinder();
        contourFinder.setMaxContour(maxContourSize);
        contourFinder.setSaveInnerContour(false);
    }

    private void squaresToPositionList() {
        this.positionPatterns.reset();
        List<DetectPolygonFromContour.Info> infoList = this.squareDetector.getPolygonInfo();
        for (int i = 0; i < infoList.size(); ++i) {
            DetectPolygonFromContour.Info info = infoList.get(i);
            double grayThreshold = (info.edgeInside + info.edgeOutside) / 2.0;
            if (!this.checkPositionPatternAppearance(info.polygon, (float)grayThreshold)) continue;
            this.squareDetector.refine(info);
            PositionPatternNode pp = this.positionPatterns.grow();
            pp.square = info.polygon;
            pp.grayThreshold = grayThreshold;
            SquareGraph.computeNodeInfo(pp);
        }
    }

    boolean checkPositionPatternAppearance(Polygon2D_F64 square, float grayThreshold) {
        return this.checkLine(square, grayThreshold, 0) || this.checkLine(square, grayThreshold, 1);
    }

    private boolean checkLine(Polygon2D_F64 square, float grayThreshold, int side) {
        int i;
        int c0 = side;
        int c1 = (side + 1) % 4;
        int c2 = (side + 2) % 4;
        int c3 = (side + 3) % 4;
        UtilPoint2D_F64.mean(square.get(c0), square.get(c1), this.segment.a);
        UtilPoint2D_F64.mean(square.get(c2), square.get(c3), this.segment.b);
        UtilLine2D_F64.convert(this.segment, this.parametric);
        int period = this.samples.length / 9;
        double N = this.samples.length - 2 * period - 1;
        for (int i2 = 0; i2 < this.samples.length; ++i2) {
            double location = (double)(i2 - period) / N;
            float x = (float)(this.parametric.p.x + location * this.parametric.slope.x);
            float y = (float)(this.parametric.p.y + location * this.parametric.slope.y);
            this.samples[i2] = this.interpolate.get(x, y);
        }
        int size = 0;
        boolean black = this.samples[0] < grayThreshold;
        this.type[0] = black ? 0 : 1;
        for (i = 0; i < this.samples.length; ++i) {
            boolean b;
            boolean bl = b = this.samples[i] < grayThreshold;
            if (black == b) {
                int n = size;
                this.length[n] = this.length[n] + 1;
                continue;
            }
            black = b;
            if (size >= this.type.length - 1) break;
            this.type[++size] = black ? 0 : 1;
            this.length[size] = 1;
        }
        if (++size < 5 || size > 9) {
            return false;
        }
        i = 0;
        while (i + 5 <= size) {
            if (this.type[i] == 0) {
                int black02;
                int black0 = this.length[i];
                int black1 = this.length[i + 2];
                int black2 = this.length[i + 4];
                int white0 = this.length[i + 1];
                int white1 = this.length[i + 3];
                if (!((double)black0 < 0.4 * (double)white0) && black0 <= 3 * white0 && !((double)black2 < 0.4 * (double)white1) && black2 <= 3 * white1 && black1 >= (black02 = black0 + black2) && black1 <= 2 * black02) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    static boolean positionSquareIntensityCheck(float[] values, float threshold) {
        if (values[0] > threshold || values[1] < threshold) {
            return false;
        }
        if (values[2] > threshold || values[3] > threshold || values[4] > threshold) {
            return false;
        }
        return !(values[5] < threshold) && !(values[6] > threshold);
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix(this, out);
    }

    public double getMaxContourFraction() {
        return this.maxContourFraction;
    }

    public void setMaxContourFraction(double maxContourFraction) {
        this.maxContourFraction = maxContourFraction;
    }

    public DetectPolygonBinaryGrayRefine<T> getSquareDetector() {
        return this.squareDetector;
    }

    public DogArray<PositionPatternNode> getPositionPatterns() {
        return this.positionPatterns;
    }

    public MovingAverage getProfilingMS() {
        return this.profilingMS;
    }
}

