/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import boofcv.alg.fiducial.qrcode.PackedBits32;
import boofcv.alg.fiducial.qrcode.QrCode;
import boofcv.alg.fiducial.qrcode.QrCodeCodeWordLocations;
import boofcv.alg.fiducial.qrcode.QrCodeMaskPattern;
import boofcv.alg.fiducial.qrcode.QrCodePolynomialMath;
import boofcv.alg.fiducial.qrcode.QrGeneratorBase;
import georegression.struct.point.Point2D_I32;

public class QrCodeGenerator
extends QrGeneratorBase<QrCodeGenerator> {
    QrCode qr;

    public QrCodeGenerator(double markerWidth) {
        super(markerWidth);
    }

    public QrCodeGenerator() {
    }

    public QrCodeGenerator render(QrCode qr) {
        this.initialize(qr);
        this.render.init();
        this.positionPattern(0.0, 0.0, qr.ppCorner);
        this.positionPattern((double)(this.numModules - 7) * this.moduleWidth, 0.0, qr.ppRight);
        this.positionPattern(0.0, (double)(this.numModules - 7) * this.moduleWidth, qr.ppDown);
        this.timingPattern(7.0 * this.moduleWidth, 6.0 * this.moduleWidth, this.moduleWidth, 0.0, this.numModules - 14);
        this.timingPattern(6.0 * this.moduleWidth, 7.0 * this.moduleWidth, 0.0, this.moduleWidth, this.numModules - 14);
        this.formatInformation();
        if (qr.version >= 7) {
            this.versionInformation();
        }
        int[] alignment = QrCode.VERSION_INFO[qr.version].alignment;
        for (int i = 0; i < alignment.length; ++i) {
            int row = alignment[i];
            for (int j = 0; j < alignment.length; ++j) {
                if (i == 0 && j == 0 || i == alignment.length - 1 && j == 0 || i == 0 && j == alignment.length - 1) continue;
                int col = alignment[j];
                this.alignmentPattern(col, row);
            }
        }
        if (this.renderData) {
            if (qr.rawbits.length != QrCode.VERSION_INFO[qr.version].codewords) {
                throw new RuntimeException("Unexpected length of raw data.");
            }
            this.bitLocations = QrCodeCodeWordLocations.qrcode((int)qr.version).bits;
            int numBytes = this.bitLocations.size() / 8;
            if (numBytes != qr.rawbits.length) {
                throw new RuntimeException("Egads. unexpected length of qrcode raw data");
            }
            this.renderData();
        }
        qr.bounds.set(0, 0.0, 0.0);
        qr.bounds.set(1, this.markerWidth, 0.0);
        qr.bounds.set(2, this.markerWidth, this.markerWidth);
        qr.bounds.set(3, 0.0, this.markerWidth);
        return this;
    }

    protected void initialize(QrCode qr) {
        this.qr = qr;
        this.numModules = QrCode.totalModules(qr.version);
        this.moduleWidth = this.markerWidth / (double)this.numModules;
        this.bitLocations = null;
    }

    private void renderData() {
        QrCodeMaskPattern mask = this.qr.mask;
        int length = this.bitLocations.size() - this.bitLocations.size() % 8;
        for (int count = 0; count < length; count += 8) {
            int bits = this.qr.rawbits[count / 8] & 0xFF;
            int N = Math.min(8, this.bitLocations.size() - count);
            for (int i = 0; i < N; ++i) {
                Point2D_I32 coor = (Point2D_I32)this.bitLocations.get(count + i);
                int value = mask.apply(coor.y, coor.x, bits >> i & 1);
                if (value <= 0) continue;
                this.square(coor.y, coor.x);
            }
        }
    }

    static PackedBits32 formatInformationBits(QrCode qr) {
        PackedBits32 bits = new PackedBits32(15);
        bits.data[0] = QrCodePolynomialMath.encodeFormatBits(qr.error, qr.mask.bits);
        bits.data[0] = bits.data[0] ^ 0x5412;
        return bits;
    }

    private void formatInformation() {
        PackedBits32 bits = QrCodeGenerator.formatInformationBits(this.qr);
        for (int i = 0; i < 15; ++i) {
            if (bits.get(i) == 0) continue;
            if (i < 6) {
                this.square(i, 8);
            } else if (i < 8) {
                this.square(i + 1, 8);
            } else if (i == 8) {
                this.square(8, 7);
            } else {
                this.square(8, 14 - i);
            }
            if (i < 8) {
                this.square(8, this.numModules - i - 1);
                continue;
            }
            this.square(this.numModules - (15 - i), 8);
        }
        this.square(this.numModules - 8, 8);
    }

    private void versionInformation() {
        PackedBits32 bits = new PackedBits32(18);
        bits.data[0] = QrCodePolynomialMath.encodeVersionBits(this.qr.version);
        for (int i = 0; i < 18; ++i) {
            if (bits.get(i) == 0) continue;
            int row = i / 3;
            int col = i % 3;
            this.square(row, this.numModules - 11 + col);
            this.square(this.numModules - 11 + col, row);
        }
    }

    private void alignmentPattern(int gridX, int gridY) {
        double x = (double)(gridX - 2) * this.moduleWidth;
        double y = (double)(gridY - 2) * this.moduleWidth;
        this.render.square(x, y, this.moduleWidth * 5.0, this.moduleWidth);
        this.render.square(x + this.moduleWidth * 2.0, y + this.moduleWidth * 2.0, this.moduleWidth);
        QrCode.Alignment a = this.qr.alignment.grow();
        a.moduleX = gridX;
        a.moduleY = gridY;
        a.pixel.setTo(((double)gridX + 0.5) * this.moduleWidth, ((double)gridY + 0.5) * this.moduleWidth);
    }
}

