/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.fiducial.qrcode.PackedBits8;
import boofcv.alg.fiducial.qrcode.PositionPatternNode;
import boofcv.alg.fiducial.qrcode.QrCode;
import boofcv.alg.fiducial.qrcode.QrCodeAlignmentPatternLocator;
import boofcv.alg.fiducial.qrcode.QrCodeBinaryGridReader;
import boofcv.alg.fiducial.qrcode.QrCodeDecoderBits;
import boofcv.alg.fiducial.qrcode.QrCodePolynomialMath;
import boofcv.struct.image.ImageGray;
import georegression.geometry.UtilPolygons2D_F64;
import georegression.metric.Intersection2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import georegression.struct.shapes.Polygon2D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F32;
import org.jetbrains.annotations.Nullable;

public class QrCodeDecoderImage<T extends ImageGray<T>> {
    QrCodeDecoderBits decoder;
    public boolean considerTransposed = true;
    DogArray<QrCode> storageQR = new DogArray<QrCode>(QrCode::new, QrCode::reset);
    List<QrCode> successes = new ArrayList<QrCode>();
    List<QrCode> failures = new ArrayList<QrCode>();
    PackedBits8 bits = new PackedBits8();
    Point2D_F64 grid = new Point2D_F64();
    Polygon2D_F64 tempTranspose = new Polygon2D_F64();
    QrCodeAlignmentPatternLocator<T> alignmentLocator;
    QrCodeBinaryGridReader<T> gridReader;
    DogArray_F32 intensityBits = new DogArray_F32();

    public QrCodeDecoderImage(@Nullable String forceEncoding, Class<T> imageType) {
        this.decoder = new QrCodeDecoderBits(forceEncoding);
        this.gridReader = new QrCodeBinaryGridReader<T>(imageType);
        this.alignmentLocator = new QrCodeAlignmentPatternLocator<T>(imageType);
    }

    public void process(List<PositionPatternNode> pps, T gray) {
        this.gridReader.setImage(gray);
        this.storageQR.reset();
        this.successes.clear();
        this.failures.clear();
        for (int i = 0; i < pps.size(); ++i) {
            PositionPatternNode ppn = pps.get(i);
            int j = 3;
            int k = 0;
            while (k < 4) {
                if (ppn.edges[j] != null && ppn.edges[k] != null) {
                    QrCode qr = this.storageQR.grow();
                    QrCodeDecoderImage.setPositionPatterns(ppn, j, k, qr);
                    QrCodeDecoderImage.computeBoundingBox(qr);
                    if (this.decode(gray, qr)) {
                        this.successes.add(qr);
                    } else {
                        boolean success = false;
                        if (this.considerTransposed) {
                            this.transposePositionPatterns(qr);
                            success = this.decode(gray, qr);
                        }
                        if (success) {
                            qr.bitsTransposed = true;
                            this.successes.add(qr);
                        } else {
                            this.failures.add(qr);
                        }
                    }
                }
                j = k++;
            }
        }
    }

    void transposePositionPatterns(QrCode qr) {
        this.tempTranspose.setTo(qr.ppDown);
        qr.ppDown.setTo(qr.ppRight);
        qr.ppRight.setTo(this.tempTranspose);
        QrCodeDecoderImage.transposeCorners(qr.ppCorner);
        QrCodeDecoderImage.transposeCorners(qr.ppRight);
        QrCodeDecoderImage.transposeCorners(qr.ppDown);
    }

    public static void transposeCorners(Polygon2D_F64 c) {
        double tmpX = c.get((int)1).x;
        double tmpY = c.get((int)1).y;
        c.get(1).setTo(c.get(3));
        c.get(3).setTo(tmpX, tmpY);
    }

    public void setLensDistortion(int width, int height, @Nullable LensDistortionNarrowFOV model) {
        this.alignmentLocator.setLensDistortion(width, height, model);
        this.gridReader.setLensDistortion(width, height, model);
    }

    static void setPositionPatterns(PositionPatternNode ppn, int cornerToRight, int cornerToDown, QrCode qr) {
        PositionPatternNode right = (PositionPatternNode)ppn.edges[cornerToRight].destination(ppn);
        PositionPatternNode down = (PositionPatternNode)ppn.edges[cornerToDown].destination(ppn);
        qr.ppRight.setTo(right.square);
        qr.ppCorner.setTo(ppn.square);
        qr.ppDown.setTo(down.square);
        qr.threshRight = right.grayThreshold;
        qr.threshCorner = ppn.grayThreshold;
        qr.threshDown = down.grayThreshold;
        int indexR = right.findEdgeIndex(ppn);
        int indexD = down.findEdgeIndex(ppn);
        QrCodeDecoderImage.rotateUntilAt(qr.ppRight, indexR, 3);
        QrCodeDecoderImage.rotateUntilAt(qr.ppCorner, cornerToRight, 1);
        QrCodeDecoderImage.rotateUntilAt(qr.ppDown, indexD, 0);
    }

    static void rotateUntilAt(Polygon2D_F64 square, int current, int desired) {
        while (current != desired) {
            UtilPolygons2D_F64.shiftDown(square);
            current = (current + 1) % 4;
        }
    }

    static void computeBoundingBox(QrCode qr) {
        qr.bounds.get(0).setTo(qr.ppCorner.get(0));
        qr.bounds.get(1).setTo(qr.ppRight.get(1));
        Intersection2D_F64.intersection(qr.ppRight.get(1), qr.ppRight.get(2), qr.ppDown.get(3), qr.ppDown.get(2), qr.bounds.get(2));
        qr.bounds.get(3).setTo(qr.ppDown.get(3));
    }

    private boolean decode(T gray, QrCode qr) {
        boolean removed;
        if (!this.extractFormatInfo(qr)) {
            qr.failureCause = QrCode.Failure.FORMAT;
            return false;
        }
        if (!this.extractVersionInfo(qr)) {
            qr.failureCause = QrCode.Failure.VERSION;
            return false;
        }
        if (!this.alignmentLocator.process(gray, qr)) {
            qr.failureCause = QrCode.Failure.ALIGNMENT;
            return false;
        }
        boolean success = false;
        this.gridReader.setMarker(qr);
        this.gridReader.getTransformGrid().addAllFeatures(qr);
        for (int i = 0; i < 6 && (i <= 0 || (removed = this.gridReader.getTransformGrid().removeFeatureWithLargestError())); ++i) {
            this.gridReader.getTransformGrid().computeTransform();
            qr.failureCause = QrCode.Failure.NONE;
            if (!this.readRawData(qr)) {
                qr.failureCause = QrCode.Failure.READING_BITS;
                continue;
            }
            if (!this.decoder.applyErrorCorrection(qr)) {
                qr.failureCause = QrCode.Failure.ERROR_CORRECTION;
                continue;
            }
            success = true;
            break;
        }
        if (success && !this.decoder.decodeMessage(qr)) {
            success = false;
        }
        qr.Hinv.setTo(this.gridReader.getTransformGrid().Hinv);
        return success;
    }

    private boolean extractFormatInfo(QrCode qr) {
        for (int i = 0; i < 2; ++i) {
            if (i == 0) {
                this.readFormatRegion0(qr);
            } else {
                this.readFormatRegion1(qr);
            }
            int bitField = this.bits.read(0, 15, false);
            int message = QrCodePolynomialMath.checkFormatBits(bitField ^= 0x5412) ? bitField >> 10 : QrCodePolynomialMath.correctFormatBits(bitField);
            if (message < 0) continue;
            QrCodePolynomialMath.decodeFormatMessage(message, qr);
            return true;
        }
        return false;
    }

    final boolean readFormatRegion0(QrCode qr) {
        int i;
        this.gridReader.setSquare(qr.ppCorner, (float)qr.threshCorner);
        this.bits.resize(15);
        this.bits.zero();
        for (i = 0; i < 6; ++i) {
            this.read(i, i, 8);
        }
        this.read(6, 7, 8);
        this.read(7, 8, 8);
        this.read(8, 8, 7);
        for (i = 0; i < 6; ++i) {
            this.read(9 + i, 8, 5 - i);
        }
        return true;
    }

    final boolean readFormatRegion1(QrCode qr) {
        int i;
        this.gridReader.setSquare(qr.ppRight, (float)qr.threshRight);
        this.bits.resize(15);
        this.bits.zero();
        for (i = 0; i < 8; ++i) {
            this.read(i, 8, 6 - i);
        }
        this.gridReader.setSquare(qr.ppDown, (float)qr.threshDown);
        for (i = 0; i < 7; ++i) {
            this.read(i + 8, i, 8);
        }
        return true;
    }

    private boolean readRawData(QrCode qr) {
        QrCode.VersionInfo info = QrCode.VERSION_INFO[qr.version];
        qr.rawbits = new byte[info.codewords];
        this.bits.resize(info.codewords * 8);
        List<Point2D_I32> locationBits = QrCode.LOCATION_BITS[qr.version];
        qr.threshDownRight = this.readBitIntensityAndThresholdDownRight(qr, locationBits);
        this.bitIntensityToBitValue(qr, locationBits);
        System.arraycopy(this.bits.data, 0, qr.rawbits, 0, qr.rawbits.length);
        return true;
    }

    private float readBitIntensityAndThresholdDownRight(QrCode qr, List<Point2D_I32> locationBits) {
        int numModules = qr.getNumberOfModules();
        this.intensityBits.reserve(locationBits.size() * 5);
        this.intensityBits.reset();
        int start = Math.max(8, numModules - 10);
        float sumLowerRight = 0.0f;
        int total = 0;
        for (int bitIndex = 0; bitIndex < this.bits.size; ++bitIndex) {
            Point2D_I32 b = locationBits.get(bitIndex);
            this.gridReader.readBitIntensity(b.y, b.x, this.intensityBits);
            if (b.x < start && b.y < start) continue;
            total += 5;
            for (int i = this.intensityBits.size - 5; i < this.intensityBits.size; ++i) {
                sumLowerRight += this.intensityBits.data[i];
            }
        }
        return sumLowerRight / (float)total;
    }

    private void bitIntensityToBitValue(QrCode qr, List<Point2D_I32> locationBits) {
        float gridSize = (float)qr.getNumberOfModules() - 1.0f;
        float threshold00 = (float)qr.threshCorner;
        float threshold01 = (float)qr.threshRight;
        float threshold10 = (float)qr.threshDown;
        float threshold11 = (float)qr.threshDownRight;
        int intensityIndex = 0;
        while (intensityIndex < this.intensityBits.size) {
            int bitIndex = intensityIndex / 5;
            Point2D_I32 b = locationBits.get(bitIndex);
            float bx = (float)b.x / gridSize;
            float by = (float)b.y / gridSize;
            float threshold = 0.0f;
            threshold += (1.0f - bx) * (1.0f - by) * threshold00;
            threshold += bx * (1.0f - by) * threshold01;
            threshold += bx * by * threshold11;
            int votes = 0;
            votes += this.intensityBits.data[intensityIndex++] < (threshold += (1.0f - bx) * by * threshold10) ? 1 : 0;
            votes += this.intensityBits.data[intensityIndex++] < threshold ? 1 : 0;
            votes += this.intensityBits.data[intensityIndex++] < threshold ? 1 : 0;
            votes += this.intensityBits.data[intensityIndex++] < threshold ? 1 : 0;
            int bit = (votes += this.intensityBits.data[intensityIndex++] < threshold ? 1 : 0) >= 3 ? 1 : 0;
            this.bits.set(bitIndex, qr.mask.apply(b.y, b.x, bit));
        }
    }

    private void read(int bit, int row, int col) {
        int value = this.gridReader.readBit(row, col);
        if (value == -1) {
            value = 0;
        }
        this.bits.set(bit, value);
    }

    boolean extractVersionInfo(QrCode qr) {
        int version = this.estimateVersionBySize(qr);
        if (version >= 7) {
            this.readVersionRegion0(qr);
            int version0 = this.decodeVersion();
            this.readVersionRegion1(qr);
            int version1 = this.decodeVersion();
            version = version0 < 1 && version1 < 1 ? -1 : (version0 < 1 ? version1 : (version1 < 1 ? version0 : (version0 != version1 ? -1 : version0)));
        } else if (version <= 0) {
            version = -1;
        }
        qr.version = version;
        return version >= 1 && version <= 40;
    }

    int decodeVersion() {
        int bitField = this.bits.read(0, 18, false);
        int message = QrCodePolynomialMath.checkVersionBits(bitField) ? bitField >> 12 : QrCodePolynomialMath.correctVersionBits(bitField);
        if (message > 40 || message < 7) {
            return -1;
        }
        return message;
    }

    int estimateVersionBySize(QrCode qr) {
        this.gridReader.setMarkerUnknownVersion(qr, 0.0f);
        this.gridReader.imageToGrid(qr.ppRight.get(0), this.grid);
        if (Math.abs(this.grid.y / this.grid.x) >= 0.3) {
            return -1;
        }
        double versionX = (this.grid.x + 7.0 - 17.0) / 4.0;
        this.gridReader.imageToGrid(qr.ppDown.get(0), this.grid);
        if (Math.abs(this.grid.x / this.grid.y) >= 0.3) {
            return -1;
        }
        double versionY = (this.grid.y + 7.0 - 17.0) / 4.0;
        if (Math.abs(versionX - versionY) / Math.max(versionX, versionY) > 0.4) {
            return -1;
        }
        return (int)((versionX + versionY) / 2.0 + 0.5);
    }

    private boolean readVersionRegion0(QrCode qr) {
        this.gridReader.setSquare(qr.ppRight, (float)qr.threshRight);
        this.bits.resize(18);
        this.bits.zero();
        for (int i = 0; i < 18; ++i) {
            int row = i / 3;
            int col = i % 3;
            this.read(i, row, col - 4);
        }
        return true;
    }

    private boolean readVersionRegion1(QrCode qr) {
        this.gridReader.setSquare(qr.ppDown, (float)qr.threshDown);
        this.bits.resize(18);
        this.bits.zero();
        for (int i = 0; i < 18; ++i) {
            int row = i % 3;
            int col = i / 3;
            this.read(i, row - 4, col);
        }
        return true;
    }

    public QrCodeAlignmentPatternLocator<T> getAlignmentLocator() {
        return this.alignmentLocator;
    }

    public List<QrCode> getFound() {
        return this.successes;
    }

    public List<QrCode> getFailures() {
        return this.failures;
    }
}

