/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.fiducial.qrcode.QrCode;
import boofcv.alg.fiducial.qrcode.QrCodeBinaryGridToPixel;
import boofcv.alg.interpolate.InterpolatePixelDistortS;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.border.BorderType;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import org.ddogleg.struct.DogArray_F32;
import org.jetbrains.annotations.Nullable;

public class QrCodeBinaryGridReader<T extends ImageGray<T>> {
    public static final int BIT_INTENSITY_SAMPLES = 5;
    QrCodeBinaryGridToPixel transformGrid = new QrCodeBinaryGridToPixel();
    InterpolatePixelS<T> interpolate;
    Point2D_F32 pixel = new Point2D_F32();
    int imageWidth;
    int imageHeight;
    float threshold;
    @Nullable
    QrCode qr;

    public QrCodeBinaryGridReader(Class<T> imageType) {
        this.interpolate = FactoryInterpolation.nearestNeighborPixelS(imageType);
        this.interpolate.setBorder((ImageBorder<T>)FactoryImageBorder.single(BorderType.EXTENDED, imageType));
    }

    public void setImage(T image) {
        this.interpolate.setImage(image);
        this.imageWidth = ((ImageGray)image).width;
        this.imageHeight = ((ImageGray)image).height;
    }

    public void setLensDistortion(int width, int height, @Nullable LensDistortionNarrowFOV model) {
        this.interpolate = FactoryInterpolation.bilinearPixelS(this.interpolate.getImageType().getImageClass(), BorderType.EXTENDED);
        if (model != null) {
            Point2Transform2_F32 u2d = model.distort_F32(true, true);
            this.interpolate = new InterpolatePixelDistortS<T>(this.interpolate, u2d);
        }
    }

    public void setMarker(QrCode qr) {
        this.qr = qr;
        this.transformGrid.addAllFeatures(qr);
        this.transformGrid.removeOutsideCornerFeatures();
        this.transformGrid.computeTransform();
        this.threshold = (float)(qr.threshCorner + qr.threshDown + qr.threshRight) / 3.0f;
    }

    public void setSquare(Polygon2D_F64 square, float threshold) {
        this.qr = null;
        this.transformGrid.setTransformFromSquare(square);
        this.threshold = threshold;
    }

    public void setMarkerUnknownVersion(QrCode qr, float threshold) {
        this.qr = null;
        this.transformGrid.setTransformFromLinesSquare(qr);
        this.threshold = threshold;
    }

    public void imageToGrid(float x, float y, Point2D_F32 grid) {
        this.transformGrid.imageToGrid(x, y, grid);
    }

    public void imageToGrid(Point2D_F32 pixel, Point2D_F32 grid) {
        this.transformGrid.imageToGrid(pixel.x, pixel.y, grid);
    }

    public void imageToGrid(Point2D_F64 pixel, Point2D_F64 grid) {
        this.transformGrid.imageToGrid(pixel.x, pixel.y, grid);
    }

    public void gridToImage(float row, float col, Point2D_F32 image) {
        this.transformGrid.gridToImage(row, col, image);
    }

    public void gridToImage(double row, double col, Point2D_F64 image) {
        this.transformGrid.gridToImage((float)row, (float)col, this.pixel);
        image.x = this.pixel.x;
        image.y = this.pixel.y;
    }

    public float read(float row, float col) {
        this.transformGrid.gridToImage(row, col, this.pixel);
        return this.interpolate.get(this.pixel.x, this.pixel.y);
    }

    public void readBitIntensity(int row, int col, DogArray_F32 intensity) {
        float center = 0.5f;
        this.transformGrid.gridToImage((float)row + center - 0.2f, (float)col + center, this.pixel);
        intensity.add(this.interpolate.get(this.pixel.x, this.pixel.y));
        this.transformGrid.gridToImage((float)row + center + 0.2f, (float)col + center, this.pixel);
        intensity.add(this.interpolate.get(this.pixel.x, this.pixel.y));
        this.transformGrid.gridToImage((float)row + center, (float)col + center - 0.2f, this.pixel);
        intensity.add(this.interpolate.get(this.pixel.x, this.pixel.y));
        this.transformGrid.gridToImage((float)row + center, (float)col + center + 0.2f, this.pixel);
        intensity.add(this.interpolate.get(this.pixel.x, this.pixel.y));
        this.transformGrid.gridToImage((float)row + center, (float)col + center, this.pixel);
        intensity.add(this.interpolate.get(this.pixel.x, this.pixel.y));
    }

    public int readBit(int row, int col) {
        float center = 0.5f;
        this.transformGrid.gridToImage((float)row + center - 0.2f, (float)col + center, this.pixel);
        float pixel01 = this.interpolate.get(this.pixel.x, this.pixel.y);
        this.transformGrid.gridToImage((float)row + center + 0.2f, (float)col + center, this.pixel);
        float pixel21 = this.interpolate.get(this.pixel.x, this.pixel.y);
        this.transformGrid.gridToImage((float)row + center, (float)col + center - 0.2f, this.pixel);
        float pixel10 = this.interpolate.get(this.pixel.x, this.pixel.y);
        this.transformGrid.gridToImage((float)row + center, (float)col + center + 0.2f, this.pixel);
        float pixel12 = this.interpolate.get(this.pixel.x, this.pixel.y);
        this.transformGrid.gridToImage((float)row + center, (float)col + center, this.pixel);
        float pixel00 = this.interpolate.get(this.pixel.x, this.pixel.y);
        int total = 0;
        if (pixel01 < this.threshold) {
            ++total;
        }
        if (pixel21 < this.threshold) {
            ++total;
        }
        if (pixel10 < this.threshold) {
            ++total;
        }
        if (pixel12 < this.threshold) {
            ++total;
        }
        if (pixel00 < this.threshold) {
            ++total;
        }
        if (total >= 3) {
            return 1;
        }
        return 0;
    }

    public QrCodeBinaryGridToPixel getTransformGrid() {
        return this.transformGrid;
    }
}

