/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.microqr;

import boofcv.alg.fiducial.microqr.MicroQrCode;
import boofcv.alg.fiducial.microqr.MicroQrCodeMaskPattern;
import boofcv.alg.fiducial.qrcode.PackedBits32;
import boofcv.alg.fiducial.qrcode.QrCodeCodeWordLocations;
import boofcv.alg.fiducial.qrcode.QrGeneratorBase;
import georegression.struct.point.Point2D_I32;

public class MicroQrCodeGenerator
extends QrGeneratorBase<MicroQrCodeGenerator> {
    public MicroQrCodeGenerator render(MicroQrCode qr) {
        this.numModules = MicroQrCode.totalModules(qr.version);
        this.moduleWidth = this.markerWidth / (double)this.numModules;
        this.render.init();
        this.positionPattern(0.0, 0.0, qr.pp);
        qr.thresholdPP = 127.0;
        this.timingPattern(7.0 * this.moduleWidth, 0.0, this.moduleWidth, 0.0, this.numModules - 7);
        this.timingPattern(0.0, 7.0 * this.moduleWidth, 0.0, this.moduleWidth, this.numModules - 7);
        this.formatInformation(qr);
        if (this.renderData) {
            MicroQrCode.VersionInfo info = MicroQrCode.VERSION_INFO[qr.version];
            MicroQrCode.DataInfo data = info.levels(qr.error);
            int eccWords = info.codewords - data.dataCodewords;
            int dataBits = qr.getMaxDataBits();
            if (qr.rawbits.length != info.codewords) {
                throw new RuntimeException("Unexpected length of raw data.");
            }
            this.bitLocations = QrCodeCodeWordLocations.microqr((int)qr.version).bits;
            int numBytes = this.bitLocations.size() / 8 + (this.bitLocations.size() % 8 == 0 ? 0 : 1);
            if (numBytes != qr.rawbits.length) {
                throw new RuntimeException("Egads. unexpected length of qrcode raw data");
            }
            this.renderData(qr.mask, qr.rawbits, 0, 0, dataBits);
            this.renderData(qr.mask, qr.rawbits, data.dataCodewords, dataBits, eccWords * 8);
        }
        qr.bounds.set(0, 0.0, 0.0);
        qr.bounds.set(1, this.markerWidth, 0.0);
        qr.bounds.set(2, this.markerWidth, this.markerWidth);
        qr.bounds.set(3, 0.0, this.markerWidth);
        return this;
    }

    private void formatInformation(MicroQrCode qr) {
        PackedBits32 bits = MicroQrCodeGenerator.formatInformationBits(qr);
        for (int i = 0; i < 15; ++i) {
            if (bits.get(i) == 0) continue;
            if (i < 8) {
                this.square(i + 1, 8);
                continue;
            }
            this.square(8, 15 - i);
        }
    }

    static PackedBits32 formatInformationBits(MicroQrCode qr) {
        PackedBits32 bits = new PackedBits32(15);
        bits.data[0] = qr.encodeFormatBits();
        bits.data[0] = bits.data[0] ^ 0x4445;
        return bits;
    }

    private void renderData(MicroQrCodeMaskPattern mask, byte[] rawbits, int offsetByte, int offsetBits, int lengthBits) {
        for (int bitIdx = 0; bitIdx < lengthBits; bitIdx += 8) {
            int bits = rawbits[offsetByte + bitIdx / 8] & 0xFF;
            int N = Math.min(8, lengthBits - bitIdx);
            for (int i = 0; i < N; ++i) {
                Point2D_I32 coor = (Point2D_I32)this.bitLocations.get(offsetBits + bitIdx + i);
                int value = mask.apply(coor.y, coor.x, bits >> i & 1);
                if (value <= 0) continue;
                this.square(coor.y, coor.x);
            }
        }
    }
}

