/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.microqr;

import boofcv.alg.fiducial.microqr.MicroQrCodeMaskPattern;
import boofcv.alg.fiducial.qrcode.QrCode;
import boofcv.alg.fiducial.qrcode.QrCodeCodeWordLocations;
import boofcv.alg.fiducial.qrcode.QrCodePolynomialMath;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.point.Point2D_I32;
import georegression.struct.shapes.Polygon2D_F64;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.ejml.dense.fixed.CommonOps_DDF3;

public class MicroQrCode
implements Cloneable {
    public static final int FORMAT_MASK = 17477;
    public static final int MAX_VERSION = 4;
    public static final VersionInfo[] VERSION_INFO = new VersionInfo[5];
    public static final List<Point2D_I32>[] LOCATION_BITS = new ArrayList[5];
    public int version = -1;
    public ErrorLevel error = ErrorLevel.L;
    public Polygon2D_F64 pp = new Polygon2D_F64(4);
    public double thresholdPP;
    public QrCode.Mode mode = QrCode.Mode.UNKNOWN;
    public MicroQrCodeMaskPattern mask = MicroQrCodeMaskPattern.M00;
    public byte[] rawbits;
    public byte[] corrected;
    public String message = "";
    public Polygon2D_F64 bounds = new Polygon2D_F64(4);
    public Homography2D_F64 Hinv = new Homography2D_F64();
    public boolean bitsTransposed;
    public int totalBitErrors;
    public QrCode.Failure failureCause = QrCode.Failure.NONE;
    public static final QrCode.Mode[] allowedModes = new QrCode.Mode[]{QrCode.Mode.NUMERIC, QrCode.Mode.ALPHANUMERIC, QrCode.Mode.BYTE, QrCode.Mode.KANJI};

    public MicroQrCode() {
        this.reset();
    }

    public void reset() {
        for (int i = 0; i < 4; ++i) {
            this.pp.get(i).setTo(0.0, 0.0);
            this.bounds.get(i).setTo(0.0, 0.0);
        }
        this.thresholdPP = 0.0;
        this.version = -1;
        this.error = ErrorLevel.L;
        this.mask = MicroQrCodeMaskPattern.M00;
        this.mode = QrCode.Mode.UNKNOWN;
        this.rawbits = null;
        this.corrected = null;
        this.message = null;
        this.bitsTransposed = false;
        CommonOps_DDF3.setIdentity(this.Hinv);
        this.totalBitErrors = 0;
        this.failureCause = QrCode.Failure.NONE;
    }

    public MicroQrCode setTo(MicroQrCode o) {
        this.version = o.version;
        this.error = o.error;
        this.mask = o.mask;
        this.mode = o.mode;
        this.rawbits = o.rawbits == null ? null : (byte[])o.rawbits.clone();
        this.corrected = o.corrected == null ? null : (byte[])o.corrected.clone();
        this.message = o.message;
        this.bitsTransposed = o.bitsTransposed;
        this.pp.setTo(o.pp);
        this.thresholdPP = o.thresholdPP;
        this.failureCause = o.failureCause;
        this.bounds.setTo(o.bounds);
        this.Hinv.setTo(o.Hinv);
        this.totalBitErrors = o.totalBitErrors;
        return this;
    }

    public MicroQrCode clone() {
        return new MicroQrCode().setTo(this);
    }

    public int terminatorBits() {
        if (this.version < 1) {
            throw new IllegalArgumentException("Invalid version");
        }
        return 1 + this.version * 2;
    }

    public int encodeFormatBits() {
        int bits = this.encodeVersionAndEccLevel() << 2;
        return QrCodePolynomialMath.encodeFormatBits(bits |= this.mask.bits);
    }

    public boolean decodeFormatBits(int bits) {
        int corrected = QrCodePolynomialMath.correctFormatBits(bits);
        if (corrected < 0) {
            return false;
        }
        this.mask = MicroQrCodeMaskPattern.lookupMask(corrected & 3);
        return this.decodeVersionAndECC(corrected >> 2 & 7);
    }

    public int encodeVersionAndEccLevel() {
        int n;
        block0 : switch (this.version) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                switch (this.error) {
                    case L: {
                        n = 1;
                        break block0;
                    }
                    case M: {
                        n = 2;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Only L and M supported for version 2");
            }
            case 3: {
                switch (this.error) {
                    case L: {
                        n = 3;
                        break block0;
                    }
                    case M: {
                        n = 4;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Only L and M supported for version 3");
            }
            case 4: {
                switch (this.error) {
                    case L: {
                        n = 5;
                        break block0;
                    }
                    case M: {
                        n = 6;
                        break block0;
                    }
                    case Q: {
                        n = 7;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Unsupported error level " + this.error);
            }
            default: {
                throw new IllegalArgumentException("Only version 1 to 4 exist for Micro QR Code");
            }
        }
        return n;
    }

    public boolean decodeVersionAndECC(int code) {
        switch (code & 7) {
            case 0: {
                this.version = 1;
                break;
            }
            case 1: 
            case 2: {
                this.version = 2;
                break;
            }
            case 3: 
            case 4: {
                this.version = 3;
                break;
            }
            default: {
                this.version = 4;
            }
        }
        block5 : switch (this.version) {
            case 1: {
                this.error = ErrorLevel.DETECT;
                break;
            }
            case 2: {
                this.error = code == 1 ? ErrorLevel.L : ErrorLevel.M;
                break;
            }
            case 3: {
                this.error = code == 3 ? ErrorLevel.L : ErrorLevel.M;
                break;
            }
            case 4: {
                switch (code & 3) {
                    case 1: {
                        this.error = ErrorLevel.L;
                        break block5;
                    }
                    case 2: {
                        this.error = ErrorLevel.M;
                        break block5;
                    }
                    case 3: {
                        this.error = ErrorLevel.Q;
                        break block5;
                    }
                }
                return false;
            }
        }
        return true;
    }

    public int getNumberOfModules() {
        return MicroQrCode.totalModules(this.version);
    }

    public int getMaxDataBits() {
        return MicroQrCode.maxDataBits(this.version, this.error);
    }

    public static int totalModules(int version) {
        return version * 2 + 9;
    }

    public static int maxDataBits(int version, ErrorLevel level) {
        int bits = MicroQrCode.VERSION_INFO[version].levels((ErrorLevel)level).dataCodewords * 8;
        if (version == 1 || version == 3) {
            bits -= 4;
        }
        return bits;
    }

    public static ErrorLevel[] allowedErrorCorrection(int version) {
        ErrorLevel[] errorLevelArray;
        switch (version) {
            case 1: {
                ErrorLevel[] errorLevelArray2 = new ErrorLevel[1];
                errorLevelArray = errorLevelArray2;
                errorLevelArray2[0] = ErrorLevel.DETECT;
                break;
            }
            case 2: 
            case 3: {
                ErrorLevel[] errorLevelArray3 = new ErrorLevel[2];
                errorLevelArray3[0] = ErrorLevel.M;
                errorLevelArray = errorLevelArray3;
                errorLevelArray3[1] = ErrorLevel.L;
                break;
            }
            case 4: {
                ErrorLevel[] errorLevelArray4 = new ErrorLevel[3];
                errorLevelArray4[0] = ErrorLevel.Q;
                errorLevelArray4[1] = ErrorLevel.M;
                errorLevelArray = errorLevelArray4;
                errorLevelArray4[2] = ErrorLevel.L;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal version=" + version);
            }
        }
        return errorLevelArray;
    }

    public static int modeIndicatorBitCount(int version) {
        if (version < 1 || version > 4) {
            throw new IllegalArgumentException("Invalid version " + version);
        }
        return version - 1;
    }

    public static QrCode.Mode[] allowedModes(int version) {
        QrCode.Mode[] modeArray;
        switch (version) {
            case 1: {
                QrCode.Mode[] modeArray2 = new QrCode.Mode[1];
                modeArray = modeArray2;
                modeArray2[0] = QrCode.Mode.NUMERIC;
                break;
            }
            case 2: {
                QrCode.Mode[] modeArray3 = new QrCode.Mode[2];
                modeArray3[0] = QrCode.Mode.NUMERIC;
                modeArray = modeArray3;
                modeArray3[1] = QrCode.Mode.ALPHANUMERIC;
                break;
            }
            default: {
                modeArray = QrCode.Mode.values();
            }
        }
        return modeArray;
    }

    public static QrCode.Mode valueToMode(int value) {
        if (value < 0 || value > 3) {
            return QrCode.Mode.UNKNOWN;
        }
        return allowedModes[value];
    }

    public int getNumberOfDataCodeWords() {
        return MicroQrCode.VERSION_INFO[this.version].levels((ErrorLevel)this.error).dataCodewords;
    }

    public int getNumberOfErrorCodeWords() {
        return MicroQrCode.VERSION_INFO[this.version].codewords - MicroQrCode.VERSION_INFO[this.version].levels((ErrorLevel)this.error).dataCodewords;
    }

    static {
        MicroQrCode.VERSION_INFO[1] = new VersionInfo(5);
        VERSION_INFO[1].add(ErrorLevel.DETECT, 3);
        MicroQrCode.VERSION_INFO[2] = new VersionInfo(10);
        VERSION_INFO[2].add(ErrorLevel.L, 5);
        VERSION_INFO[2].add(ErrorLevel.M, 4);
        MicroQrCode.VERSION_INFO[3] = new VersionInfo(17);
        VERSION_INFO[3].add(ErrorLevel.L, 11);
        VERSION_INFO[3].add(ErrorLevel.M, 9);
        MicroQrCode.VERSION_INFO[4] = new VersionInfo(24);
        VERSION_INFO[4].add(ErrorLevel.L, 16);
        VERSION_INFO[4].add(ErrorLevel.M, 14);
        VERSION_INFO[4].add(ErrorLevel.Q, 10);
        for (int version = 1; version <= 4; ++version) {
            MicroQrCode.LOCATION_BITS[version] = QrCodeCodeWordLocations.microqr((int)version).bits;
        }
    }

    public static enum ErrorLevel {
        DETECT,
        L,
        M,
        Q;


        public static ErrorLevel lookup(String letter) {
            ErrorLevel errorLevel;
            switch (letter) {
                case "L": {
                    errorLevel = L;
                    break;
                }
                case "M": {
                    errorLevel = M;
                    break;
                }
                case "Q": {
                    errorLevel = Q;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown");
                }
            }
            return errorLevel;
        }
    }

    public static class VersionInfo {
        public final int codewords;
        public final Map<ErrorLevel, DataInfo> levels = new HashMap<ErrorLevel, DataInfo>();

        public VersionInfo(int codewords) {
            this.codewords = codewords;
        }

        public DataInfo levels(ErrorLevel level) {
            return Objects.requireNonNull(this.levels.get((Object)level));
        }

        public void add(ErrorLevel level, int dataCodewords) {
            this.levels.put(level, new DataInfo(dataCodewords));
        }
    }

    public static class DataInfo {
        public final int dataCodewords;

        public DataInfo(int dataCodewords) {
            this.dataCodewords = dataCodewords;
        }
    }
}

