/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.squares;

import boofcv.alg.fiducial.calib.squares.SquareEdge;
import boofcv.alg.fiducial.calib.squares.SquareGraph;
import boofcv.alg.fiducial.calib.squares.SquareNode;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.DogArray;

public class SquaresIntoClusters {
    protected DogArray<SquareNode> nodes = new DogArray<SquareNode>(SquareNode::new);
    protected DogArray<List<SquareNode>> clusters = new DogArray<Object>(ArrayList::new);
    protected List<SquareNode> open = new ArrayList<SquareNode>();
    protected SquareGraph graph = new SquareGraph();

    protected void recycleData() {
        int j;
        SquareNode n;
        int i;
        for (i = 0; i < this.nodes.size(); ++i) {
            n = (SquareNode)this.nodes.get(i);
            for (j = 0; j < n.edges.length; ++j) {
                if (n.edges[j] == null) continue;
                this.graph.detachEdge(n.edges[j]);
            }
        }
        for (i = 0; i < this.nodes.size(); ++i) {
            n = (SquareNode)this.nodes.get(i);
            for (j = 0; j < n.edges.length; ++j) {
                if (n.edges[j] == null) continue;
                throw new RuntimeException("BUG!");
            }
        }
        this.nodes.reset();
        for (i = 0; i < this.clusters.size; ++i) {
            ((List)this.clusters.get(i)).clear();
        }
        this.clusters.reset();
    }

    protected void findClusters() {
        for (int i = 0; i < this.nodes.size(); ++i) {
            SquareNode n = (SquareNode)this.nodes.get(i);
            if (n.graph >= 0) continue;
            n.graph = this.clusters.size();
            List<SquareNode> graph = this.clusters.grow();
            graph.add(n);
            this.addToCluster(n, graph);
        }
    }

    void addToCluster(SquareNode seed, List<SquareNode> graph) {
        this.open.clear();
        this.open.add(seed);
        while (!this.open.isEmpty()) {
            SquareNode n = this.open.remove(this.open.size() - 1);
            for (int i = 0; i < n.square.size(); ++i) {
                SquareNode other;
                SquareEdge edge = n.edges[i];
                if (edge == null) continue;
                if (edge.a == n) {
                    other = edge.b;
                } else if (edge.b == n) {
                    other = edge.a;
                } else {
                    throw new RuntimeException("BUG!");
                }
                if (other.graph == -2) {
                    other.graph = n.graph;
                    graph.add(other);
                    this.open.add(other);
                    continue;
                }
                if (other.graph == n.graph) continue;
                throw new RuntimeException("BUG! " + other.graph + " " + n.graph);
            }
        }
    }
}

