/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.squares;

import boofcv.alg.fiducial.calib.squares.SquareEdge;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import org.ddogleg.nn.alg.KdTreeDistance;
import org.ddogleg.struct.DogArray_B;
import org.jetbrains.annotations.Nullable;

public class SquareNode {
    public static final int RESET_GRAPH = -2;
    public Polygon2D_F64 square;
    public DogArray_B touch;
    public Point2D_F64 center = new Point2D_F64();
    public double[] sideLengths = new double[4];
    public double largestSide;
    public double smallestSide;
    public int graph;
    public SquareEdge[] edges = new SquareEdge[4];

    public double distanceSqCorner(Point2D_F64 p) {
        double best = Double.MAX_VALUE;
        for (int i = 0; i < 4; ++i) {
            double d = this.square.get(i).distance2(p);
            if (!(d < best)) continue;
            best = d;
        }
        return best;
    }

    public void reset() {
        this.square = null;
        this.touch = null;
        this.center.setTo(-1.0, -1.0);
        this.largestSide = 0.0;
        this.smallestSide = Double.MAX_VALUE;
        this.graph = -2;
        for (int i = 0; i < this.edges.length; ++i) {
            this.edges[i] = null;
            this.sideLengths[i] = 0.0;
        }
    }

    public void updateArrayLength() {
        if (this.edges.length != this.square.size()) {
            this.edges = new SquareEdge[this.square.size()];
            this.sideLengths = new double[this.square.size()];
        }
    }

    public int getNumberOfConnections() {
        int ret = 0;
        for (int i = 0; i < this.square.size(); ++i) {
            if (this.edges[i] == null) continue;
            ++ret;
        }
        return ret;
    }

    public double smallestSideLength() {
        double smallest = Double.MAX_VALUE;
        for (int i = 0; i < this.square.size(); ++i) {
            double length = this.sideLengths[i];
            if (!(length < smallest)) continue;
            smallest = length;
        }
        return smallest;
    }

    @Nullable
    public SquareEdge findEdge(SquareNode target) {
        int index = this.findEdgeIndex(target);
        if (index >= 0) {
            return this.edges[index];
        }
        return null;
    }

    public int findEdgeIndex(SquareNode target) {
        for (int i = 0; i < 4; ++i) {
            if (this.edges[i] == null || !this.edges[i].isEndPoint(target)) continue;
            return i;
        }
        return -1;
    }

    public static class KdTreeSquareNode
    implements KdTreeDistance<SquareNode> {
        @Override
        public double distance(SquareNode a, SquareNode b) {
            return a.center.distance2(b.center);
        }

        @Override
        public double valueAt(SquareNode point, int index) {
            switch (index) {
                case 0: {
                    return point.center.x;
                }
                case 1: {
                    return point.center.y;
                }
            }
            throw new IllegalArgumentException("Out of bounds. " + index);
        }

        @Override
        public int length() {
            return 2;
        }
    }
}

