/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.ecocheck;

import boofcv.abst.fiducial.calib.ConfigChessboardX;
import boofcv.alg.feature.detect.chess.ChessboardCorner;
import boofcv.alg.feature.detect.chess.DetectChessboardCornersXPyramid;
import boofcv.alg.fiducial.calib.chess.ChessboardCornerClusterFinder;
import boofcv.alg.fiducial.calib.chess.ChessboardCornerClusterToGrid;
import boofcv.alg.fiducial.calib.chess.ChessboardCornerGraph;
import boofcv.alg.fiducial.calib.ecocheck.CellValue;
import boofcv.alg.fiducial.calib.ecocheck.ECoCheckFound;
import boofcv.alg.fiducial.calib.ecocheck.ECoCheckUtils;
import boofcv.alg.fiducial.qrcode.PackedBits8;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.GridCoordinate;
import boofcv.struct.border.BorderType;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.line.LineSegment2D_F64;
import georegression.struct.point.Point2D_F64;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F32;
import org.ddogleg.struct.FastArray;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public class ECoCheckDetector<T extends ImageGray<T>>
implements VerbosePrint {
    final int NUM_SAMPLES_SIDE = 5;
    public int whiteBorderSampleCount = 5;
    public double maxWhiteBorderFailFraction = 0.3;
    protected ECoCheckUtils utils;
    protected DetectChessboardCornersXPyramid<T> detector;
    protected ChessboardCornerClusterFinder<T> clusterFinder;
    protected ChessboardCornerClusterToGrid clusterToGrid = new ChessboardCornerClusterToGrid();
    public InterpolatePixelS<T> interpolate;
    public final DogArray<ECoCheckFound> found = new DogArray<ECoCheckFound>(ECoCheckFound::new, ECoCheckFound::reset);
    FastArray<CellReading> gridBinaryCells = new FastArray<CellReading>(CellReading.class);
    DogArray<CellReading> binaryCells = new DogArray<CellReading>(CellReading::new, CellReading::reset);
    DogArray<Point2D_F64> samplePixels = new DogArray<Point2D_F64>(Point2D_F64::new);
    DogArray_F32 sampleValues = new DogArray_F32();
    PackedBits8 bits = new PackedBits8();
    GrayU8 bitImage = new GrayU8(1, 1);
    GrayU8 workImage = new GrayU8(1, 1);
    GrayU8 cornersAroundBinary = new GrayU8(1, 1);
    DogArray<Transform> transforms = new DogArray<Transform>(Transform::new, Transform::reset);
    ChessboardCornerClusterToGrid.GridInfo anonymousInfo = new ChessboardCornerClusterToGrid.GridInfo();
    CellValue decoded = new CellValue();
    GridCoordinate decodedCoordinate = new GridCoordinate();
    GridCoordinate observedCoordinate = new GridCoordinate();
    LineSegment2D_F64 lineBlack = new LineSegment2D_F64();
    LineSegment2D_F64 lineWhite = new LineSegment2D_F64();
    Point2D_F64 pixel = new Point2D_F64();
    @Nullable
    PrintStream verbose;
    boolean runtimeProfiling;
    double timeCornerDetectorMS;
    double timeClusteringMS;
    double timeGridMS;
    double timeDecodingMS;
    double timeAllMS = 0.0;

    public ECoCheckDetector(ECoCheckUtils utils, ConfigChessboardX config, Class<T> imageType) {
        this.utils = utils;
        this.utils.checkFixate();
        this.detector = new DetectChessboardCornersXPyramid<T>(ImageType.single(imageType));
        this.clusterFinder = new ChessboardCornerClusterFinder<T>(imageType);
        this.detector.setPyramidTopSize(config.detPyramidTopSize);
        this.detector.getDetector().setNonmaxRadius(config.detNonMaxRadius);
        this.detector.getDetector().setNonmaxThresholdRatio((float)config.detNonMaxThresholdRatio);
        this.detector.getDetector().setRefinedXCornerThreshold(config.detRefinedXCornerThreshold);
        this.clusterFinder.setAmbiguousTol(config.connAmbiguousTol);
        this.clusterFinder.setDirectionTol(config.connDirectionTol);
        this.clusterFinder.setOrientationTol(config.connOrientationTol);
        this.clusterFinder.setMaxNeighbors(config.connMaxNeighbors);
        this.clusterFinder.setMaxNeighborDistance(config.connMaxNeighborDistance);
        this.clusterFinder.setThresholdEdgeIntensity(config.connEdgeThreshold);
        this.interpolate = FactoryInterpolation.createPixelS(0.0, 255.0, InterpolationType.NEAREST_NEIGHBOR, BorderType.EXTENDED, imageType);
        this.bitImage.reshape(utils.codec.gridBitLength, utils.codec.gridBitLength);
    }

    public void process(T input) {
        this.timeCornerDetectorMS = 0.0;
        this.timeClusteringMS = 0.0;
        this.timeGridMS = 0.0;
        this.timeDecodingMS = 0.0;
        this.timeAllMS = 0.0;
        this.found.reset();
        this.interpolate.setImage(input);
        long time0 = System.nanoTime();
        this.detector.process(input);
        long time1 = System.nanoTime();
        this.timeCornerDetectorMS = (double)(time1 - time0) * 1.0E-6;
        this.clusterFinder.process(input, this.detector.getCorners().toList(), this.detector.getNumberOfLevels());
        DogArray<ChessboardCornerGraph> clusters = this.clusterFinder.getOutputClusters();
        long time2 = System.nanoTime();
        this.timeClusteringMS = (double)(time2 - time1) * 1.0E-6;
        for (int clusterIdx = 0; clusterIdx < clusters.size; ++clusterIdx) {
            long timeGrid0 = System.nanoTime();
            if (!this.clusterToGrid.clusterToSparse((ChessboardCornerGraph)clusters.get(clusterIdx))) continue;
            this.clusterToGrid.sparseToDense();
            long timeGrid1 = System.nanoTime();
            this.timeGridMS += (double)(timeGrid1 - timeGrid0) * 1.0E-6;
            this.decodeBinaryPatterns();
            this.timeDecodingMS += (double)(System.nanoTime() - timeGrid1) * 1.0E-6;
            if (this.binaryCells.isEmpty()) {
                this.createAnonymousTarget();
                continue;
            }
            this.tallyMarkerVotes();
            if (this.transforms.size > 1) {
                Collections.sort(this.transforms.toList(), (a, b) -> Integer.compare(b.votes, a.votes));
            }
            for (int transformIdx = 0; transformIdx < this.transforms.size; ++transformIdx) {
                Transform t = (Transform)this.transforms.get(transformIdx);
                if (this.createCorrectedTarget(t, this.found.grow())) continue;
                this.found.removeTail();
            }
        }
        this.timeAllMS = (double)(System.nanoTime() - time0) * 1.0E-6;
        if (this.verbose != null && this.runtimeProfiling) {
            this.verbose.printf("time (ms): all=%.1f corners=%.1f cluster=%.1f grid=%.1f decode=%.1f\n", this.timeAllMS, this.timeCornerDetectorMS, this.timeClusteringMS, this.timeGridMS, this.timeDecodingMS);
        }
    }

    private void decodeBinaryPatterns() {
        int rows = this.clusterToGrid.getSparseRows();
        int cols = this.clusterToGrid.getSparseCols();
        this.cornersAroundBinary.reshape(cols, rows);
        ImageMiscOps.fill(this.cornersAroundBinary, 0);
        this.gridBinaryCells.clear();
        this.gridBinaryCells.resize(rows * cols);
        this.binaryCells.reset();
        if (this.verbose != null) {
            this.verbose.printf("corner grid: shape=( %d %d ) size=%d\n", rows, cols, this.clusterToGrid.getSparseGrid().size);
        }
        for (int row = 1; row < rows; ++row) {
            for (int col = 1; col < cols; ++col) {
                ChessboardCornerClusterToGrid.GridElement a = this.clusterToGrid.getDense(row - 1, col - 1);
                ChessboardCornerClusterToGrid.GridElement b = this.clusterToGrid.getDense(row - 1, col);
                ChessboardCornerClusterToGrid.GridElement c = this.clusterToGrid.getDense(row, col);
                ChessboardCornerClusterToGrid.GridElement d = this.clusterToGrid.getDense(row, col - 1);
                if (a == null || b == null || c == null || d == null || !this.clusterToGrid.isWhiteSquareOrientation(a.node, c.node) || !this.utils.computeGridToImage(a.node.corner, b.node.corner, c.node.corner, d.node.corner) || !this.isBorderWhite(a.node.corner, b.node.corner, c.node.corner, d.node.corner)) continue;
                this.utils.selectPixelsToSample(this.samplePixels);
                this.samplePixelGray(this.samplePixels.toList(), this.sampleValues);
                float threshold = this.utils.otsuThreshold(this.sampleValues);
                if (!this.graySamplesToBits(this.sampleValues, this.utils.bitSampleCount, threshold)) continue;
                boolean success = false;
                for (int orientation = 0; orientation < 4; ++orientation) {
                    this.convertBitImageToBitArray();
                    if (this.decodeAndSanityCheck()) {
                        success = true;
                        this.cornersAroundBinary.unsafe_set(col - 1, row - 1, 1);
                        this.cornersAroundBinary.unsafe_set(col - 1, row, 1);
                        this.cornersAroundBinary.unsafe_set(col, row - 1, 1);
                        this.cornersAroundBinary.unsafe_set(col, row, 1);
                        CellReading cellReading = this.binaryCells.grow();
                        ((CellReading[])this.gridBinaryCells.data)[row * cols + col] = cellReading;
                        CellReading cell = cellReading;
                        cell.row = row - 1;
                        cell.col = col - 1;
                        cell.orientation = orientation;
                        cell.markerID = this.decoded.markerID;
                        cell.cellID = this.decoded.cellID;
                        if (this.verbose == null) break;
                        this.utils.cellIdToCornerCoordinate(cell.markerID, cell.cellID, this.decodedCoordinate);
                        this.verbose.printf("marker=%d id=%d ori=%d code_grid=( %d %d ) obs_grid=( %d %d ) tl=( %.1f %.1f ) tr=( %.1f %.1f )\n", this.decoded.markerID, this.decoded.cellID, orientation, this.decodedCoordinate.row, this.decodedCoordinate.col, row - 1, col - 1, a.node.corner.x, a.node.corner.y, b.node.corner.x, b.node.corner.y);
                        break;
                    }
                    ImageMiscOps.rotateCCW(this.bitImage, this.workImage);
                    this.bitImage.setTo(this.workImage);
                }
                if (this.verbose == null || success) continue;
                this.verbose.printf("Failed to decode. obs_grid=(%d %d) tl=( %.1f %.1f ) thresh=%.1f\n", row - 1, col - 1, a.node.corner.x, a.node.corner.y, Float.valueOf(threshold));
            }
        }
    }

    private boolean decodeAndSanityCheck() {
        int maxCellID;
        boolean success = false;
        if (this.utils.codec.decode(this.bits, this.decoded)) {
            success = true;
        }
        if (success && this.decoded.markerID >= this.utils.markers.size()) {
            success = false;
            if (this.verbose != null) {
                this.verbose.println("Success decoding a cell, but markerID was invalid!");
            }
        }
        if (success && this.decoded.cellID >= (maxCellID = this.utils.countEncodedSquaresInMarker(this.decoded.markerID))) {
            if (this.verbose != null) {
                this.verbose.println("Success decoding a cell, but cellID was invalid!");
            }
            success = false;
        }
        return success;
    }

    void convertBitImageToBitArray() {
        this.bits.resize(this.bitImage.width * this.bitImage.height);
        int i = 0;
        for (int y = 0; y < this.bitImage.height; ++y) {
            int x = 0;
            while (x < this.bitImage.width) {
                this.bits.set(this.utils.bitOrder.get(i), this.bitImage.data[i]);
                ++x;
                ++i;
            }
        }
    }

    float sampleInnerWhite(Point2D_F64 a, Point2D_F64 b) {
        double border = this.utils.dataBorderFraction;
        double length = 1.0 - 2.0 * border;
        float nx = (float)(0.5 * (b.x - a.x) * this.utils.dataBorderFraction);
        float ny = (float)(0.5 * (b.y - a.y) * this.utils.dataBorderFraction);
        float sumWhite = 0.0f;
        float sumBlack = 0.0f;
        for (int i = 0; i < 5; ++i) {
            double f = border + length * (double)i / 4.0;
            float cx = (float)(a.x + (b.x - a.x) * f);
            float cy = (float)(a.y + (b.y - a.y) * f);
            sumWhite += this.interpolate.get(cx - ny, cy + nx);
            sumBlack += this.interpolate.get(cx + ny, cy - nx);
        }
        return (sumWhite + sumBlack) / 10.0f;
    }

    void samplePixelGray(List<Point2D_F64> samplePoints, DogArray_F32 sampleValues) {
        sampleValues.resize(samplePoints.size());
        for (int i = 0; i < samplePoints.size(); ++i) {
            Point2D_F64 pixel = samplePoints.get(i);
            sampleValues.data[i] = this.interpolate.get((float)pixel.x, (float)pixel.y);
        }
    }

    boolean isBorderWhite(ChessboardCorner a, ChessboardCorner b, ChessboardCorner c, ChessboardCorner d) {
        boolean success;
        if (this.whiteBorderSampleCount <= 0) {
            return true;
        }
        int failures = 0;
        failures += this.sampleWhiteSide(a, b, 0);
        failures += this.sampleWhiteSide(b, c, 1);
        failures += this.sampleWhiteSide(c, d, 2);
        boolean bl = success = (double)(failures += this.sampleWhiteSide(d, a, 3)) <= (double)(4 * this.whiteBorderSampleCount) * this.maxWhiteBorderFailFraction;
        if (!success && this.verbose != null) {
            this.verbose.println("FAILED: white border test: " + failures + " / " + 4 * this.whiteBorderSampleCount);
        }
        return success;
    }

    int sampleWhiteSide(ChessboardCorner a, ChessboardCorner b, int corner) {
        double r = this.utils.dataBorderFraction;
        switch (corner) {
            case 0: {
                this.utils.gridToPixel(r, r, this.lineWhite.a);
                this.utils.gridToPixel(1.0 - r, r, this.lineWhite.b);
                this.utils.gridToPixel(r, -r, this.lineBlack.a);
                this.utils.gridToPixel(1.0 - r, -r, this.lineBlack.b);
                break;
            }
            case 1: {
                this.utils.gridToPixel(1.0 - r, r, this.lineWhite.a);
                this.utils.gridToPixel(1.0 - r, 1.0 - r, this.lineWhite.b);
                this.utils.gridToPixel(1.0 + r, r, this.lineBlack.a);
                this.utils.gridToPixel(1.0 + r, 1.0 - r, this.lineBlack.b);
                break;
            }
            case 2: {
                this.utils.gridToPixel(1.0 - r, 1.0 - r, this.lineWhite.a);
                this.utils.gridToPixel(r, 1.0 - r, this.lineWhite.b);
                this.utils.gridToPixel(1.0 - r, 1.0 + r, this.lineBlack.a);
                this.utils.gridToPixel(r, 1.0 + r, this.lineBlack.b);
                break;
            }
            case 3: {
                this.utils.gridToPixel(r, 1.0 - r, this.lineWhite.a);
                this.utils.gridToPixel(r, r, this.lineWhite.b);
                this.utils.gridToPixel(-r, 1.0 - r, this.lineBlack.a);
                this.utils.gridToPixel(-r, r, this.lineBlack.b);
            }
        }
        double blurPaddingA = Math.pow(2.0, a.levelMax);
        double blurPaddingB = Math.pow(2.0, b.levelMax);
        double slopeX = this.lineWhite.slopeX();
        double slopeY = this.lineWhite.slopeY();
        double n = Math.sqrt(slopeX * slopeX + slopeY * slopeY);
        double fractionStart = blurPaddingA / n;
        double fractionEnd = 1.0 - blurPaddingB / n;
        if (fractionEnd < fractionStart) {
            fractionStart = 0.45;
            fractionEnd = 0.55;
        }
        int failed = 0;
        for (int i = 0; i < this.whiteBorderSampleCount; ++i) {
            double f = (fractionEnd - fractionStart) * (double)i / (double)(this.whiteBorderSampleCount - 1) + fractionStart;
            this.pixel.x = (this.lineBlack.b.x - this.lineBlack.a.x) * f + this.lineBlack.a.x;
            this.pixel.y = (this.lineBlack.b.y - this.lineBlack.a.y) * f + this.lineBlack.a.y;
            float blackValue = this.interpolate.get((float)this.pixel.x, (float)this.pixel.y);
            this.pixel.x = (this.lineWhite.b.x - this.lineWhite.a.x) * f + this.lineWhite.a.x;
            this.pixel.y = (this.lineWhite.b.y - this.lineWhite.a.y) * f + this.lineWhite.a.y;
            float whiteValue = this.interpolate.get((float)this.pixel.x, (float)this.pixel.y);
            if (!(whiteValue <= blackValue)) continue;
            ++failed;
        }
        return failed;
    }

    boolean graySamplesToBits(DogArray_F32 sampleValues, int blockSize, float threshold) {
        BoofMiscOps.checkEq(this.bitImage.width * this.bitImage.height, sampleValues.size() / blockSize);
        int majority = blockSize / 2;
        int nonWhiteBits = 0;
        int i = 0;
        int bit = 0;
        while (i < sampleValues.size()) {
            int vote = 0;
            for (int blockIdx = 0; blockIdx < blockSize; ++blockIdx) {
                float value = sampleValues.get(i + blockIdx);
                if (!(value <= threshold)) continue;
                ++vote;
            }
            int value = vote > majority ? 1 : 0;
            nonWhiteBits += value;
            this.bitImage.data[bit] = (byte)value;
            i += blockSize;
            ++bit;
        }
        return nonWhiteBits != 0;
    }

    void tallyMarkerVotes() {
        int numRows = this.clusterToGrid.getSparseRows();
        int numCols = this.clusterToGrid.getSparseCols();
        this.transforms.reset();
        for (int cellIdx = 0; cellIdx < this.binaryCells.size; ++cellIdx) {
            CellReading cell = (CellReading)this.binaryCells.get(cellIdx);
            this.utils.cellIdToCornerCoordinate(cell.markerID, cell.cellID, this.decodedCoordinate);
            ECoCheckUtils.rotateObserved(numRows, numCols, cell.row, cell.col, cell.orientation, this.observedCoordinate);
            ECoCheckUtils.adjustTopLeft(cell.orientation, this.observedCoordinate);
            int offsetRow = this.decodedCoordinate.row - this.observedCoordinate.row;
            int offsetCol = this.decodedCoordinate.col - this.observedCoordinate.col;
            Transform t = this.findMatching(offsetRow, offsetCol, cell.orientation, cell.markerID);
            if (t == null) {
                t = this.transforms.grow();
                t.offsetRow = offsetRow;
                t.offsetCol = offsetCol;
                t.marker = cell.markerID;
                t.orientation = cell.orientation;
            }
            ++t.votes;
        }
    }

    @Nullable
    Transform findMatching(int offsetRow, int offsetCol, int orientation, int marker) {
        for (int i = 0; i < this.transforms.size; ++i) {
            Transform t = (Transform)this.transforms.get(i);
            if (t.marker != marker || t.offsetRow != offsetRow || t.offsetCol != offsetCol || t.orientation != orientation) continue;
            return t;
        }
        return null;
    }

    boolean createCorrectedTarget(Transform transform, ECoCheckFound target) {
        if (this.verbose != null) {
            this.verbose.printf("transform: votes=%d marker=%d ori=%d offset={ row=%d col=%d }\n", transform.votes, transform.marker, transform.orientation, transform.offsetRow, transform.offsetCol);
        }
        target.markerID = transform.marker;
        target.squareRows = this.utils.markers.get((int)target.markerID).rows;
        target.squareCols = this.utils.markers.get((int)target.markerID).cols;
        for (int i = 0; i < this.binaryCells.size; ++i) {
            target.decodedCells.add(((CellReading)this.binaryCells.get((int)i)).cellID);
        }
        GridCoordinate correctedCoordinate = this.observedCoordinate;
        int cornerRows = target.squareRows - 1;
        int cornerCols = target.squareCols - 1;
        DogArray<ChessboardCornerClusterToGrid.GridElement> sparseGrid = this.clusterToGrid.getSparseGrid();
        for (int i = 0; i < sparseGrid.size; ++i) {
            ChessboardCornerClusterToGrid.GridElement e = (ChessboardCornerClusterToGrid.GridElement)sparseGrid.get(i);
            ECoCheckUtils.rotateObserved(cornerRows, cornerCols, e.row, e.col, transform.orientation, correctedCoordinate);
            correctedCoordinate.row += transform.offsetRow;
            correctedCoordinate.col += transform.offsetCol;
            if (correctedCoordinate.row < 0 || correctedCoordinate.col < 0 || correctedCoordinate.row >= cornerRows || correctedCoordinate.col >= cornerCols) continue;
            if (e.marked) {
                return false;
            }
            e.marked = true;
            int cornerID = correctedCoordinate.row * cornerCols + correctedCoordinate.col;
            target.addCorner(e.node.corner, cornerID);
            target.touchBinary.add(this.cornersAroundBinary.get(e.col, e.row) != 0);
        }
        return true;
    }

    void createAnonymousTarget() {
        if (!this.clusterToGrid.sparseToGrid(this.anonymousInfo)) {
            return;
        }
        ECoCheckFound target = this.found.grow();
        target.squareRows = this.anonymousInfo.rows + 1;
        target.squareCols = this.anonymousInfo.cols + 1;
        for (int cornerID = 0; cornerID < this.anonymousInfo.nodes.size(); ++cornerID) {
            ChessboardCornerGraph.Node n = this.anonymousInfo.nodes.get(cornerID);
            target.addCorner(n.corner, cornerID);
        }
    }

    public ImageType<T> getImageType() {
        return this.detector.getImageType();
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix(this, out);
        BoofMiscOps.verboseChildren(out, configuration, this.clusterFinder, this.clusterToGrid);
        if (configuration == null) {
            return;
        }
        this.runtimeProfiling = configuration.contains("runtime");
    }

    public ECoCheckUtils getUtils() {
        return this.utils;
    }

    public DetectChessboardCornersXPyramid<T> getDetector() {
        return this.detector;
    }

    public ChessboardCornerClusterFinder<T> getClusterFinder() {
        return this.clusterFinder;
    }

    public ChessboardCornerClusterToGrid getClusterToGrid() {
        return this.clusterToGrid;
    }

    public DogArray<ECoCheckFound> getFound() {
        return this.found;
    }

    public double getTimeCornerDetectorMS() {
        return this.timeCornerDetectorMS;
    }

    public double getTimeClusteringMS() {
        return this.timeClusteringMS;
    }

    public double getTimeGridMS() {
        return this.timeGridMS;
    }

    public double getTimeDecodingMS() {
        return this.timeDecodingMS;
    }

    public double getTimeAllMS() {
        return this.timeAllMS;
    }

    static class CellReading {
        public int row;
        public int col;
        public int orientation;
        public int markerID;
        public int cellID;

        CellReading() {
        }

        public void reset() {
            this.row = 0;
            this.col = 0;
            this.orientation = -1;
            this.markerID = -1;
            this.cellID = -1;
        }
    }

    static class Transform {
        public int offsetRow;
        public int offsetCol;
        public int orientation;
        public int marker;
        public int votes;

        Transform() {
        }

        public void setTo(int offsetRow, int offsetCol, int orientation, int marker, int votes) {
            this.offsetRow = offsetRow;
            this.offsetCol = offsetCol;
            this.orientation = orientation;
            this.marker = marker;
            this.votes = votes;
        }

        public void reset() {
            this.offsetRow = 0;
            this.offsetCol = 0;
            this.orientation = 0;
            this.votes = 0;
            this.marker = -1;
        }
    }
}

