/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.line;

import boofcv.struct.feature.MatrixOfList;
import georegression.metric.UtilAngle;
import georegression.struct.line.LineSegment2D_F32;
import georegression.struct.point.Point2D_F32;
import java.util.Iterator;
import java.util.List;

public class ConnectLinesGrid {
    float lineSlopeAngleTol;
    float parallelTol;
    float tangentTol;
    float[] dist = new float[4];
    int closestIndex;
    int farthestIndex;
    MatrixOfList<LineSegment2D_F32> grid;

    public ConnectLinesGrid(double lineSlopeAngleTol, double tangentTol, double parallelTol) {
        this.lineSlopeAngleTol = (float)lineSlopeAngleTol;
        this.tangentTol = (float)tangentTol;
        this.parallelTol = (float)parallelTol;
    }

    public void process(MatrixOfList<LineSegment2D_F32> grid) {
        int j;
        int i;
        this.grid = grid;
        for (i = 0; i < grid.height; ++i) {
            for (j = 0; j < grid.width; ++j) {
                this.connectInSameElement(grid.get(j, i));
            }
        }
        for (i = 0; i < grid.height; ++i) {
            for (j = 0; j < grid.width; ++j) {
                this.connectToNeighbors(j, i);
            }
        }
    }

    private void connectToNeighbors(int x, int y) {
        List<LineSegment2D_F32> lines = this.grid.get(x, y);
        Iterator<LineSegment2D_F32> iter = lines.iterator();
        while (iter.hasNext()) {
            LineSegment2D_F32 l = iter.next();
            boolean connected = this.connectTry(l, x + 1, y);
            if (!connected && this.connectTry(l, x + 1, y + 1)) {
                connected = true;
            }
            if (!connected && this.connectTry(l, x, y + 1)) {
                connected = true;
            }
            if (!connected && this.connectTry(l, x - 1, y + 1)) {
                connected = true;
            }
            if (!connected) continue;
            iter.remove();
        }
    }

    private boolean connectTry(LineSegment2D_F32 target, int x, int y) {
        if (!this.grid.isInBounds(x, y)) {
            return false;
        }
        List<LineSegment2D_F32> lines = this.grid.get(x, y);
        int index = this.findBestCompatible(target, lines, 0);
        if (index == -1) {
            return false;
        }
        LineSegment2D_F32 b = lines.remove(index);
        Point2D_F32 pt0 = this.farthestIndex < 2 ? target.a : target.b;
        Point2D_F32 pt1 = this.farthestIndex % 2 == 0 ? b.a : b.b;
        target.a.setTo(pt0);
        target.b.setTo(pt1);
        lines.add(target);
        return true;
    }

    private void connectInSameElement(List<LineSegment2D_F32> lines) {
        for (int i = 0; i < lines.size(); ++i) {
            LineSegment2D_F32 a = lines.get(i);
            int index = this.findBestCompatible(a, lines, i + 1);
            if (index == -1) continue;
            LineSegment2D_F32 b = lines.remove(index);
            Point2D_F32 pt0 = this.farthestIndex < 2 ? a.a : a.b;
            Point2D_F32 pt1 = this.farthestIndex % 2 == 0 ? b.a : b.b;
            a.a.setTo(pt0);
            a.b.setTo(pt1);
        }
    }

    private int findBestCompatible(LineSegment2D_F32 target, List<LineSegment2D_F32> candidates, int start) {
        int bestIndex = -1;
        double bestDistance = Double.MAX_VALUE;
        int bestFarthest = 0;
        float targetAngle = UtilAngle.atanSafe(target.slopeY(), target.slopeX());
        float cos = (float)Math.cos(targetAngle);
        float sin = (float)Math.sin(targetAngle);
        for (int i = start; i < candidates.size(); ++i) {
            LineSegment2D_F32 c = candidates.get(i);
            float angle = UtilAngle.atanSafe(c.slopeY(), c.slopeX());
            if (UtilAngle.distHalf(targetAngle, angle) > (double)this.lineSlopeAngleTol) continue;
            this.closestFarthestPoints(target, c);
            Point2D_F32 pt0 = this.closestIndex < 2 ? target.a : target.b;
            Point2D_F32 pt1 = this.closestIndex % 2 == 0 ? c.a : c.b;
            float xx = pt1.x - pt0.x;
            float yy = pt1.y - pt0.y;
            float distX = Math.abs(cos * xx - sin * yy);
            float distY = Math.abs(cos * yy + sin * xx);
            if ((double)distX >= bestDistance || distX > this.parallelTol || distY > this.tangentTol) continue;
            pt0 = this.farthestIndex < 2 ? target.a : target.b;
            pt1 = this.farthestIndex % 2 == 0 ? c.a : c.b;
            float angleCombined = UtilAngle.atanSafe(pt1.y - pt0.y, pt1.x - pt0.x);
            if (!(UtilAngle.distHalf(targetAngle, angleCombined) <= (double)this.lineSlopeAngleTol)) continue;
            bestDistance = distX;
            bestIndex = i;
            bestFarthest = this.farthestIndex;
        }
        if (bestDistance < (double)this.parallelTol) {
            this.farthestIndex = bestFarthest;
            return bestIndex;
        }
        return -1;
    }

    private void closestFarthestPoints(LineSegment2D_F32 a, LineSegment2D_F32 b) {
        this.dist[0] = a.a.distance2(b.a);
        this.dist[1] = a.a.distance2(b.b);
        this.dist[2] = a.b.distance2(b.a);
        this.dist[3] = a.b.distance2(b.b);
        this.farthestIndex = 0;
        float closest = this.dist[0];
        float farthest = this.dist[0];
        for (int i = 1; i < 4; ++i) {
            float d = this.dist[i];
            if (d < closest) {
                closest = d;
                this.closestIndex = i;
            }
            if (!(d > farthest)) continue;
            farthest = d;
            this.farthestIndex = i;
        }
    }
}

