/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.interest;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.detect.interest.SiftScaleSpace;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.struct.image.GrayF32;
import java.util.Objects;
import org.ddogleg.struct.DogArray;

public class UnrollSiftScaleSpaceGradient {
    DogArray<ImageScale> scales = new DogArray<ImageScale>(ImageScale::new);
    ImageGradient<GrayF32, GrayF32> gradient = FactoryDerivative.three(GrayF32.class, null);
    private int numScales;

    public void initialize(SiftScaleSpace scaleSpace) {
        this.numScales = scaleSpace.getNumScales();
        int numScales = scaleSpace.getNumScales() * scaleSpace.getTotalOctaves();
        this.scales.reserve(numScales);
        this.scales.reset();
        for (int octaveIdx = 0; octaveIdx < scaleSpace.octaves.length; ++octaveIdx) {
            int octave = octaveIdx + scaleSpace.firstOctave;
            for (int i = 0; i < scaleSpace.getNumScales(); ++i) {
                double sigma = scaleSpace.computeSigmaScale(octave, i);
                double pixelCurrentToInput = scaleSpace.pixelScaleCurrentToInput(octave);
                ImageScale scale = this.scales.grow();
                scale.imageToInput = pixelCurrentToInput;
                scale.sigma = sigma;
            }
        }
    }

    public void process(SiftScaleSpace scaleSpace) {
        int scaleIdx = 0;
        for (int octaveIdx = 0; octaveIdx < scaleSpace.octaves.length && !scaleSpace.isOctaveTooSmall(octaveIdx); ++octaveIdx) {
            SiftScaleSpace.Octave o = scaleSpace.octaves[octaveIdx];
            int i = 0;
            while (i < scaleSpace.getNumScales()) {
                GrayF32 scaleImage = o.scales[i + 1];
                ImageScale scale = (ImageScale)this.scales.get(scaleIdx);
                this.gradient.process(scaleImage, scale.derivX, scale.derivY);
                ++i;
                ++scaleIdx;
            }
        }
    }

    public ImageScale lookup(double sigma) {
        ImageScale best = null;
        double bestValue = Double.MAX_VALUE;
        for (int i = 0; i < this.scales.size(); ++i) {
            ImageScale image = (ImageScale)this.scales.get(i);
            double difference = Math.abs(sigma - image.sigma);
            if (!(difference < bestValue)) continue;
            bestValue = difference;
            best = image;
        }
        return Objects.requireNonNull(best);
    }

    public GrayF32 getDerivX(byte octaveIdx, byte scaleIdx) {
        return ((ImageScale)this.scales.get((int)(octaveIdx * this.numScales + scaleIdx))).derivX;
    }

    public GrayF32 getDerivY(byte octaveIdx, byte scaleIdx) {
        return ((ImageScale)this.scales.get((int)(octaveIdx * this.numScales + scaleIdx))).derivY;
    }

    public static class ImageScale {
        public GrayF32 derivX = new GrayF32(1, 1);
        public GrayF32 derivY = new GrayF32(1, 1);
        public double imageToInput;
        public double sigma;
    }
}

