/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.edge;

import boofcv.abst.filter.blur.BlurFilter;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.detect.edge.EdgeContour;
import boofcv.alg.feature.detect.edge.EdgeSegment;
import boofcv.alg.feature.detect.edge.GGradientToEdgeFeatures;
import boofcv.alg.feature.detect.edge.GradientToEdgeFeatures;
import boofcv.alg.feature.detect.edge.HysteresisEdgeTraceMark;
import boofcv.alg.feature.detect.edge.HysteresisEdgeTracePoints;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_I32;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class CannyEdge<T extends ImageGray<T>, D extends ImageGray<D>> {
    private final BlurFilter<T> blur;
    private final ImageGradient<T, D> gradient;
    private final T blurred;
    private final D derivX;
    private final D derivY;
    private final GrayF32 intensity = new GrayF32(1, 1);
    protected GrayF32 suppressed = new GrayF32(1, 1);
    private final GrayF32 angle = new GrayF32(1, 1);
    private final GrayS8 direction = new GrayS8(1, 1);
    private final GrayU8 work = new GrayU8(1, 1);
    protected HysteresisEdgeTracePoints hysteresisPts;
    protected HysteresisEdgeTraceMark hysteresisMark;

    public CannyEdge(BlurFilter<T> blur, ImageGradient<T, D> gradient, boolean saveTrace) {
        this.blur = blur;
        this.gradient = gradient;
        Class imageType = blur.getInputType().getImageClass();
        this.blurred = GeneralizedImageOps.createSingleBand(imageType, 1, 1);
        this.derivX = (ImageGray)gradient.getDerivativeType().createImage(1, 1);
        this.derivY = (ImageGray)gradient.getDerivativeType().createImage(1, 1);
        if (saveTrace) {
            this.hysteresisPts = new HysteresisEdgeTracePoints();
        } else {
            this.hysteresisMark = new HysteresisEdgeTraceMark();
        }
    }

    public void process(T input, float threshLow, float threshHigh, @Nullable GrayU8 output) {
        if (output != null) {
            output.reshape((ImageBase)input);
        }
        if (threshLow < 0.0f || threshHigh < 0.0f) {
            throw new IllegalArgumentException("Threshold must be >= zero!");
        }
        if (this.hysteresisMark != null && output == null) {
            throw new IllegalArgumentException("An output image must be specified when configured to mark edge points");
        }
        ((ImageGray)this.blurred).reshape(((ImageGray)input).width, ((ImageGray)input).height);
        ((ImageGray)this.derivX).reshape(((ImageGray)input).width, ((ImageGray)input).height);
        ((ImageGray)this.derivY).reshape(((ImageGray)input).width, ((ImageGray)input).height);
        this.intensity.reshape(((ImageGray)input).width, ((ImageGray)input).height);
        this.suppressed.reshape(((ImageGray)input).width, ((ImageGray)input).height);
        this.angle.reshape(((ImageGray)input).width, ((ImageGray)input).height);
        this.direction.reshape(((ImageGray)input).width, ((ImageGray)input).height);
        this.work.reshape(((ImageGray)input).width, ((ImageGray)input).height);
        this.blur.process(input, this.blurred);
        this.gradient.process(this.blurred, this.derivX, this.derivY);
        GGradientToEdgeFeatures.intensityAbs(this.derivX, this.derivY, this.intensity);
        GGradientToEdgeFeatures.direction(this.derivX, this.derivY, this.angle);
        GradientToEdgeFeatures.discretizeDirection4(this.angle, this.direction);
        GradientToEdgeFeatures.nonMaxSuppression4(this.intensity, this.direction, this.suppressed);
        this.performThresholding(threshLow, threshHigh, output);
    }

    protected void performThresholding(float threshLow, float threshHigh, @Nullable GrayU8 output) {
        if (this.hysteresisPts != null) {
            this.hysteresisPts.process(this.suppressed, this.direction, threshLow, threshHigh);
            if (output != null) {
                ImageMiscOps.fill(output, 0);
                for (EdgeContour e : this.hysteresisPts.getContours()) {
                    for (EdgeSegment s : e.segments) {
                        for (Point2D_I32 p : s.points) {
                            output.unsafe_set(p.x, p.y, 1);
                        }
                    }
                }
            }
        } else {
            this.hysteresisMark.process(this.suppressed, this.direction, threshLow, threshHigh, Objects.requireNonNull(output));
        }
    }

    public List<EdgeContour> getContours() {
        return this.hysteresisPts.getContours();
    }
}

