/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.describe;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.descriptor.UtilFeature;
import boofcv.alg.feature.describe.DescribePointSurf;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.Planar;

public class DescribePointSurfPlanar<II extends ImageGray<II>> {
    private final DescribePointSurf<II> describe;
    private final int descriptorLength;
    private II grayII;
    private Planar<II> colorII;
    private final TupleDesc_F64 bandDesc;
    private final int numBands;

    public DescribePointSurfPlanar(DescribePointSurf<II> describe, int numBands) {
        this.describe = describe;
        this.numBands = numBands;
        this.bandDesc = new TupleDesc_F64(describe.getDescriptionLength());
        this.descriptorLength = describe.getDescriptionLength() * numBands;
    }

    public TupleDesc_F64 createDescription() {
        return new TupleDesc_F64(this.descriptorLength);
    }

    public int getDescriptorLength() {
        return this.descriptorLength;
    }

    public Class<TupleDesc_F64> getDescriptionType() {
        return TupleDesc_F64.class;
    }

    public void setImage(II grayII, Planar<II> colorII) {
        InputSanityCheck.checkSameShape(grayII, colorII);
        if (colorII.getNumBands() != this.numBands) {
            throw new IllegalArgumentException("Expected planar images to have " + this.numBands + " not " + colorII.getNumBands());
        }
        this.grayII = grayII;
        this.colorII = colorII;
    }

    public void describe(double x, double y, double angle, double scale, TupleDesc_F64 desc) {
        int featureIndex = 0;
        for (int band = 0; band < this.colorII.getNumBands(); ++band) {
            this.describe.setImage(this.colorII.getBand(band));
            this.describe.describe(x, y, angle, scale, false, this.bandDesc);
            System.arraycopy(this.bandDesc.data, 0, desc.data, featureIndex, this.bandDesc.size());
            featureIndex += this.bandDesc.size();
        }
        UtilFeature.normalizeL2(desc);
        this.describe.setImage(this.grayII);
    }

    public DescribePointSurf<II> getDescribe() {
        return this.describe;
    }

    public int getNumBands() {
        return this.numBands;
    }

    public DescribePointSurfPlanar<II> copy() {
        return new DescribePointSurfPlanar<II>(this.describe.copy(), this.numBands);
    }
}

