/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.pinhole;

import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.distort.PixelTransform;
import georegression.struct.point.Point2D_F64;

public class PixelTransformPinholeNorm_F64
implements PixelTransform<Point2D_F64> {
    private double a11;
    private double a12;
    private double a13;
    private double a22;
    private double a23;

    public PixelTransformPinholeNorm_F64(PixelTransformPinholeNorm_F64 original) {
        this.a11 = original.a11;
        this.a12 = original.a12;
        this.a13 = original.a13;
        this.a22 = original.a22;
        this.a23 = original.a23;
    }

    public PixelTransformPinholeNorm_F64() {
    }

    public PixelTransformPinholeNorm_F64 fset(CameraPinhole pinhole) {
        return this.fset(pinhole.fx, pinhole.fy, pinhole.skew, pinhole.cx, pinhole.cy);
    }

    public PixelTransformPinholeNorm_F64 fset(double fx, double fy, double skew, double cx, double cy) {
        this.a11 = 1.0 / fx;
        this.a12 = -skew / (fx * fy);
        this.a13 = (skew * cy - cx * fy) / (fx * fy);
        this.a22 = 1.0 / fy;
        this.a23 = -cy / fy;
        return this;
    }

    @Override
    public void compute(int x, int y, Point2D_F64 out) {
        out.x = this.a11 * (double)x + this.a12 * (double)y + this.a13;
        out.y = this.a22 * (double)y + this.a23;
    }

    public PixelTransformPinholeNorm_F64 copyConcurrent() {
        return new PixelTransformPinholeNorm_F64(this);
    }
}

