/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.brown;

import boofcv.alg.distort.brown.RadialTangential_F64;
import boofcv.struct.distort.Point2Transform2_F64;
import georegression.struct.point.Point2D_F64;
import org.jetbrains.annotations.Nullable;

public class AddBrownNtoN_F64
implements Point2Transform2_F64 {
    private RadialTangential_F64 params;

    public AddBrownNtoN_F64 setDistortion(@Nullable double[] radial, double t1, double t2) {
        this.params = new RadialTangential_F64(radial, t1, t2);
        return this;
    }

    @Override
    public void compute(double x, double y, Point2D_F64 out) {
        double r2;
        double[] radial = this.params.radial;
        double t1 = this.params.t1;
        double t2 = this.params.t2;
        double ri2 = r2 = x * x + y * y;
        double sum = 0.0;
        for (int i = 0; i < radial.length; ++i) {
            sum += radial[i] * ri2;
            ri2 *= r2;
        }
        out.x = x * (1.0 + sum) + 2.0 * t1 * x * y + t2 * (r2 + 2.0 * x * x);
        out.y = y * (1.0 + sum) + t1 * (r2 + 2.0 * y * y) + 2.0 * t2 * x * y;
    }

    @Override
    public AddBrownNtoN_F64 copyConcurrent() {
        AddBrownNtoN_F64 ret = new AddBrownNtoN_F64();
        ret.params = new RadialTangential_F64(this.params);
        return ret;
    }
}

