/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.disparity.block.select;

import boofcv.alg.disparity.block.DisparitySelect;
import boofcv.alg.disparity.block.SelectDisparityWithChecksWta;
import boofcv.misc.Compare_F32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;

public abstract class SelectErrorWithChecks_F32<DI extends ImageGray<DI>>
extends SelectDisparityWithChecksWta<float[], DI>
implements Compare_F32 {
    float[] columnScore = new float[1];
    int imageWidth;
    protected float textureThreshold;

    protected SelectErrorWithChecks_F32(int maxError, int rightToLeftTolerance, double texture, Class<DI> disparityType) {
        super(maxError, rightToLeftTolerance, texture, disparityType);
        this.disparityType = disparityType;
    }

    protected SelectErrorWithChecks_F32(SelectErrorWithChecks_F32<DI> original) {
        this(original.maxError, original.rightToLeftTolerance, original.textureThreshold, original.disparityType);
    }

    @Override
    public void setTexture(double threshold) {
        this.textureThreshold = (float)threshold;
    }

    @Override
    public void configure(DI imageDisparity, int disparityMin, int disparityMax, int radiusX) {
        super.configure(imageDisparity, disparityMin, disparityMax, radiusX);
        this.columnScore = new float[this.disparityRange];
        this.imageWidth = ((ImageGray)imageDisparity).width;
    }

    @Override
    public void process(int row, float[] scores) {
        int col;
        int indexDisparity = this.imageDisparity.startIndex + row * this.imageDisparity.stride;
        for (col = 0; col < this.disparityMin; ++col) {
            this.setDisparityInvalid(indexDisparity++);
        }
        for (col = this.disparityMin; col < this.imageWidth; ++col) {
            int disparityRtoL;
            this.localRange = this.disparityMaxAtColumnL2R(col) - this.disparityMin + 1;
            int indexScore = col - this.disparityMin;
            int bestDisparity = 0;
            float scoreBest = this.columnScore[0] = scores[indexScore];
            indexScore += this.imageWidth;
            int i = 1;
            while (i < this.localRange) {
                float s;
                this.columnScore[i] = s = scores[indexScore];
                if (s < scoreBest) {
                    scoreBest = s;
                    bestDisparity = i;
                }
                ++i;
                indexScore += this.imageWidth;
            }
            if (scoreBest > (float)this.maxError) {
                bestDisparity = this.invalidDisparity;
            } else if (this.rightToLeftTolerance >= 0 && Math.abs((disparityRtoL = this.selectRightToLeft(col - bestDisparity - this.disparityMin, scores)) - bestDisparity) > this.rightToLeftTolerance) {
                bestDisparity = this.invalidDisparity;
            }
            if (this.textureThreshold > 0.0f && bestDisparity != this.invalidDisparity && this.localRange >= 3) {
                int i2;
                float secondBest = Float.MAX_VALUE;
                for (i2 = 0; i2 < bestDisparity - 1; ++i2) {
                    if (!(this.columnScore[i2] < secondBest)) continue;
                    secondBest = this.columnScore[i2];
                }
                for (i2 = bestDisparity + 2; i2 < this.localRange; ++i2) {
                    if (!(this.columnScore[i2] < secondBest)) continue;
                    secondBest = this.columnScore[i2];
                }
                if (secondBest - scoreBest <= this.textureThreshold * scoreBest) {
                    bestDisparity = this.invalidDisparity;
                }
            }
            this.setDisparity(indexDisparity++, bestDisparity);
        }
    }

    private int selectRightToLeft(int col, float[] scores) {
        int maxLocalDisparity = Math.min(this.imageWidth, col + this.disparityMax + 1) - col - this.disparityMin;
        int indexBest = 0;
        int indexScore = col;
        float scoreBest = scores[col];
        indexScore += this.imageWidth + 1;
        int i = 1;
        while (i < maxLocalDisparity) {
            float s = scores[indexScore];
            if (s < scoreBest) {
                scoreBest = s;
                indexBest = i;
            }
            ++i;
            indexScore += this.imageWidth + 1;
        }
        return indexBest;
    }

    @Override
    public int compare(float scoreA, float scoreB) {
        return Float.compare(-scoreA, -scoreB);
    }

    public static class DispU8
    extends SelectErrorWithChecks_F32<GrayU8> {
        public DispU8(int maxError, int rightToLeftTolerance, double texture) {
            super(maxError, rightToLeftTolerance, texture, GrayU8.class);
        }

        public DispU8(DispU8 original) {
            super(original);
        }

        @Override
        public DisparitySelect<float[], GrayU8> concurrentCopy() {
            return new DispU8(this);
        }

        @Override
        protected void setDisparity(int index, int value) {
            ((GrayU8)this.imageDisparity).data[index] = (byte)value;
        }

        @Override
        protected void setDisparityInvalid(int index) {
            ((GrayU8)this.imageDisparity).data[index] = (byte)this.invalidDisparity;
        }
    }
}

