/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.color.impl;

import boofcv.alg.color.ColorXyz;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.Planar;

public class ImplColorXyz_MT {
    public static void rgbToXyz_F32(Planar<GrayF32> rgb, Planar<GrayF32> xyz) {
        xyz.reshapeTo(rgb);
        GrayF32 R = rgb.getBand(0);
        GrayF32 G = rgb.getBand(1);
        GrayF32 B = rgb.getBand(2);
        GrayF32 X2 = xyz.getBand(0);
        GrayF32 Y2 = xyz.getBand(1);
        GrayF32 Z2 = xyz.getBand(2);
        BoofConcurrency.loopFor(0, rgb.height, row -> {
            int indexXyz = xyz.startIndex + row * xyz.stride;
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int col = 0;
            while (col < xyz.width) {
                float r = (float)ColorXyz.invGamma(R.data[indexRgb] / 255.0f);
                float g = (float)ColorXyz.invGamma(G.data[indexRgb] / 255.0f);
                float b = (float)ColorXyz.invGamma(B.data[indexRgb] / 255.0f);
                X2.data[indexXyz] = 0.412453f * r + 0.35758f * g + 0.180423f * b;
                Y2.data[indexXyz] = 0.212671f * r + 0.71516f * g + 0.072169f * b;
                Z2.data[indexXyz] = 0.019334f * r + 0.119193f * g + 0.950227f * b;
                ++col;
                ++indexXyz;
                ++indexRgb;
            }
        });
    }

    public static void rgbToXyz_U8(Planar<GrayU8> rgb, Planar<GrayF32> xyz) {
        xyz.reshapeTo(rgb);
        GrayU8 R = rgb.getBand(0);
        GrayU8 G = rgb.getBand(1);
        GrayU8 B = rgb.getBand(2);
        GrayF32 X2 = xyz.getBand(0);
        GrayF32 Y2 = xyz.getBand(1);
        GrayF32 Z2 = xyz.getBand(2);
        BoofConcurrency.loopFor(0, rgb.height, row -> {
            int indexXyz = xyz.startIndex + row * xyz.stride;
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int col = 0;
            while (col < xyz.width) {
                float r = ColorXyz.table_invgamma_f[R.data[indexRgb] & 0xFF];
                float g = ColorXyz.table_invgamma_f[G.data[indexRgb] & 0xFF];
                float b = ColorXyz.table_invgamma_f[B.data[indexRgb] & 0xFF];
                X2.data[indexXyz] = 0.412453f * r + 0.35758f * g + 0.180423f * b;
                Y2.data[indexXyz] = 0.212671f * r + 0.71516f * g + 0.072169f * b;
                Z2.data[indexXyz] = 0.019334f * r + 0.119193f * g + 0.950227f * b;
                ++col;
                ++indexXyz;
                ++indexRgb;
            }
        });
    }

    public static void xyzToRgb_F32(Planar<GrayF32> xyz, Planar<GrayF32> rgb) {
        rgb.reshapeTo(xyz);
        GrayF32 X2 = xyz.getBand(0);
        GrayF32 Y2 = xyz.getBand(1);
        GrayF32 Z2 = xyz.getBand(2);
        GrayF32 R = rgb.getBand(0);
        GrayF32 G = rgb.getBand(1);
        GrayF32 B = rgb.getBand(2);
        BoofConcurrency.loopFor(0, xyz.height, row -> {
            int indexXyz = xyz.startIndex + row * xyz.stride;
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int col = 0;
            while (col < xyz.width) {
                float x = X2.data[indexXyz];
                float y = Y2.data[indexXyz];
                float z = Z2.data[indexXyz];
                R.data[indexRgb] = (float)(255.0 * ColorXyz.gamma(3.240479f * x - 1.53715f * y - 0.498535f * z));
                G.data[indexRgb] = (float)(255.0 * ColorXyz.gamma(-0.969256f * x + 1.875991f * y + 0.041556f * z));
                B.data[indexRgb] = (float)(255.0 * ColorXyz.gamma(0.055648f * x - 0.204043f * y + 1.057311f * z));
                ++col;
                ++indexXyz;
                ++indexRgb;
            }
        });
    }

    public static void xyzToRgb_U8(Planar<GrayF32> xyz, Planar<GrayU8> rgb) {
        rgb.reshapeTo(xyz);
        GrayF32 X2 = xyz.getBand(0);
        GrayF32 Y2 = xyz.getBand(1);
        GrayF32 Z2 = xyz.getBand(2);
        GrayU8 R = rgb.getBand(0);
        GrayU8 G = rgb.getBand(1);
        GrayU8 B = rgb.getBand(2);
        BoofConcurrency.loopFor(0, xyz.height, row -> {
            int indexXyz = xyz.startIndex + row * xyz.stride;
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int col = 0;
            while (col < xyz.width) {
                float x = X2.data[indexXyz];
                float y = Y2.data[indexXyz];
                float z = Z2.data[indexXyz];
                R.data[indexRgb] = (byte)(255.0 * ColorXyz.gamma(3.240479f * x - 1.53715f * y - 0.498535f * z) + 0.5);
                G.data[indexRgb] = (byte)(255.0 * ColorXyz.gamma(-0.969256f * x + 1.875991f * y + 0.041556f * z) + 0.5);
                B.data[indexRgb] = (byte)(255.0 * ColorXyz.gamma(0.055648f * x - 0.204043f * y + 1.057311f * z) + 0.5);
                ++col;
                ++indexXyz;
                ++indexRgb;
            }
        });
    }
}

