/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.cloud;

import boofcv.alg.cloud.AccessColorIndex;
import boofcv.alg.cloud.AccessPointIndex;
import boofcv.misc.BoofLambdas;
import boofcv.struct.Point3dRgbI_F64;
import georegression.helper.KdTreePoint3D_F64;
import georegression.struct.point.Point3D_F64;
import java.util.List;
import org.ddogleg.nn.FactoryNearestNeighbor;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.jetbrains.annotations.Nullable;

public class PointCloudUtils_F64 {
    public static DogArray<Point3dRgbI_F64> filter(AccessPointIndex<Point3D_F64> accessPoint, AccessColorIndex accessColor, int size, BoofLambdas.FilterInt filter, @Nullable DogArray<Point3dRgbI_F64> output) {
        if (output == null) {
            output = new DogArray<Point3dRgbI_F64>(Point3dRgbI_F64::new);
        }
        output.reset();
        output.reserve(size / 5);
        Point3dRgbI_F64 p = output.grow();
        for (int pointIdx = 0; pointIdx < size; ++pointIdx) {
            if (!filter.keep(pointIdx)) continue;
            accessPoint.getPoint(pointIdx, p);
            p.rgb = accessColor.getRGB(pointIdx);
            p = output.grow();
        }
        output.removeTail();
        return output;
    }

    public static double autoScale(List<Point3D_F64> cloud, double target) {
        Point3D_F64 mean = new Point3D_F64();
        Point3D_F64 stdev = new Point3D_F64();
        PointCloudUtils_F64.statistics(cloud, mean, stdev);
        double scale = target / Math.max(Math.max(stdev.x, stdev.y), stdev.z);
        int N = cloud.size();
        for (int i = 0; i < N; ++i) {
            cloud.get(i).scale(scale);
        }
        return scale;
    }

    public static void statistics(List<Point3D_F64> cloud, Point3D_F64 mean, Point3D_F64 stdev) {
        Point3D_F64 p;
        int i;
        int N = cloud.size();
        for (i = 0; i < N; ++i) {
            p = cloud.get(i);
            mean.x += p.x / (double)N;
            mean.y += p.y / (double)N;
            mean.z += p.z / (double)N;
        }
        for (i = 0; i < N; ++i) {
            p = cloud.get(i);
            double dx = p.x - mean.x;
            double dy = p.y - mean.y;
            double dz = p.z - mean.z;
            stdev.x += dx * dx / (double)N;
            stdev.y += dy * dy / (double)N;
            stdev.z += dz * dz / (double)N;
        }
        stdev.x = Math.sqrt(stdev.x);
        stdev.y = Math.sqrt(stdev.y);
        stdev.z = Math.sqrt(stdev.z);
    }

    public static void prune(List<Point3D_F64> cloud, int minNeighbors, double radius) {
        if (minNeighbors < 0) {
            throw new IllegalArgumentException("minNeighbors must be >= 0");
        }
        NearestNeighbor<Point3D_F64> nn = FactoryNearestNeighbor.kdtree(new KdTreePoint3D_F64());
        NearestNeighbor.Search<Point3D_F64> search = nn.createSearch();
        nn.setPoints(cloud, false);
        DogArray results = new DogArray(NnData::new);
        ++minNeighbors;
        radius *= radius;
        for (int i = cloud.size() - 1; i >= 0; --i) {
            search.findNearest(cloud.get(i), radius, minNeighbors, results);
            if (results.size >= minNeighbors) continue;
            cloud.remove(i);
        }
    }

    public static void prune(List<Point3D_F64> cloud, DogArray_I32 colors, int minNeighbors, double radius) {
        if (minNeighbors < 0) {
            throw new IllegalArgumentException("minNeighbors must be >= 0");
        }
        NearestNeighbor<Point3D_F64> nn = FactoryNearestNeighbor.kdtree(new KdTreePoint3D_F64());
        NearestNeighbor.Search<Point3D_F64> search = nn.createSearch();
        nn.setPoints(cloud, false);
        DogArray results = new DogArray(NnData::new);
        ++minNeighbors;
        radius *= radius;
        for (int i = cloud.size() - 1; i >= 0; --i) {
            search.findNearest(cloud.get(i), radius, minNeighbors, results);
            if (results.size >= minNeighbors) continue;
            cloud.remove(i);
            colors.remove(i);
        }
    }
}

