/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.stationary;

import boofcv.alg.background.stationary.BackgroundStationaryBasic;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.concurrency.BoofConcurrency;
import boofcv.core.image.FactoryGImageMultiBand;
import boofcv.core.image.GConvertImage;
import boofcv.core.image.GImageMultiBand;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.InterleavedF32;

public class BackgroundStationaryBasic_IL_MT<T extends ImageInterleaved<T>>
extends BackgroundStationaryBasic<T> {
    protected InterleavedF32 background;
    protected GImageMultiBand inputWrapper;

    public BackgroundStationaryBasic_IL_MT(float learnRate, float threshold, ImageType<T> imageType) {
        super(learnRate, threshold, imageType);
        int numBands = imageType.getNumBands();
        this.background = new InterleavedF32(0, 0, numBands);
        this.inputWrapper = FactoryGImageMultiBand.create(imageType);
    }

    public InterleavedF32 getBackground() {
        return this.background;
    }

    @Override
    public void reset() {
        this.background.reshape(0, 0);
    }

    @Override
    public void updateBackground(T frame) {
        if (this.background.width != ((ImageInterleaved)frame).width || this.background.height != ((ImageInterleaved)frame).height) {
            this.background.reshape(((ImageInterleaved)frame).width, ((ImageInterleaved)frame).height);
            GConvertImage.convert(frame, this.background);
            return;
        }
        this.inputWrapper.wrap((ImageBase)frame);
        int numBands = this.background.getNumBands();
        float minusLearn = 1.0f - this.learnRate;
        BoofConcurrency.loopFor(0, ((ImageInterleaved)frame).height, y -> {
            int indexBG = y * frame.width * numBands;
            int indexInput = frame.startIndex + y * frame.stride;
            int end = indexInput + frame.width * numBands;
            while (indexInput < end) {
                int endIndexBG = indexBG + numBands;
                while (indexBG < endIndexBG) {
                    float valueBG = this.background.data[indexBG];
                    this.background.data[indexBG] = minusLearn * valueBG + this.learnRate * this.inputWrapper.getF(indexInput);
                    ++indexBG;
                    ++indexInput;
                }
            }
        });
    }

    @Override
    public void segment(T frame, GrayU8 segmented) {
        segmented.reshape(((ImageInterleaved)frame).width, ((ImageInterleaved)frame).height);
        if (this.background.width != ((ImageInterleaved)frame).width || this.background.height != ((ImageInterleaved)frame).height) {
            ImageMiscOps.fill(segmented, (int)this.unknownValue);
            return;
        }
        this.inputWrapper.wrap((ImageBase)frame);
        int numBands = this.background.getNumBands();
        float thresholdSq = (float)numBands * this.threshold * this.threshold;
        BoofConcurrency.loopFor(0, ((ImageInterleaved)frame).height, y -> {
            int indexBG = y * frame.width * numBands;
            int indexInput = frame.startIndex + y * frame.stride;
            int indexSegmented = segmented.startIndex + y * segmented.stride;
            int end = indexInput + frame.width * numBands;
            while (indexInput < end) {
                float sumErrorSq = 0.0f;
                int endIndexBG = indexBG + numBands;
                while (indexBG < endIndexBG) {
                    float diff = this.background.data[indexBG++] - this.inputWrapper.getF(indexInput++);
                    sumErrorSq += diff * diff;
                }
                segmented.data[indexSegmented++] = (byte)(!(sumErrorSq <= thresholdSq) ? 1 : 0);
            }
        });
    }
}

